/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface Adaptable {
    public <T> T getAdapter(Class<T> var1);

    public static abstract class DefaultAdaptable
    implements Adaptable {
        private final List<Object> adapters;

        DefaultAdaptable(List<Object> adapters) {
            this.adapters = adapters;
        }

        @Override
        public <T> T getAdapter(Class<T> type2) {
            for (Object o2 : this.adapters) {
                if (type2 != o2.getClass()) continue;
                return (T)o2;
            }
            for (Object o2 : this.adapters) {
                if (!type2.isAssignableFrom(o2.getClass())) continue;
                return (T)o2;
            }
            return null;
        }

        public static abstract class Builder<B extends Builder<B>> {
            protected List<Object> adapters = null;

            public B adapter(Object adapter) {
                if (this.adapters == null) {
                    this.adapters = new ArrayList<Object>();
                }
                this.adapters.add(adapter);
                return (B)this;
            }

            public B adapters(Collection<Object> adapters) {
                if (this.adapters == null) {
                    this.adapters = new ArrayList<Object>(adapters);
                } else {
                    this.adapters.addAll(adapters);
                }
                return (B)this;
            }

            public B adapters(Object ... adapters) {
                if (this.adapters == null) {
                    this.adapters = new ArrayList<Object>(adapters.length);
                }
                for (Object adapter : adapters) {
                    this.adapters.add(adapter);
                }
                return (B)this;
            }

            protected List<Object> sealAdapters() {
                if (this.adapters == null) {
                    return Collections.emptyList();
                }
                List<Object> useAdapters = this.adapters;
                this.adapters = null;
                return Collections.unmodifiableList(useAdapters);
            }
        }
    }
}

