/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.parser;

import java.util.Locale;
import java.util.regex.PatternSyntaxException;
import org.ec4j.core.PropertyTypeRegistry;
import org.ec4j.core.model.Glob;
import org.ec4j.core.model.PropertyType;
import org.ec4j.core.parser.EditorConfigHandler;
import org.ec4j.core.parser.ErrorEvent;
import org.ec4j.core.parser.Location;
import org.ec4j.core.parser.ParseContext;

public abstract class AbstractValidatingHandler
implements EditorConfigHandler {
    protected Location globStart;
    protected Location propertyValueStart;
    protected final PropertyTypeRegistry registry;
    protected PropertyType<?> type;

    public AbstractValidatingHandler(PropertyTypeRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void endGlob(ParseContext context2, String globSource) {
        Glob glob = new Glob(globSource);
        PatternSyntaxException e2 = glob.getError();
        if (e2 != null) {
            String msg = String.format("The glob '%s' is not valid: %s", globSource, e2.getMessage());
            context2.getErrorHandler().error(context2, new ErrorEvent(this.globStart, context2.getLocation(), context2.getResource(), msg, ErrorEvent.ErrorType.INVALID_GLOB));
        }
        this.glob(context2, glob);
        this.globStart = null;
    }

    @Override
    public void endPropertyName(ParseContext context2, String name2) {
        name2 = this.normalizePropertyName(name2);
        this.type = this.registry.getType(name2);
        if (this.type != null) {
            this.type(context2, this.type);
        } else {
            this.name(context2, name2);
        }
    }

    @Override
    public void endPropertyValue(ParseContext context2, String value2) {
        PropertyType.PropertyValue<String> propValue;
        PropertyType.PropertyValue<String> propertyValue = propValue = this.type == null ? PropertyType.PropertyValue.valid(value2, value2) : this.type.parse(value2);
        if (!propValue.isValid()) {
            context2.getErrorHandler().error(context2, new ErrorEvent(this.propertyValueStart, context2.getLocation(), context2.getResource(), propValue.getErrorMessage(), ErrorEvent.ErrorType.INVALID_PROPERTY_VALUE));
        }
        this.propertyValue(context2, propValue);
        this.type = null;
        this.propertyValueStart = null;
    }

    protected abstract void glob(ParseContext var1, Glob var2);

    protected abstract void name(ParseContext var1, String var2);

    protected String normalizePropertyName(String name2) {
        return name2 == null ? null : name2.toLowerCase(Locale.US);
    }

    protected abstract void propertyValue(ParseContext var1, PropertyType.PropertyValue<?> var2);

    @Override
    public void startGlob(ParseContext context2) {
        this.globStart = context2.getLocation();
    }

    @Override
    public void startPropertyName(ParseContext context2) {
    }

    @Override
    public void startPropertyValue(ParseContext context2) {
        this.propertyValueStart = context2.getLocation();
    }

    protected abstract void type(ParseContext var1, PropertyType<?> var2);
}

