/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.fasterxml.aalto.in;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.jetbrains.kotlin.com.fasterxml.aalto.impl.ErrorConsts;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.ElementScope;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.PName;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.PNameC;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.ReaderConfig;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.StreamScanner;
import org.jetbrains.kotlin.com.fasterxml.aalto.util.DataUtil;
import org.jetbrains.kotlin.com.fasterxml.aalto.util.XmlCharTypes;
import org.jetbrains.kotlin.com.fasterxml.aalto.util.XmlChars;

public final class Utf8Scanner
extends StreamScanner {
    public Utf8Scanner(ReaderConfig cfg, InputStream in, byte[] buffer, int ptr, int last2) {
        super(cfg, in, buffer, ptr, last2);
    }

    @Override
    protected final void finishToken() throws XMLStreamException {
        this._tokenIncomplete = false;
        switch (this._currToken) {
            case 3: {
                this.finishPI();
                break;
            }
            case 4: {
                this.finishCharacters();
                break;
            }
            case 5: {
                this.finishComment();
                break;
            }
            case 6: {
                this.finishSpace();
                break;
            }
            case 11: {
                this.finishDTD(true);
                break;
            }
            case 12: {
                this.finishCData();
                break;
            }
            default: {
                ErrorConsts.throwInternalError();
            }
        }
    }

    @Override
    protected int handleStartElement(byte b2) throws XMLStreamException {
        boolean allBound;
        this._currToken = 1;
        this._currNsCount = 0;
        PName elemName = this.parsePName(b2);
        String prefix = elemName.getPrefix();
        if (prefix == null) {
            allBound = true;
        } else {
            elemName = this.bindName(elemName, prefix);
            allBound = elemName.isBound();
        }
        this._tokenName = elemName;
        this._currElem = new ElementScope(elemName, this._currElem);
        int attrPtr = 0;
        while (true) {
            boolean isNsDecl;
            PName attrName;
            int c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = (b2 = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32) {
                do {
                    if (c2 == 10) {
                        this.markLF();
                    } else if (c2 == 13) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                    } else if (c2 != 32 && c2 != 9) {
                        this.throwInvalidSpace(c2);
                    }
                    if (this._inputPtr < this._inputEnd) continue;
                    this.loadMoreGuaranteed();
                } while ((c2 = (b2 = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32);
            } else if (c2 != 47 && c2 != 62) {
                c2 = this.decodeCharForError(b2);
                this.throwUnexpectedChar(c2, " expected space, or '>' or \"/>\"");
            }
            if (c2 == 47) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((b2 = this._inputBuffer[this._inputPtr++]) != 62) {
                    c2 = this.decodeCharForError(b2);
                    this.throwUnexpectedChar(c2, " expected '>'");
                }
                this._isEmptyTag = true;
                break;
            }
            if (c2 == 62) {
                this._isEmptyTag = false;
                break;
            }
            if (c2 == 60) {
                this.reportInputProblem("Unexpected '<' character in element (missing closing '>'?)");
            }
            if ((prefix = (attrName = this.parsePName(b2)).getPrefix()) == null) {
                isNsDecl = attrName.getLocalName() == "xmlns";
            } else if (prefix == "xmlns") {
                isNsDecl = true;
            } else {
                attrName = this.bindName(attrName, prefix);
                if (allBound) {
                    allBound = attrName.isBound();
                }
                isNsDecl = false;
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c2 = (b2 = this._inputBuffer[this._inputPtr++]) & 0xFF) > 32) break;
                if (c2 == 10) {
                    this.markLF();
                    continue;
                }
                if (c2 == 13) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (c2 == 32 || c2 == 9) continue;
                this.throwInvalidSpace(c2);
            }
            if (c2 != 61) {
                c2 = this.decodeCharForError(b2);
                this.throwUnexpectedChar(c2, " expected '='");
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c2 = (b2 = this._inputBuffer[this._inputPtr++]) & 0xFF) > 32) break;
                if (c2 == 10) {
                    this.markLF();
                    continue;
                }
                if (c2 == 13) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (c2 == 32 || c2 == 9) continue;
                this.throwInvalidSpace(c2);
            }
            if (c2 != 34 && c2 != 39) {
                c2 = this.decodeCharForError(b2);
                this.throwUnexpectedChar(c2, " Expected a quote");
            }
            if (isNsDecl) {
                this.handleNsDeclaration(attrName, b2);
                ++this._currNsCount;
                continue;
            }
            attrPtr = this.collectValue(attrPtr, b2, attrName);
        }
        int act = this._attrCollector.finishLastValue(attrPtr);
        if (act < 0) {
            act = this._attrCollector.getCount();
            this.reportInputProblem(this._attrCollector.getErrorMsg());
        }
        this._attrCount = act;
        ++this._depth;
        if (!allBound) {
            if (!elemName.isBound()) {
                this.reportUnboundPrefix(this._tokenName, false);
            }
            int len = this._attrCount;
            for (int i2 = 0; i2 < len; ++i2) {
                PName attrName = this._attrCollector.getName(i2);
                if (attrName.isBound()) continue;
                this.reportUnboundPrefix(attrName, true);
            }
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    private final int collectValue(int attrPtr, byte quoteByte, PName attrName) throws XMLStreamException {
        attrBuffer = this._attrCollector.startNewValue(attrName, attrPtr);
        TYPES = this._charTypes.ATTR_CHARS;
        quoteChar = quoteByte;
        block13: while (true) {
            block25: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (attrPtr >= attrBuffer.length) {
                    attrBuffer = this._attrCollector.valueBufferFull();
                }
                if ((max2 = ptr + (attrBuffer.length - attrPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = this._inputBuffer[ptr++] & 255] == 0) {
                        attrBuffer[attrPtr++] = (char)c;
                        continue;
                    }
                    break block25;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                }
                case 3: {
                    this.markLF();
                }
                case 8: {
                    c = 32;
                    ** GOTO lbl63
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl63
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl63
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    attrBuffer[attrPtr++] = (char)(55296 | c >> 10);
                    c = 56320 | c & 1023;
                    if (attrPtr >= attrBuffer.length) {
                        attrBuffer = this._attrCollector.valueBufferFull();
                    }
                    ** GOTO lbl63
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    this.throwUnexpectedChar(c, "'<' not allowed in attribute value");
                }
                case 10: {
                    c = this.handleEntityInText(false);
                    if (c == 0) {
                        this.reportUnexpandedEntityInAttr(attrName, false);
                    }
                    if (c >> 16 != 0) {
                        attrBuffer[attrPtr++] = (char)(55296 | (c -= 65536) >> 10);
                        c = 56320 | c & 1023;
                        if (attrPtr >= attrBuffer.length) {
                            attrBuffer = this._attrCollector.valueBufferFull();
                        }
                    }
                    ** GOTO lbl63
                }
                case 14: {
                    if (c == quoteChar) break block13;
                }
lbl63:
                // 7 sources

                default: {
                    attrBuffer[attrPtr++] = (char)c;
                    continue block13;
                }
            }
            break;
        }
        return attrPtr;
    }

    private void handleNsDeclaration(PName name2, byte quoteByte) throws XMLStreamException {
        int attrPtr = 0;
        char[] attrBuffer = this._nameBuffer;
        while (true) {
            int c2;
            int b2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b2 = this._inputBuffer[this._inputPtr++]) == quoteByte) break;
            if (b2 == 38) {
                c2 = this.handleEntityInText(false);
                if (c2 == 0) {
                    this.reportUnexpandedEntityInAttr(name2, true);
                }
                if (c2 >> 16 != 0) {
                    if (attrPtr >= attrBuffer.length) {
                        this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
                    }
                    attrBuffer[attrPtr++] = (char)(0xD800 | (c2 -= 65536) >> 10);
                    c2 = 0xDC00 | c2 & 0x3FF;
                }
            } else if (b2 == 60) {
                c2 = b2;
                this.throwUnexpectedChar(c2, "'<' not allowed in attribute value");
            } else {
                c2 = b2 & 0xFF;
                if (c2 < 32) {
                    if (c2 == 10) {
                        this.markLF();
                    } else if (c2 == 13) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                    } else if (c2 != 9) {
                        this.throwInvalidSpace(c2);
                    }
                } else if (c2 > 127 && (c2 = this.decodeMultiByteChar(c2, this._inputPtr)) < 0) {
                    c2 = -c2;
                    if (attrPtr >= attrBuffer.length) {
                        this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
                    }
                    attrBuffer[attrPtr++] = (char)(0xD800 | (c2 -= 65536) >> 10);
                    c2 = 0xDC00 | c2 & 0x3FF;
                }
            }
            if (attrPtr >= attrBuffer.length) {
                this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
            }
            attrBuffer[attrPtr++] = (char)c2;
        }
        if (attrPtr == 0) {
            this.bindNs(name2, "");
        } else {
            String uri = this._config.canonicalizeURI(attrBuffer, attrPtr);
            this.bindNs(name2, uri);
        }
    }

    @Override
    protected final int handleEntityInText(boolean inAttr) throws XMLStreamException {
        int cix;
        String start;
        byte b2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((b2 = this._inputBuffer[this._inputPtr++]) == 35) {
            return this.handleCharEntity();
        }
        if (b2 == 97) {
            byte by = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (b2 == 109) {
                byte by2 = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b2 == 112) {
                    byte by3 = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                    if (b2 == 59) {
                        return 38;
                    }
                    start = "amp";
                } else {
                    start = "am";
                }
            } else if (b2 == 112) {
                byte by4 = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b2 == 111) {
                    byte by5 = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                    if (b2 == 115) {
                        byte by6 = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                        if (b2 == 59) {
                            return 39;
                        }
                        start = "apos";
                    } else {
                        start = "apo";
                    }
                } else {
                    start = "ap";
                }
            } else {
                start = "a";
            }
        } else if (b2 == 108) {
            byte by = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (b2 == 116) {
                byte by7 = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b2 == 59) {
                    return 60;
                }
                start = "lt";
            } else {
                start = "l";
            }
        } else if (b2 == 103) {
            byte by = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (b2 == 116) {
                byte by8 = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b2 == 59) {
                    return 62;
                }
                start = "gt";
            } else {
                start = "g";
            }
        } else if (b2 == 113) {
            byte by = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (b2 == 117) {
                byte by9 = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b2 == 111) {
                    byte by10 = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                    if (b2 == 116) {
                        byte by11 = b2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                        if (b2 == 59) {
                            return 34;
                        }
                        start = "quot";
                    } else {
                        start = "quo";
                    }
                } else {
                    start = "qu";
                }
            } else {
                start = "q";
            }
        } else {
            start = "";
        }
        int[] TYPES = this._charTypes.NAME_CHARS;
        char[] cbuf = this._nameBuffer;
        int len = start.length();
        for (cix = 0; cix < len; ++cix) {
            cbuf[cix] = start.charAt(cix);
        }
        while (b2 != 59) {
            boolean ok;
            int c2 = b2 & 0xFF;
            switch (TYPES[c2]) {
                case 0: 
                case 1: 
                case 2: {
                    ok = cix > 0;
                    break;
                }
                case 3: {
                    ok = true;
                    break;
                }
                case 5: {
                    c2 = this.decodeUtf8_2(c2);
                    ok = XmlChars.is10NameStartChar(c2);
                    break;
                }
                case 6: {
                    c2 = this.decodeUtf8_3(c2);
                    ok = XmlChars.is10NameStartChar(c2);
                    break;
                }
                case 7: {
                    c2 = this.decodeUtf8_4(c2);
                    ok = XmlChars.is10NameStartChar(c2);
                    if (!ok) break;
                    if (cix >= cbuf.length) {
                        this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
                    }
                    cbuf[cix++] = (char)(0xD800 | (c2 -= 65536) >> 10);
                    c2 = 0xDC00 | c2 & 0x3FF;
                    break;
                }
                default: {
                    ok = false;
                }
            }
            if (!ok) {
                this.reportInvalidNameChar(c2, cix);
            }
            if (cix >= cbuf.length) {
                this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
            }
            cbuf[cix++] = (char)c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            b2 = this._inputBuffer[this._inputPtr++];
        }
        String pname = new String(cbuf, 0, cix);
        this._tokenName = new PNameC(pname, null, pname, 0);
        if (this._config.willExpandEntities()) {
            this.reportInputProblem("General entity reference (&" + pname + ";) encountered in entity expanding mode: operation not (yet) implemented");
        }
        if (inAttr) {
            this.reportInputProblem("General entity reference (&" + pname + ";) encountered in attribute value, in non-entity-expanding mode: no way to handle it");
        }
        return 0;
    }

    @Override
    protected String parsePublicId(byte quoteChar) throws XMLStreamException {
        char[] outputBuffer = this._nameBuffer;
        int outPtr = 0;
        int[] TYPES = XmlCharTypes.PUBID_CHARS;
        boolean addSpace = false;
        while (true) {
            byte b2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b2 = this._inputBuffer[this._inputPtr++]) == quoteChar) break;
            int c2 = b2 & 0xFF;
            if (TYPES[c2] != 1) {
                this.throwUnexpectedChar(c2, " in public identifier");
            }
            if (c2 <= 32) {
                addSpace = true;
                continue;
            }
            if (addSpace) {
                if (outPtr >= outputBuffer.length) {
                    this._nameBuffer = outputBuffer = DataUtil.growArrayBy(outputBuffer, outputBuffer.length);
                    outPtr = 0;
                }
                outputBuffer[outPtr++] = 32;
                addSpace = false;
            }
            if (outPtr >= outputBuffer.length) {
                this._nameBuffer = outputBuffer = DataUtil.growArrayBy(outputBuffer, outputBuffer.length);
                outPtr = 0;
            }
            outputBuffer[outPtr++] = (char)c2;
        }
        return new String(outputBuffer, 0, outPtr);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected String parseSystemId(byte quoteChar) throws XMLStreamException {
        char[] outputBuffer = this._nameBuffer;
        int outPtr = 0;
        int[] TYPES = this._charTypes.ATTR_CHARS;
        while (true) {
            int c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (TYPES[c2 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                switch (TYPES[c2]) {
                    case 1: {
                        c2 = this.handleInvalidXmlChar(c2);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 5: {
                        c2 = this.decodeUtf8_2(c2);
                        break;
                    }
                    case 6: {
                        c2 = this.decodeUtf8_3(c2);
                        break;
                    }
                    case 7: {
                        c2 = this.decodeUtf8_4(c2);
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        outputBuffer[outPtr++] = (char)(0xD800 | c2 >> 10);
                        c2 = 0xDC00 | c2 & 0x3FF;
                        break;
                    }
                    case 4: {
                        this.reportInvalidInitial(c2);
                    }
                    case 14: {
                        if (c2 != quoteChar) break;
                        return new String(outputBuffer, 0, outPtr);
                    }
                }
            }
            if (outPtr >= outputBuffer.length) {
                this._nameBuffer = outputBuffer = DataUtil.growArrayBy(outputBuffer, outputBuffer.length);
                outPtr = 0;
            }
            outputBuffer[outPtr++] = (char)c2;
        }
    }

    @Override
    protected final boolean skipCharacters() throws XMLStreamException {
        int[] TYPES = this._charTypes.TEXT_CHARS;
        byte[] inputBuffer = this._inputBuffer;
        block12: while (true) {
            int c2;
            int ptr;
            block19: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if (TYPES[c2 = inputBuffer[ptr++] & 0xFF] == 0) continue;
                    break block19;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c2]) {
                case 1: {
                    c2 = this.handleInvalidXmlChar(c2);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2(c2);
                    break;
                }
                case 6: {
                    this.skipUtf8_3(c2);
                    break;
                }
                case 7: {
                    this.skipUtf8_4(c2);
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(c2);
                }
                case 9: {
                    --this._inputPtr;
                    return false;
                }
                case 10: {
                    c2 = this.handleEntityInText(false);
                    if (c2 != 0) break;
                    return true;
                }
                case 11: {
                    byte b2;
                    int count2 = 1;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b2 = inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count2;
                    }
                    if (b2 != 62 || count2 <= true) continue block12;
                    this.reportIllegalCDataEnd();
                }
            }
        }
    }

    @Override
    protected final void skipComment() throws XMLStreamException {
        int[] TYPES = this._charTypes.OTHER_CHARS;
        byte[] inputBuffer = this._inputBuffer;
        while (true) {
            int c2;
            int ptr;
            block18: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if (TYPES[c2 = inputBuffer[ptr++] & 0xFF] == 0) continue;
                    break block18;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c2]) {
                case 1: {
                    c2 = this.handleInvalidXmlChar(c2);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2(c2);
                    break;
                }
                case 6: {
                    this.skipUtf8_3(c2);
                    break;
                }
                case 7: {
                    this.skipUtf8_4(c2);
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(c2);
                }
                case 13: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] != 45) break;
                    ++this._inputPtr;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr++] != 62) {
                        this.reportDoubleHyphenInComments();
                    }
                    return;
                }
            }
        }
    }

    @Override
    protected final void skipCData() throws XMLStreamException {
        int[] TYPES = this._charTypes.OTHER_CHARS;
        byte[] inputBuffer = this._inputBuffer;
        while (true) {
            int c2;
            int ptr;
            block18: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if (TYPES[c2 = inputBuffer[ptr++] & 0xFF] == 0) continue;
                    break block18;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c2]) {
                case 1: {
                    c2 = this.handleInvalidXmlChar(c2);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2(c2);
                    break;
                }
                case 6: {
                    this.skipUtf8_3(c2);
                    break;
                }
                case 7: {
                    this.skipUtf8_4(c2);
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(c2);
                }
                case 11: {
                    byte b2;
                    int count2 = 0;
                    do {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        ++count2;
                    } while ((b2 = this._inputBuffer[this._inputPtr++]) == 93);
                    if (b2 == 62) {
                        if (count2 <= 1) break;
                        return;
                    }
                    --this._inputPtr;
                }
            }
        }
    }

    @Override
    protected final void skipPI() throws XMLStreamException {
        int[] TYPES = this._charTypes.OTHER_CHARS;
        byte[] inputBuffer = this._inputBuffer;
        while (true) {
            int c2;
            int ptr;
            block16: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if (TYPES[c2 = inputBuffer[ptr++] & 0xFF] == 0) continue;
                    break block16;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c2]) {
                case 1: {
                    c2 = this.handleInvalidXmlChar(c2);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2(c2);
                    break;
                }
                case 6: {
                    this.skipUtf8_3(c2);
                    break;
                }
                case 7: {
                    this.skipUtf8_4(c2);
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(c2);
                }
                case 12: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] != 62) break;
                    ++this._inputPtr;
                    return;
                }
            }
        }
    }

    @Override
    protected final void skipSpace() throws XMLStreamException {
        int ptr = this._inputPtr;
        while (true) {
            int c2;
            if (ptr >= this._inputEnd) {
                if (!this.loadMore()) break;
                ptr = this._inputPtr;
            }
            if ((c2 = this._inputBuffer[ptr] & 0xFF) > 32) break;
            ++ptr;
            if (c2 == 10) {
                this.markLF(ptr);
                continue;
            }
            if (c2 == 13) {
                if (ptr >= this._inputEnd) {
                    if (!this.loadMore()) break;
                    ptr = this._inputPtr;
                }
                if (this._inputBuffer[ptr] == 10) {
                    ++ptr;
                }
                this.markLF(ptr);
                continue;
            }
            if (c2 == 32 || c2 == 9) continue;
            this._inputPtr = ptr;
            this.throwInvalidSpace(c2);
        }
        this._inputPtr = ptr;
    }

    private final void skipUtf8_2(int c2) throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((c2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(c2 & 0xFF, this._inputPtr);
        }
    }

    private final void skipUtf8_3(int c2) throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c2 &= 0xF) >= 13) {
            byte d2;
            c2 <<= 6;
            if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
            }
            c2 |= d2 & 0x3F;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
            }
            if ((c2 = c2 << 6 | d2 & 0x3F) >= 55296 && (c2 < 57344 || c2 >= 65534 && c2 <= 65535)) {
                c2 = this.handleInvalidXmlChar(c2);
            }
        } else {
            if (((c2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(c2 & 0xFF, this._inputPtr);
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (((c2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(c2 & 0xFF, this._inputPtr);
            }
        }
    }

    private final void skipUtf8_4(int c2) throws XMLStreamException {
        byte d2;
        if (this._inputPtr + 4 > this._inputEnd) {
            this.skipUtf8_4Slow(c2);
            return;
        }
        if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
        }
        if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
        }
        if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
        }
    }

    private final void skipUtf8_4Slow(int c2) throws XMLStreamException {
        byte d2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishCData() throws XMLStreamException {
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.resetWithEmpty();
        outPtr = 0;
        block10: while (true) {
            block26: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block26;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl75
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl75
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl75
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl75
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl75
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 11: {
                    count = 0;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b = this._inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count;
                    }
                    v0 = ok = b == 62 && count >= 1;
                    if (ok) {
                        --count;
                    }
                    while (count > 0) {
                        outputBuffer[outPtr++] = 93;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        --count;
                    }
                    if (ok) {
                        ++this._inputPtr;
                        break block10;
                    }
                }
lbl75:
                // 8 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishCharacters() throws XMLStreamException {
        c = this._tmpChar;
        if (c < 0) {
            c = -c;
            outputBuffer = this._textBuilder.resetWithEmpty();
            outPtr = 0;
            if (c >> 16 != 0) {
                outputBuffer[outPtr++] = (char)(55296 | (c -= 65536) >> 10);
                c = 56320 | c & 1023;
            }
            outputBuffer[outPtr++] = (char)c;
        } else if (c == 13 || c == 10) {
            ++this._inputPtr;
            outPtr = this.checkInTreeIndentation(c);
            if (outPtr < 0) {
                return;
            }
            outputBuffer = this._textBuilder.getBufferWithoutReset();
        } else {
            outputBuffer = this._textBuilder.resetWithEmpty();
            outPtr = 0;
        }
        TYPES = this._charTypes.TEXT_CHARS;
        inputBuffer = this._inputBuffer;
        block12: while (true) {
            block35: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block35;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl103
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl103
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl103
                }
                case 6: {
                    c = this._inputEnd - this._inputPtr >= 2 ? this.decodeUtf8_3fast(c) : this.decodeUtf8_3(c);
                    ** GOTO lbl103
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl103
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    --this._inputPtr;
                    break block12;
                }
                case 10: {
                    c = this.handleEntityInText(false);
                    if (c == 0) {
                        this._entityPending = true;
                        break block12;
                    }
                    if (c >> 16 == 0) ** GOTO lbl103
                    outputBuffer[outPtr++] = (char)(55296 | (c -= 65536) >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl103
                }
                case 11: {
                    count = 1;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b = inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count;
                    }
                    if (b == 62 && count > 1) {
                        this.reportIllegalCDataEnd();
                    }
                    while (count > 1) {
                        outputBuffer[outPtr++] = 93;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        --count;
                    }
                }
lbl103:
                // 9 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block12;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishComment() throws XMLStreamException {
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.resetWithEmpty();
        outPtr = 0;
        block10: while (true) {
            block22: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block22;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl63
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl63
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl63
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl63
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl63
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 13: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 45) {
                        ++this._inputPtr;
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr++] == 62) break block10;
                        this.reportDoubleHyphenInComments();
                        break block10;
                    }
                }
lbl63:
                // 8 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishDTD(boolean copyContents) throws XMLStreamException {
        outputBuffer = copyContents != false ? this._textBuilder.resetWithEmpty() : null;
        outPtr = 0;
        TYPES = this._charTypes.DTD_CHARS;
        inDecl = false;
        quoteChar = 0;
        block13: while (true) {
            block31: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                max = this._inputEnd;
                if (outputBuffer != null) {
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    if ((max2 = ptr + (outputBuffer.length - outPtr)) < max) {
                        max = max2;
                    }
                }
                while (ptr < max) {
                    if (TYPES[c = this._inputBuffer[ptr++] & 255] == 0) {
                        if (outputBuffer == null) continue;
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block31;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl75
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl75
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl75
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl75
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    if (outputBuffer != null) {
                        outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                        c = 56320 | c & 1023;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                    }
                    ** GOTO lbl75
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 8: {
                    if (quoteChar == 0) {
                        quoteChar = c;
                    } else if (quoteChar == c) {
                        quoteChar = 0;
                    }
                    ** GOTO lbl75
                }
                case 9: {
                    if (!inDecl) {
                        inDecl = true;
                    }
                    ** GOTO lbl75
                }
                case 10: {
                    if (quoteChar == 0) {
                        inDecl = false;
                    }
                    ** GOTO lbl75
                }
                case 11: {
                    if (!inDecl && quoteChar == 0) break block13;
                }
lbl75:
                // 11 sources

                default: {
                    if (outputBuffer == null) continue block13;
                    outputBuffer[outPtr++] = (char)c;
                    continue block13;
                }
            }
            break;
        }
        if (outputBuffer != null) {
            this._textBuilder.setCurrentLength(outPtr);
        }
        if ((b = this.skipInternalWs(false, null)) != 62) {
            this.throwUnexpectedChar(this.decodeCharForError(b), " expected '>' after the internal subset");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishPI() throws XMLStreamException {
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.resetWithEmpty();
        outPtr = 0;
        block10: while (true) {
            block21: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block21;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl59
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl59
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl59
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl59
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl59
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 12: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 62) {
                        ++this._inputPtr;
                        break block10;
                    }
                }
lbl59:
                // 8 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    @Override
    protected final void finishSpace() throws XMLStreamException {
        char[] outputBuffer;
        int outPtr;
        int tmp = this._tmpChar;
        if (tmp == 13 || tmp == 10) {
            outPtr = this.checkPrologIndentation(tmp);
            if (outPtr < 0) {
                return;
            }
            outputBuffer = this._textBuilder.getBufferWithoutReset();
        } else {
            outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = (char)tmp;
            outPtr = 1;
        }
        int ptr = this._inputPtr;
        while (true) {
            int c2;
            if (ptr >= this._inputEnd) {
                if (!this.loadMore()) break;
                ptr = this._inputPtr;
            }
            if ((c2 = this._inputBuffer[ptr] & 0xFF) > 32) break;
            ++ptr;
            if (c2 == 10) {
                this.markLF(ptr);
            } else if (c2 == 13) {
                if (ptr >= this._inputEnd) {
                    if (!this.loadMore()) {
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        outputBuffer[outPtr++] = 10;
                        break;
                    }
                    ptr = this._inputPtr;
                }
                if (this._inputBuffer[ptr] == 10) {
                    ++ptr;
                }
                this.markLF(ptr);
                c2 = 10;
            } else if (c2 != 32 && c2 != 9) {
                this._inputPtr = ptr;
                this.throwInvalidSpace(c2);
            }
            if (outPtr >= outputBuffer.length) {
                outputBuffer = this._textBuilder.finishCurrentSegment();
                outPtr = 0;
            }
            outputBuffer[outPtr++] = (char)c2;
        }
        this._inputPtr = ptr;
        this._textBuilder.setCurrentLength(outPtr);
    }

    protected final void finishCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return;
            }
            if (this._inputBuffer[this._inputPtr] == 60) {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain(3)) {
                    return;
                }
                if (this._inputBuffer[this._inputPtr + 1] != 33 || this._inputBuffer[this._inputPtr + 2] != 91) {
                    return;
                }
                this._inputPtr += 3;
                for (int i2 = 0; i2 < 6; ++i2) {
                    byte b2;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((b2 = this._inputBuffer[this._inputPtr++]) == (byte)"CDATA[".charAt(i2)) continue;
                    int ch = this.decodeCharForError(b2);
                    this.reportTreeUnexpChar(ch, " (expected '" + "CDATA[".charAt(i2) + "' for CDATA section)");
                }
                this.finishCoalescedCData();
                continue;
            }
            this.finishCoalescedCharacters();
            if (this._entityPending) break;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final void finishCoalescedCharacters() throws XMLStreamException {
        TYPES = this._charTypes.TEXT_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.getBufferWithoutReset();
        outPtr = this._textBuilder.getCurrentLength();
        block12: while (true) {
            block28: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block28;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl86
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl86
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl86
                }
                case 6: {
                    c = this._inputEnd - this._inputPtr >= 2 ? this.decodeUtf8_3fast(c) : this.decodeUtf8_3(c);
                    ** GOTO lbl86
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl86
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    --this._inputPtr;
                    break block12;
                }
                case 10: {
                    c = this.handleEntityInText(false);
                    if (c == 0) {
                        this._entityPending = true;
                        break block12;
                    }
                    if (c >> 16 == 0) ** GOTO lbl86
                    outputBuffer[outPtr++] = (char)(55296 | (c -= 65536) >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl86
                }
                case 11: {
                    count = 1;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b = inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count;
                    }
                    if (b == 62 && count > 1) {
                        this.reportIllegalCDataEnd();
                    }
                    while (count > 1) {
                        outputBuffer[outPtr++] = 93;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        --count;
                    }
                }
lbl86:
                // 9 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block12;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    /*
     * Unable to fully structure code
     */
    protected final void finishCoalescedCData() throws XMLStreamException {
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.getBufferWithoutReset();
        outPtr = this._textBuilder.getCurrentLength();
        block10: while (true) {
            block25: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block25;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl75
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl75
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl75
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl75
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl75
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 11: {
                    count = 0;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b = this._inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count;
                    }
                    v0 = ok = b == 62 && count >= 1;
                    if (ok) {
                        --count;
                    }
                    while (count > 0) {
                        outputBuffer[outPtr++] = 93;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        --count;
                    }
                    if (ok) {
                        ++this._inputPtr;
                        break block10;
                    }
                }
lbl75:
                // 8 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    @Override
    protected final boolean skipCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return false;
            }
            if (this._inputBuffer[this._inputPtr] == 60) {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain(3)) {
                    return false;
                }
                if (this._inputBuffer[this._inputPtr + 1] != 33 || this._inputBuffer[this._inputPtr + 2] != 91) {
                    return false;
                }
                this._inputPtr += 3;
                for (int i2 = 0; i2 < 6; ++i2) {
                    byte b2;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((b2 = this._inputBuffer[this._inputPtr++]) == (byte)"CDATA[".charAt(i2)) continue;
                    int ch = this.decodeCharForError(b2);
                    this.reportTreeUnexpChar(ch, " (expected '" + "CDATA[".charAt(i2) + "' for CDATA section)");
                }
                this.skipCData();
                continue;
            }
            if (this.skipCharacters()) break;
        }
        return true;
    }

    private final int decodeMultiByteChar(int c2, int ptr) throws XMLStreamException {
        byte d2;
        int needed;
        if ((c2 & 0xE0) == 192) {
            c2 &= 0x1F;
            needed = 1;
        } else if ((c2 & 0xF0) == 224) {
            c2 &= 0xF;
            needed = 2;
        } else if ((c2 & 0xF8) == 240) {
            c2 &= 7;
            needed = 3;
        } else {
            this.reportInvalidInitial(c2 & 0xFF);
            needed = 1;
        }
        if (ptr >= this._inputEnd) {
            this.loadMoreGuaranteed();
            ptr = this._inputPtr;
        }
        if (((d2 = this._inputBuffer[ptr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, ptr);
        }
        c2 = c2 << 6 | d2 & 0x3F;
        if (needed > 1) {
            if (ptr >= this._inputEnd) {
                this.loadMoreGuaranteed();
                ptr = this._inputPtr;
            }
            if (((d2 = this._inputBuffer[ptr++]) & 0xC0) != 128) {
                this.reportInvalidOther(d2 & 0xFF, ptr);
            }
            c2 = c2 << 6 | d2 & 0x3F;
            if (needed > 2) {
                if (ptr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (((d2 = this._inputBuffer[ptr++]) & 0xC0) != 128) {
                    this.reportInvalidOther(d2 & 0xFF, ptr);
                }
                c2 = c2 << 6 | d2 & 0x3F;
                c2 = -c2;
            }
        }
        this._inputPtr = ptr;
        return c2;
    }

    private final int decodeUtf8_2(int c2) throws XMLStreamException {
        byte d2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
        }
        return (c2 & 0x1F) << 6 | d2 & 0x3F;
    }

    private final int decodeUtf8_3(int c1) throws XMLStreamException {
        byte d2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        c1 &= 0xF;
        if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
        }
        int c2 = c1 << 6 | d2 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
        }
        c2 = c2 << 6 | d2 & 0x3F;
        if (c1 >= 13 && c2 >= 55296 && (c2 < 57344 || c2 >= 65534 && c2 <= 65535)) {
            c2 = this.handleInvalidXmlChar(c2);
        }
        return c2;
    }

    private final int decodeUtf8_3fast(int c1) throws XMLStreamException {
        byte d2;
        c1 &= 0xF;
        if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
        }
        int c2 = c1 << 6 | d2 & 0x3F;
        if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
        }
        c2 = c2 << 6 | d2 & 0x3F;
        if (c1 >= 13 && c2 >= 55296 && (c2 < 57344 || c2 >= 65534 && c2 <= 65535)) {
            c2 = this.handleInvalidXmlChar(c2);
        }
        return c2;
    }

    private final int decodeUtf8_4(int c2) throws XMLStreamException {
        byte d2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
        }
        c2 = (c2 & 7) << 6 | d2 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
        }
        c2 = c2 << 6 | d2 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF, this._inputPtr);
        }
        return (c2 << 6 | d2 & 0x3F) - 65536;
    }

    @Override
    public int decodeCharForError(byte b2) throws XMLStreamException {
        int needed;
        int c2 = b2;
        if (c2 >= 0) {
            return c2;
        }
        if ((c2 & 0xE0) == 192) {
            c2 &= 0x1F;
            needed = 1;
        } else if ((c2 & 0xF0) == 224) {
            c2 &= 0xF;
            needed = 2;
        } else if ((c2 & 0xF8) == 240) {
            c2 &= 7;
            needed = 3;
        } else {
            this.reportInvalidInitial(c2 & 0xFF);
            needed = 1;
        }
        byte d2 = this.nextByte();
        if ((d2 & 0xC0) != 128) {
            this.reportInvalidOther(d2 & 0xFF);
        }
        c2 = c2 << 6 | d2 & 0x3F;
        if (needed > 1) {
            d2 = this.nextByte();
            if ((d2 & 0xC0) != 128) {
                this.reportInvalidOther(d2 & 0xFF);
            }
            c2 = c2 << 6 | d2 & 0x3F;
            if (needed > 2) {
                d2 = this.nextByte();
                if ((d2 & 0xC0) != 128) {
                    this.reportInvalidOther(d2 & 0xFF);
                }
                c2 = c2 << 6 | d2 & 0x3F;
            }
        }
        return c2;
    }

    protected void reportInvalidOther(int mask, int ptr) throws XMLStreamException {
        this._inputPtr = ptr;
        this.reportInvalidOther(mask);
    }
}

