/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.checkers.declarations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.containers.UtilKt;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReporterWithContext;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibDiagnosticContext;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibErrors;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibModuleChecker;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000e\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/declarations/JsKlibFileClashChecker;", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibModuleChecker;", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "<init>", "()V", "jsFileNameFqn", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "module", "context", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibDiagnosticContext;", "reporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "FinalArtifactValuableParameters", "FinalArtifactParameters", "ir.serialization.js"})
@SourceDebugExtension(value={"SMAP\nJsKlibPossibleFileClashWarning.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsKlibPossibleFileClashWarning.kt\norg/jetbrains/kotlin/ir/backend/js/checkers/declarations/JsKlibFileClashChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1#2:85\n382#3,7:86\n382#3,7:93\n216#4:100\n217#4:105\n1563#5:101\n1634#5,3:102\n*S KotlinDebug\n*F\n+ 1 JsKlibPossibleFileClashWarning.kt\norg/jetbrains/kotlin/ir/backend/js/checkers/declarations/JsKlibFileClashChecker\n*L\n42#1:86,7\n52#1:93,7\n59#1:100\n59#1:105\n68#1:101\n68#1:102,3\n*E\n"})
public final class JsKlibFileClashChecker
implements JsKlibModuleChecker<IrModuleFragment> {
    @NotNull
    public static final JsKlibFileClashChecker INSTANCE = new JsKlibFileClashChecker();
    @NotNull
    private static final FqName jsFileNameFqn = new FqName("kotlin.js.JsFileName");

    private JsKlibFileClashChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull IrModuleFragment module2, @NotNull JsKlibDiagnosticContext context2, @NotNull IrDiagnosticReporter reporter) {
        Object finalArtifactValuableParameters;
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        HashMap possibleFinalArtifactToIrFile = new HashMap();
        for (IrFile file : module2.getFiles()) {
            Object object;
            void $this$getOrPut$iv;
            String string;
            IrExpression irExpression;
            IrMemberAccessExpression.ValueArgumentsList valueArgumentsList;
            IrConstructorCall jsFileNameAnnotation = IrUtilsKt.getAnnotation(file, jsFileNameFqn);
            if (jsFileNameAnnotation != null && (valueArgumentsList = jsFileNameAnnotation.getArguments()) != null && (irExpression = (IrExpression)CollectionsKt.singleOrNull(valueArgumentsList)) != null) {
                Object object2;
                IrExpression it = irExpression;
                boolean bl = false;
                IrConst irConst = it instanceof IrConst ? (IrConst)it : null;
                Object object3 = object2 = irConst != null ? irConst.getValue() : null;
                string = object2 instanceof String ? (String)object2 : null;
            } else {
                string = null;
            }
            String jsFileNameAnnotationValue = string;
            String string2 = file.getPackageFqName().asString();
            String string3 = jsFileNameAnnotationValue;
            if (string3 == null) {
                string3 = StringsKt.substringBeforeLast$default(IrDeclarationsKt.getName(file), ".kt", null, 2, null);
            }
            finalArtifactValuableParameters = new FinalArtifactValuableParameters(string2, string3, file);
            Map map2 = possibleFinalArtifactToIrFile;
            FinalArtifactParameters key$iv = ((FinalArtifactValuableParameters)finalArtifactValuableParameters).asFinalArtifactParameters();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List clashedFiles = (List)object;
            clashedFiles.add(finalArtifactValuableParameters);
        }
        Iterator<Object> iterator2 = ((Map)possibleFinalArtifactToIrFile).entrySet().iterator();
        while (iterator2.hasNext()) {
            Iterable answer$iv;
            List clashedFiles = (List)((Map.Entry)iterator2.next()).getValue();
            if (clashedFiles.size() == 1) continue;
            finalArtifactValuableParameters = MapsKt.createMapBuilder();
            Map $this$check_u24lambda_u242 = finalArtifactValuableParameters;
            boolean bl = false;
            for (FinalArtifactValuableParameters clashedFile : clashedFiles) {
                Object object;
                void $this$getOrPut$iv;
                Map value$iv = $this$check_u24lambda_u242;
                Pair<String, String> key$iv = TuplesKt.to(clashedFile.getComputedFileName(), clashedFile.getPackageFqn());
                boolean $i$f$getOrPut = false;
                Object value$iv2 = $this$getOrPut$iv.get(key$iv);
                if (value$iv2 == null) {
                    boolean bl2 = false;
                    answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv2;
                }
                ((List)object).add(clashedFile);
            }
            Map clashedFilesByCaseSensitiveData = MapsKt.build(finalArtifactValuableParameters);
            if (clashedFilesByCaseSensitiveData.size() == 1) continue;
            Map $this$forEach$iv = clashedFilesByCaseSensitiveData;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Collection<IrFileEntry> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator3.next();
                boolean bl3 = false;
                Pair key = (Pair)entry.getKey();
                List clashedFiles2 = (List)entry.getValue();
                IrFile firstFileWithThisSensitivePath = ((FinalArtifactValuableParameters)CollectionsKt.first(clashedFiles2)).getFile();
                answer$iv = CollectionsKt.flatten(UtilKt.without(clashedFilesByCaseSensitiveData, key).values());
                KtDiagnosticFactory1<List<IrFileEntry>> ktDiagnosticFactory1 = JsKlibErrors.INSTANCE.getCLASHED_FILES_IN_CASE_INSENSITIVE_FS();
                KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = reporter.at((IrElement)firstFileWithThisSensitivePath, firstFileWithThisSensitivePath);
                boolean $i$f$map = false;
                void var22_35 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FinalArtifactValuableParameters finalArtifactValuableParameters2 = (FinalArtifactValuableParameters)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(it.getFile().getFileEntry());
                }
                collection = (List)destination$iv$iv;
                diagnosticContextImpl.report(ktDiagnosticFactory1, collection);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/declarations/JsKlibFileClashChecker$FinalArtifactParameters;", "", "packageFqn", "", "fileName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getPackageFqn", "()Ljava/lang/String;", "getFileName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "ir.serialization.js"})
    private static final class FinalArtifactParameters {
        @NotNull
        private final String packageFqn;
        @NotNull
        private final String fileName;

        public FinalArtifactParameters(@NotNull String packageFqn, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter(packageFqn, "packageFqn");
            Intrinsics.checkNotNullParameter(fileName, "fileName");
            this.packageFqn = packageFqn;
            this.fileName = fileName;
        }

        @NotNull
        public final String getPackageFqn() {
            return this.packageFqn;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public final String component1() {
            return this.packageFqn;
        }

        @NotNull
        public final String component2() {
            return this.fileName;
        }

        @NotNull
        public final FinalArtifactParameters copy(@NotNull String packageFqn, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter(packageFqn, "packageFqn");
            Intrinsics.checkNotNullParameter(fileName, "fileName");
            return new FinalArtifactParameters(packageFqn, fileName);
        }

        public static /* synthetic */ FinalArtifactParameters copy$default(FinalArtifactParameters finalArtifactParameters, String string, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = finalArtifactParameters.packageFqn;
            }
            if ((n2 & 2) != 0) {
                string2 = finalArtifactParameters.fileName;
            }
            return finalArtifactParameters.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "FinalArtifactParameters(packageFqn=" + this.packageFqn + ", fileName=" + this.fileName + ')';
        }

        public int hashCode() {
            int result2 = this.packageFqn.hashCode();
            result2 = result2 * 31 + this.fileName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FinalArtifactParameters)) {
                return false;
            }
            FinalArtifactParameters finalArtifactParameters = (FinalArtifactParameters)other;
            if (!Intrinsics.areEqual(this.packageFqn, finalArtifactParameters.packageFqn)) {
                return false;
            }
            return Intrinsics.areEqual(this.fileName, finalArtifactParameters.fileName);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/declarations/JsKlibFileClashChecker$FinalArtifactValuableParameters;", "", "packageFqn", "", "computedFileName", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "getPackageFqn", "()Ljava/lang/String;", "getComputedFileName", "getFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "asFinalArtifactParameters", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/declarations/JsKlibFileClashChecker$FinalArtifactParameters;", "ir.serialization.js"})
    private static final class FinalArtifactValuableParameters {
        @NotNull
        private final String packageFqn;
        @NotNull
        private final String computedFileName;
        @NotNull
        private final IrFile file;

        public FinalArtifactValuableParameters(@NotNull String packageFqn, @NotNull String computedFileName, @NotNull IrFile file) {
            Intrinsics.checkNotNullParameter(packageFqn, "packageFqn");
            Intrinsics.checkNotNullParameter(computedFileName, "computedFileName");
            Intrinsics.checkNotNullParameter(file, "file");
            this.packageFqn = packageFqn;
            this.computedFileName = computedFileName;
            this.file = file;
        }

        @NotNull
        public final String getPackageFqn() {
            return this.packageFqn;
        }

        @NotNull
        public final String getComputedFileName() {
            return this.computedFileName;
        }

        @NotNull
        public final IrFile getFile() {
            return this.file;
        }

        @NotNull
        public final FinalArtifactParameters asFinalArtifactParameters() {
            String string = this.packageFqn.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            String string2 = this.computedFileName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            return new FinalArtifactParameters(string, string2);
        }
    }
}

