/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.compose.rules;

import io.nlopez.compose.core.ComposeKtConfig;
import io.nlopez.compose.core.ComposeKtVisitor;
import io.nlopez.compose.core.Emitter;
import io.nlopez.compose.core.EmitterKt;
import io.nlopez.compose.core.util.ComposablesKt;
import io.nlopez.compose.core.util.KtAnnotatedsKt;
import io.nlopez.compose.core.util.LambdasKt;
import io.nlopez.compose.core.util.ModifiersKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lio/nlopez/compose/rules/LambdaParameterEventTrailing;", "Lio/nlopez/compose/core/ComposeKtVisitor;", "<init>", "()V", "visitComposable", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "emitter", "Lio/nlopez/compose/core/Emitter;", "config", "Lio/nlopez/compose/core/ComposeKtConfig;", "Companion", "common-ktlint"})
public final class LambdaParameterEventTrailing
implements ComposeKtVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String EventLambdaIsTrailingLambda = "Lambda parameters in a @Composable that are for events (e.g. onClick, onChange, etc) and are required (they don't have a default value) should not be used as the trailing parameter.\nComposable functions that emit content usually reserve the trailing lambda syntax for the content slot, and that can lead to an assumption that other composables can be used in that lambda.\nSee https://mrmans0n.github.io/compose-rules/rules/#avoid-using-the-trailing-lambda-for-event-lambdas-in-ui-composables for more information.";

    @Override
    public void visitComposable(@NotNull KtFunction function2, @NotNull Emitter emitter, @NotNull ComposeKtConfig config) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(emitter, "emitter");
        Intrinsics.checkNotNullParameter(config, "config");
        if (!ComposablesKt.emitsContent(function2, config)) {
            return;
        }
        if (ModifiersKt.modifierParameter(function2, config) == null) {
            return;
        }
        List<KtParameter> list = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        KtParameter ktParameter = CollectionsKt.lastOrNull(list);
        if (ktParameter == null) {
            return;
        }
        KtParameter trailingParam = ktParameter;
        KtTypeReference ktTypeReference = trailingParam.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        if (!LambdasKt.isLambda$default(typeReference, null, 1, null)) {
            return;
        }
        if (KtAnnotatedsKt.isComposable(typeReference)) {
            return;
        }
        if (trailingParam.hasDefaultValue()) {
            return;
        }
        String string = trailingParam.getName();
        if (string == null) {
            return;
        }
        String name2 = string;
        if (!StringsKt.startsWith$default(name2, "on", false, 2, null)) {
            return;
        }
        EmitterKt.report(emitter, trailingParam, EventLambdaIsTrailingLambda);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/nlopez/compose/rules/LambdaParameterEventTrailing$Companion;", "", "<init>", "()V", "EventLambdaIsTrailingLambda", "", "getEventLambdaIsTrailingLambda", "()Ljava/lang/String;", "common-ktlint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getEventLambdaIsTrailingLambda() {
            return EventLambdaIsTrailingLambda;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

