/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.uuid.ExperimentalUuidApi;
import kotlin.uuid.SecureRandomHolder;
import kotlin.uuid.Uuid;
import kotlin.uuid.UuidKt;
import kotlin.uuid.UuidSerialized;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=5, xi=49, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0001\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0001\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0001\u001a,\u0010\n\u001a\u00020\u000b*\u00020\u00062\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0001\u001a\u001c\u0010\u0010\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0006H\u0001\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0001\u001a\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0014H\u0001\u001a\r\u0010\u0017\u001a\u00020\u0001*\u00020\u0018H\u0087\b\u001a\r\u0010\u0019\u001a\u00020\u0018*\u00020\u0001H\u0087\b\u001a\f\u0010\u001a\u001a\u00020\u0001*\u00020\u001bH\u0007\u001a\u0014\u0010\u001a\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u0014\u0010\u001c\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\u001c\u0010\u001c\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\r\u0010\u001d\u001a\u00020\u0006*\u00020\u0006H\u0080\b\u00a8\u0006\u001e"}, d2={"secureRandomUuid", "Lkotlin/uuid/Uuid;", "serializedUuid", "", "uuid", "getLongAt", "", "", "index", "", "formatBytesInto", "", "dst", "dstOffset", "startIndex", "endIndex", "setLongAt", "value", "uuidParseHexDash", "hexDashString", "", "uuidParseHex", "hexString", "toKotlinUuid", "Ljava/util/UUID;", "toJavaUuid", "getUuid", "Ljava/nio/ByteBuffer;", "putUuid", "reverseBytes", "kotlin-stdlib"}, xs="kotlin/uuid/UuidKt")
@SourceDebugExtension(value={"SMAP\nUuidJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UuidJVM.kt\nkotlin/uuid/UuidKt__UuidJVMKt\n*L\n1#1,277:1\n277#1:278\n277#1:279\n277#1:280\n277#1:281\n277#1:282\n277#1:283\n277#1:284\n277#1:285\n*S KotlinDebug\n*F\n+ 1 UuidJVM.kt\nkotlin/uuid/UuidKt__UuidJVMKt\n*L\n139#1:278\n140#1:279\n184#1:280\n185#1:281\n224#1:282\n225#1:283\n271#1:284\n272#1:285\n*E\n"})
class UuidKt__UuidJVMKt {
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid secureRandomUuid() {
        byte[] randomBytes = new byte[16];
        SecureRandomHolder.INSTANCE.getInstance().nextBytes(randomBytes);
        return UuidKt.uuidFromRandomBytes(randomBytes);
    }

    @ExperimentalUuidApi
    @NotNull
    public static final Object serializedUuid(@NotNull Uuid uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return new UuidSerialized(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    @ExperimentalUuidApi
    public static final long getLongAt(@NotNull byte[] $this$getLongAt, int index) {
        Intrinsics.checkNotNullParameter($this$getLongAt, "<this>");
        return UuidKt.getLongAtCommonImpl($this$getLongAt, index);
    }

    @ExperimentalUuidApi
    public static final void formatBytesInto(long $this$formatBytesInto, @NotNull byte[] dst, int dstOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(dst, "dst");
        UuidKt.formatBytesIntoCommonImpl($this$formatBytesInto, dst, dstOffset, startIndex, endIndex);
    }

    @ExperimentalUuidApi
    public static final void setLongAt(@NotNull byte[] $this$setLongAt, int index, long value2) {
        Intrinsics.checkNotNullParameter($this$setLongAt, "<this>");
        UuidKt.setLongAtCommonImpl($this$setLongAt, index, value2);
    }

    @ExperimentalUuidApi
    @NotNull
    public static final Uuid uuidParseHexDash(@NotNull String hexDashString) {
        Intrinsics.checkNotNullParameter(hexDashString, "hexDashString");
        return UuidKt.uuidParseHexDashCommonImpl(hexDashString);
    }

    @ExperimentalUuidApi
    @NotNull
    public static final Uuid uuidParseHex(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter(hexString, "hexString");
        return UuidKt.uuidParseHexCommonImpl(hexString);
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid toKotlinUuid(@NotNull UUID $this$toKotlinUuid) {
        Intrinsics.checkNotNullParameter($this$toKotlinUuid, "<this>");
        boolean $i$f$toKotlinUuid = false;
        return Uuid.Companion.fromLongs($this$toKotlinUuid.getMostSignificantBits(), $this$toKotlinUuid.getLeastSignificantBits());
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final UUID toJavaUuid(@NotNull Uuid $this$toJavaUuid) {
        void leastSignificantBits;
        Intrinsics.checkNotNullParameter($this$toJavaUuid, "<this>");
        boolean $i$f$toJavaUuid = false;
        Uuid uuid = $this$toJavaUuid;
        long l2 = uuid.getLeastSignificantBits();
        long mostSignificantBits = uuid.getMostSignificantBits();
        boolean bl = false;
        return new UUID(mostSignificantBits, (long)leastSignificantBits);
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid getUuid(@NotNull ByteBuffer $this$getUuid) {
        Intrinsics.checkNotNullParameter($this$getUuid, "<this>");
        if ($this$getUuid.position() + 15 >= $this$getUuid.limit()) {
            throw new BufferUnderflowException();
        }
        long msb = $this$getUuid.getLong();
        long lsb = $this$getUuid.getLong();
        if (Intrinsics.areEqual($this$getUuid.order(), ByteOrder.LITTLE_ENDIAN)) {
            long $this$reverseBytes$iv = msb;
            boolean $i$f$reverseBytes = false;
            msb = Long.reverseBytes($this$reverseBytes$iv);
            $this$reverseBytes$iv = lsb;
            $i$f$reverseBytes = false;
            lsb = Long.reverseBytes($this$reverseBytes$iv);
        }
        return Uuid.Companion.fromLongs(msb, lsb);
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid getUuid(@NotNull ByteBuffer $this$getUuid, int index) {
        Intrinsics.checkNotNullParameter($this$getUuid, "<this>");
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index + 15 >= $this$getUuid.limit()) {
            throw new IndexOutOfBoundsException("Not enough bytes to read a uuid at index: " + index + ", with limit: " + $this$getUuid.limit() + ' ');
        }
        long msb = $this$getUuid.getLong(index);
        long lsb = $this$getUuid.getLong(index + 8);
        if (Intrinsics.areEqual($this$getUuid.order(), ByteOrder.LITTLE_ENDIAN)) {
            long $this$reverseBytes$iv = msb;
            boolean $i$f$reverseBytes = false;
            msb = Long.reverseBytes($this$reverseBytes$iv);
            $this$reverseBytes$iv = lsb;
            $i$f$reverseBytes = false;
            lsb = Long.reverseBytes($this$reverseBytes$iv);
        }
        return Uuid.Companion.fromLongs(msb, lsb);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final ByteBuffer putUuid(@NotNull ByteBuffer $this$putUuid, @NotNull Uuid uuid) {
        ByteBuffer byteBuffer;
        void lsb;
        Intrinsics.checkNotNullParameter($this$putUuid, "<this>");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Uuid uuid2 = uuid;
        long l2 = uuid2.getLeastSignificantBits();
        long msb = uuid2.getMostSignificantBits();
        boolean bl = false;
        if ($this$putUuid.position() + 15 >= $this$putUuid.limit()) {
            throw new BufferOverflowException();
        }
        if (Intrinsics.areEqual($this$putUuid.order(), ByteOrder.BIG_ENDIAN)) {
            $this$putUuid.putLong(msb);
            byteBuffer = $this$putUuid.putLong((long)lsb);
        } else {
            long $this$reverseBytes$iv = msb;
            boolean $i$f$reverseBytes = false;
            $this$putUuid.putLong(Long.reverseBytes($this$reverseBytes$iv));
            $this$reverseBytes$iv = lsb;
            $i$f$reverseBytes = false;
            byteBuffer = $this$putUuid.putLong(Long.reverseBytes($this$reverseBytes$iv));
        }
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "toLongs(...)");
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final ByteBuffer putUuid(@NotNull ByteBuffer $this$putUuid, int index, @NotNull Uuid uuid) {
        ByteBuffer byteBuffer;
        void lsb;
        Intrinsics.checkNotNullParameter($this$putUuid, "<this>");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Uuid uuid2 = uuid;
        long l2 = uuid2.getLeastSignificantBits();
        long msb = uuid2.getMostSignificantBits();
        boolean bl = false;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index + 15 >= $this$putUuid.limit()) {
            throw new IndexOutOfBoundsException("Not enough capacity to write a uuid at index: " + index + ", with limit: " + $this$putUuid.limit() + ' ');
        }
        if (Intrinsics.areEqual($this$putUuid.order(), ByteOrder.BIG_ENDIAN)) {
            $this$putUuid.putLong(index, msb);
            byteBuffer = $this$putUuid.putLong(index + 8, (long)lsb);
        } else {
            long $this$reverseBytes$iv = msb;
            boolean $i$f$reverseBytes = false;
            $this$putUuid.putLong(index, Long.reverseBytes($this$reverseBytes$iv));
            $this$reverseBytes$iv = lsb;
            $i$f$reverseBytes = false;
            byteBuffer = $this$putUuid.putLong(index + 8, Long.reverseBytes($this$reverseBytes$iv));
        }
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "toLongs(...)");
        return byteBuffer;
    }

    public static final long reverseBytes(long $this$reverseBytes) {
        boolean $i$f$reverseBytes = false;
        return Long.reverseBytes($this$reverseBytes);
    }
}

