/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.cli;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import org.ec4j.core.EditorConfigLoader;
import org.ec4j.core.Resource;
import org.ec4j.core.ResourcePath;
import org.ec4j.core.ResourcePropertiesService;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.PropertyType;
import org.ec4j.core.model.Version;

public class Cli {
    private static final boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");

    public static void main(String[] args) throws Exception {
        ArrayList<String> paths2 = new ArrayList<String>();
        String editorconfigFileName = ".editorconfig";
        Version version2 = Version.CURRENT;
        block11: for (int i2 = 0; i2 < args.length; ++i2) {
            String arg;
            switch (arg = args[i2]) {
                case "-b": {
                    if (i2 + 1 < args.length) {
                        version2 = Version.of(args[++i2]);
                        continue block11;
                    }
                    System.err.println("-b option must be followed by a version");
                    System.exit(1);
                    continue block11;
                }
                case "-f": {
                    if (i2 + 1 < args.length) {
                        editorconfigFileName = args[++i2];
                        continue block11;
                    }
                    System.err.println("-f option must be followed by a file path");
                    System.exit(1);
                    continue block11;
                }
                case "--version": 
                case "-v": {
                    System.out.println("EditorConfig Java Version " + Version.CURRENT);
                    System.exit(0);
                    continue block11;
                }
                default: {
                    paths2.add(args[i2]);
                }
            }
        }
        if (paths2.isEmpty()) {
            System.err.println("At least one file path needs to be specified");
            System.exit(1);
        }
        if (version2.compareTo(Version.CURRENT) > 0) {
            System.err.println("Required version " + version2 + " is greater than the current version " + Version.CURRENT + ".");
            System.exit(1);
        }
        ResourcePropertiesService resourcePropertiesService = ResourcePropertiesService.builder().configFileName(editorconfigFileName).rootDirectory(ResourcePath.ResourcePaths.ofPath(Paths.get(".", new String[0]).toAbsolutePath().normalize(), StandardCharsets.UTF_8)).loader(EditorConfigLoader.of(version2)).keepUnset(true).build();
        for (String path : paths2) {
            Path p2;
            if (paths2.size() > 1) {
                System.out.println("[" + path + "]");
            }
            if (isWindows) {
                p2 = Paths.get(path, new String[0]).toAbsolutePath().normalize();
            } else {
                int firstBackSlash = path.indexOf(92);
                if (firstBackSlash < 0) {
                    p2 = Paths.get(path, new String[0]).toAbsolutePath().normalize();
                } else {
                    String first2 = path.startsWith("/") ? "/" : "";
                    p2 = Paths.get(first2, path.split("/")).toAbsolutePath().normalize();
                }
            }
            Resource file = Resource.Resources.ofPath(p2, StandardCharsets.UTF_8);
            Collection<Property> props = resourcePropertiesService.queryProperties(file).getProperties().values();
            for (Property prop : props) {
                String val = prop.getSourceValue();
                PropertyType<?> type2 = prop.getType();
                if (type2 != null) {
                    val = type2.normalizeIfNeeded(val);
                }
                System.out.println(prop.getName() + "=" + val);
            }
        }
    }
}

