/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ec4j.core.model.Adaptable;
import org.ec4j.core.parser.Location;
import org.ec4j.core.parser.Span;

public class Comments {

    public static class CommentLine
    extends Adaptable.DefaultAdaptable {
        private final String text;

        CommentLine(List<Object> adapters, String text) {
            super(adapters);
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return this.text;
        }

        public static class Builder
        extends Adaptable.DefaultAdaptable.Builder<Builder> {
            private final CommentBlock.Builder parentBuilder;
            private String text;

            Builder(CommentBlock.Builder parentBuilder) {
                this.parentBuilder = parentBuilder;
            }

            public CommentLine build() {
                return new CommentLine(this.sealAdapters(), this.text);
            }

            public CommentBlock.Builder closeComment() {
                return this.parentBuilder.commentLine(this.build());
            }

            public Builder text(String text) {
                this.text = text;
                return this;
            }
        }
    }

    public static class CommentBlocks
    extends Adaptable.DefaultAdaptable {
        private final List<CommentBlock> commentBlocks;

        public static Builder builder() {
            return new Builder();
        }

        public CommentBlocks(List<Object> adapters, List<CommentBlock> commentBlocks) {
            super(adapters);
            this.commentBlocks = commentBlocks;
        }

        public List<CommentBlock> getCommentBlocks() {
            return this.commentBlocks;
        }

        public static class Builder
        extends Adaptable.DefaultAdaptable.Builder<Builder> {
            private List<CommentBlock> commentBlocks = new ArrayList<CommentBlock>();

            public CommentBlocks build() {
                return new CommentBlocks(this.sealAdapters(), this.commentBlocks);
            }

            public Builder commentBlock(CommentBlock commentBlock) {
                this.commentBlocks.add(commentBlock);
                return this;
            }

            public Builder commentBlocks(Collection<CommentBlock> commentBlocks) {
                this.commentBlocks.addAll(commentBlocks);
                return this;
            }

            public Builder commentBlocks(CommentBlock ... commentBlocks) {
                for (CommentBlock commentBlock : commentBlocks) {
                    this.commentBlocks.add(commentBlock);
                }
                return this;
            }

            public CommentBlock.Builder openCommentBlock() {
                return new CommentBlock.Builder(this);
            }
        }
    }

    public static class CommentBlock
    extends Adaptable.DefaultAdaptable {
        private final List<CommentLine> commentLines;

        CommentBlock(List<Object> adapters, List<CommentLine> commentLines) {
            super(adapters);
            this.commentLines = commentLines;
        }

        public List<CommentLine> getCommentLines() {
            return this.commentLines;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (CommentLine commentLine : this.commentLines) {
                sb.append(commentLine).append('\n');
            }
            return sb.toString();
        }

        public static class Builder
        extends Adaptable.DefaultAdaptable.Builder<Builder> {
            private List<CommentLine> commentLines = new ArrayList<CommentLine>();
            private final CommentBlocks.Builder parentBuilder;
            private Location start;

            public Builder(CommentBlocks.Builder parentBuilder) {
                this.parentBuilder = parentBuilder;
            }

            public CommentBlock build() {
                Span lastSpan;
                int linesCount = this.commentLines.size();
                if (this.start != null && linesCount > 0 && (lastSpan = this.commentLines.get(linesCount - 1).getAdapter(Span.class)) != null) {
                    this.adapter(new Span(this.start, lastSpan.getEnd()));
                }
                List<CommentLine> useComments = Collections.unmodifiableList(this.commentLines);
                this.commentLines = null;
                return new CommentBlock(this.sealAdapters(), useComments);
            }

            public CommentBlocks.Builder closeCommentBlock() {
                return this.parentBuilder.commentBlock(this.build());
            }

            public Builder commentLine(CommentLine commentLine) {
                Span span;
                if (this.commentLines.size() == 0 && (span = commentLine.getAdapter(Span.class)) != null) {
                    this.start = span.getStart();
                }
                this.commentLines.add(commentLine);
                return this;
            }

            public Builder commentLines(Collection<CommentLine> commentLines) {
                Span span;
                if (this.commentLines.size() == 0 && commentLines.size() > 0 && (span = commentLines.iterator().next().getAdapter(Span.class)) != null) {
                    this.start = span.getStart();
                }
                this.commentLines.addAll(commentLines);
                return this;
            }

            public Builder commentLines(CommentLine ... commentLines) {
                Span span;
                if (this.commentLines.size() == 0 && commentLines.length > 0 && (span = commentLines[0].getAdapter(Span.class)) != null) {
                    this.start = span.getStart();
                }
                for (CommentLine commentLine : commentLines) {
                    this.commentLines.add(commentLine);
                }
                return this;
            }

            public CommentLine.Builder openCommentLine() {
                return new CommentLine.Builder(this);
            }
        }
    }
}

