/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.ObsoleteDescriptorBasedAPI;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.util.DescriptorSymbolTableExtension;
import org.jetbrains.kotlin.ir.util.IdSignatureComposer;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\b\u0010\f\u001a\u00020\rH\u0014R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/SymbolTableWithBuiltInsDeduplication;", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "signaturer", "Lorg/jetbrains/kotlin/ir/util/IdSignatureComposer;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "<init>", "(Lorg/jetbrains/kotlin/ir/util/IdSignatureComposer;Lorg/jetbrains/kotlin/ir/declarations/IrFactory;)V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "bindBuiltIns", "", "createDescriptorExtension", "Lorg/jetbrains/kotlin/ir/util/DescriptorSymbolTableExtension;", "Extension", "backend.jvm.entrypoint"})
public final class SymbolTableWithBuiltInsDeduplication
extends SymbolTable {
    @Nullable
    private KotlinBuiltIns builtIns;

    public SymbolTableWithBuiltInsDeduplication(@NotNull IdSignatureComposer signaturer, @NotNull IrFactory irFactory) {
        Intrinsics.checkNotNullParameter(signaturer, "signaturer");
        Intrinsics.checkNotNullParameter(irFactory, "irFactory");
        super(signaturer, irFactory, null, null, 12, null);
    }

    public final void bindBuiltIns(@NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        if (this.builtIns != null) {
            throw new IllegalStateException("`builtIns` have already been bound.");
        }
        this.builtIns = builtIns;
    }

    @Override
    @NotNull
    protected DescriptorSymbolTableExtension createDescriptorExtension() {
        return new Extension();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/SymbolTableWithBuiltInsDeduplication$Extension;", "Lorg/jetbrains/kotlin/ir/util/DescriptorSymbolTableExtension;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/SymbolTableWithBuiltInsDeduplication;)V", "referenceClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "declaration", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "backend.jvm.entrypoint"})
    private final class Extension
    extends DescriptorSymbolTableExtension {
        public Extension() {
            super(SymbolTableWithBuiltInsDeduplication.this);
        }

        @Override
        @ObsoleteDescriptorBasedAPI
        @NotNull
        public IrClassSymbol referenceClass(@NotNull ClassDescriptor declaration) {
            ClassDescriptor builtInDescriptor;
            ClassifierDescriptor classifierDescriptor;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            FqName fqName2 = DescriptorUtilKt.containingPackage(declaration);
            if (fqName2 == null) {
                return super.referenceClass(declaration);
            }
            FqName packageFqName = fqName2;
            Object object = SymbolTableWithBuiltInsDeduplication.this.builtIns;
            if (object != null && (object = ((KotlinBuiltIns)object).getBuiltInsModule()) != null && (object = ((ModuleDescriptorImpl)object).getPackage(packageFqName)) != null && (object = object.getMemberScope()) != null) {
                Name name2 = declaration.getName();
                Intrinsics.checkNotNullExpressionValue(name2, "getName(...)");
                classifierDescriptor = object.getContributedClassifier(name2, NoLookupLocation.FROM_BACKEND);
            } else {
                classifierDescriptor = null;
            }
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
            ClassDescriptor classDescriptor = builtInDescriptor = classifierDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor2 : null;
            if (builtInDescriptor != null) {
                return super.referenceClass(builtInDescriptor);
            }
            return super.referenceClass(declaration);
        }
    }
}

