/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.fasterxml.aalto.in;

import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.ReaderConfig;

public final class MergedStream
extends InputStream {
    private final ReaderConfig mConfig;
    private final InputStream mIn;
    private byte[] mData;
    private int mPtr;
    private final int mEnd;

    public MergedStream(ReaderConfig cfg, InputStream in, byte[] buf, int start, int end) {
        this.mConfig = cfg;
        this.mIn = in;
        this.mData = buf;
        this.mPtr = start;
        this.mEnd = end;
    }

    @Override
    public int available() throws IOException {
        if (this.mData != null) {
            return this.mEnd - this.mPtr;
        }
        return this.mIn.available();
    }

    @Override
    public void close() throws IOException {
        this.freeBuffers();
        this.mIn.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.mData == null) {
            this.mIn.mark(readlimit);
        }
    }

    @Override
    public boolean markSupported() {
        return this.mData == null && this.mIn.markSupported();
    }

    @Override
    public int read() throws IOException {
        if (this.mData != null) {
            int c2 = this.mData[this.mPtr++] & 0xFF;
            if (this.mPtr >= this.mEnd) {
                this.freeBuffers();
            }
            return c2;
        }
        return this.mIn.read();
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.mData != null) {
            int avail = this.mEnd - this.mPtr;
            if (len > avail) {
                len = avail;
            }
            System.arraycopy(this.mData, this.mPtr, b2, off, len);
            this.mPtr += len;
            if (this.mPtr >= this.mEnd) {
                this.freeBuffers();
            }
            return len;
        }
        return this.mIn.read(b2, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mData == null) {
            this.mIn.reset();
        }
    }

    @Override
    public long skip(long n2) throws IOException {
        long count2 = 0L;
        if (this.mData != null) {
            int amount = this.mEnd - this.mPtr;
            if ((long)amount > n2) {
                this.mPtr += (int)n2;
                return n2;
            }
            this.freeBuffers();
            count2 += (long)amount;
            n2 -= (long)amount;
        }
        if (n2 > 0L) {
            count2 += this.mIn.skip(n2);
        }
        return count2;
    }

    private void freeBuffers() {
        if (this.mData != null) {
            byte[] data2 = this.mData;
            this.mData = null;
            if (this.mConfig != null) {
                this.mConfig.freeFullBBuffer(data2);
            }
        }
    }
}

