/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.javaInterop;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalCompilerRunner;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.IncrementalJvmCachesManager;
import org.jetbrains.kotlin.incremental.JavaClassesTrackerImpl;
import org.jetbrains.kotlin.incremental.dirtyFiles.DirtyFilesContainer;
import org.jetbrains.kotlin.incremental.javaInterop.JavaInteropCoordinator;
import org.jetbrains.kotlin.load.java.JavaClassesTracker;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\fH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/incremental/javaInterop/PreciseJavaInteropCoordinator;", "Lorg/jetbrains/kotlin/incremental/javaInterop/JavaInteropCoordinator;", "reporter", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "<init>", "(Lorg/jetbrains/kotlin/build/report/BuildReporter;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "changedUntrackedJavaClasses", "", "Lorg/jetbrains/kotlin/name/ClassId;", "hasChangedUntrackedJavaClasses", "", "makeJavaClassesTracker", "Lorg/jetbrains/kotlin/load/java/JavaClassesTracker;", "platformCache", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "analyzeChangesInJavaSources", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode$Rebuild;", "caches", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCachesManager;", "changedFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$DeterminableFiles$Known;", "mutableDirtyFiles", "Lorg/jetbrains/kotlin/incremental/dirtyFiles/DirtyFilesContainer;", "processChangedJava", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "processChangedUntrackedJavaClass", "", "psiClass", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiClass;", "classId", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nJavaInteropCoordinator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaInteropCoordinator.kt\norg/jetbrains/kotlin/incremental/javaInterop/PreciseJavaInteropCoordinator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n774#2:192\n865#2,2:193\n*S KotlinDebug\n*F\n+ 1 JavaInteropCoordinator.kt\norg/jetbrains/kotlin/incremental/javaInterop/PreciseJavaInteropCoordinator\n*L\n91#1:192\n91#1:193,2\n*E\n"})
final class PreciseJavaInteropCoordinator
extends JavaInteropCoordinator {
    @NotNull
    private final BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter;
    @NotNull
    private final Set<ClassId> changedUntrackedJavaClasses;

    public PreciseJavaInteropCoordinator(@NotNull BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        super(messageCollector, null);
        this.reporter = reporter;
        this.changedUntrackedJavaClasses = new LinkedHashSet();
    }

    @Override
    public boolean hasChangedUntrackedJavaClasses() {
        return !((Collection)this.changedUntrackedJavaClasses).isEmpty();
    }

    @Override
    @Nullable
    public JavaClassesTracker makeJavaClassesTracker(@NotNull IncrementalJvmCache platformCache) {
        Intrinsics.checkNotNullParameter(platformCache, "platformCache");
        JavaClassesTrackerImpl changesTracker = new JavaClassesTrackerImpl(platformCache, CollectionsKt.toSet((Iterable)this.changedUntrackedJavaClasses), CommonConfigurationKeysKt.getLanguageVersionSettings(this.getCompilerConfiguration()));
        this.changedUntrackedJavaClasses.clear();
        return changesTracker;
    }

    @Override
    @Nullable
    public IncrementalCompilerRunner.CompilationMode.Rebuild analyzeChangesInJavaSources(@NotNull IncrementalJvmCachesManager caches, @NotNull ChangedFiles.DeterminableFiles.Known changedFiles, @NotNull DirtyFilesContainer mutableDirtyFiles) {
        Intrinsics.checkNotNullParameter(caches, "caches");
        Intrinsics.checkNotNullParameter(changedFiles, "changedFiles");
        Intrinsics.checkNotNullParameter(mutableDirtyFiles, "mutableDirtyFiles");
        BuildAttribute rebuildReason = this.processChangedJava(changedFiles, caches);
        if (rebuildReason != null) {
            return new IncrementalCompilerRunner.CompilationMode.Rebuild(rebuildReason);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final BuildAttribute processChangedJava(ChangedFiles.DeterminableFiles.Known changedFiles, IncrementalJvmCachesManager caches) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)changedFiles.getModified(), (Iterable)changedFiles.getRemoved());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File p0 = (File)element$iv$iv;
            boolean bl = false;
            if (!FileUtilsKt.isJavaFile(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List javaFiles = (List)destination$iv$iv;
        for (File javaFile : javaFiles) {
            PsiClass[] psiClassArray;
            if (caches.getPlatformCache().isTrackedFile(javaFile)) continue;
            if (!javaFile.exists()) {
                ICReporterKt.info(this.reporter, () -> PreciseJavaInteropCoordinator.processChangedJava$lambda$0(javaFile));
                return BuildAttribute.JAVA_CHANGE_UNTRACKED_FILE_IS_REMOVED;
            }
            PsiFile psiFile = this.getPsiJavaFile(javaFile);
            if (!(psiFile instanceof PsiJavaFile)) {
                ICReporterKt.info(this.reporter, () -> PreciseJavaInteropCoordinator.processChangedJava$lambda$1(psiFile));
                return BuildAttribute.JAVA_CHANGE_UNEXPECTED_PSI;
            }
            Intrinsics.checkNotNullExpressionValue(((PsiJavaFile)psiFile).getClasses(), "getClasses(...)");
            for (PsiClass psiClass : psiClassArray) {
                String qualifiedName2 = psiClass.getQualifiedName();
                if (qualifiedName2 == null) {
                    ICReporterKt.info(this.reporter, () -> PreciseJavaInteropCoordinator.processChangedJava$lambda$2(javaFile));
                    return BuildAttribute.JAVA_CHANGE_UNKNOWN_QUALIFIER;
                }
                Intrinsics.checkNotNull(psiClass);
                this.processChangedUntrackedJavaClass(psiClass, ClassId.Companion.topLevel(new FqName(qualifiedName2)));
            }
        }
        caches.getPlatformCache().markDirty((Collection)javaFiles);
        return null;
    }

    private final void processChangedUntrackedJavaClass(PsiClass psiClass, ClassId classId) {
        this.changedUntrackedJavaClasses.add(classId);
        PsiClass[] psiClassArray = psiClass.getInnerClasses();
        Intrinsics.checkNotNullExpressionValue(psiClassArray, "getInnerClasses(...)");
        for (PsiClass innerClass : psiClassArray) {
            String name2;
            if (innerClass.getName() == null) continue;
            Intrinsics.checkNotNull(innerClass);
            Name name3 = Name.identifier(name2);
            Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
            this.processChangedUntrackedJavaClass(innerClass, classId.createNestedClassId(name3));
        }
    }

    private static final String processChangedJava$lambda$0(File $javaFile) {
        return "Could not get changed for untracked removed java file " + $javaFile;
    }

    private static final String processChangedJava$lambda$1(PsiFile $psiFile) {
        PsiFile psiFile = $psiFile;
        return "[Precise Java tracking] Expected PsiJavaFile, got " + (psiFile != null ? psiFile.getClass() : null);
    }

    private static final String processChangedJava$lambda$2(File $javaFile) {
        return "[Precise Java tracking] Class with unknown qualified name in " + $javaFile;
    }
}

