/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.utils;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.kotlin.org.jline.terminal.Terminal;
import org.jetbrains.kotlin.org.jline.utils.AttributedString;
import org.jetbrains.kotlin.org.jline.utils.AttributedStyle;
import org.jetbrains.kotlin.org.jline.utils.ColorPalette;
import org.jetbrains.kotlin.org.jline.utils.Curses;
import org.jetbrains.kotlin.org.jline.utils.InfoCmp;
import org.jetbrains.kotlin.org.jline.utils.WCWidth;

public abstract class AttributedCharSequence
implements CharSequence {
    static final boolean DISABLE_ALTERNATE_CHARSET = Boolean.getBoolean("org.jetbrains.kotlin.org.jline.utils.disableAlternateCharset");

    public void print(Terminal terminal) {
        terminal.writer().print(this.toAnsi(terminal));
    }

    public void println(Terminal terminal) {
        terminal.writer().println(this.toAnsi(terminal));
    }

    public String toAnsi(Terminal terminal) {
        if (terminal != null && "dumb".equals(terminal.getType())) {
            return this.toString();
        }
        int colors = 256;
        ForceMode forceMode = ForceMode.None;
        ColorPalette palette = null;
        String alternateIn = null;
        String alternateOut = null;
        if (terminal != null) {
            Integer max_colors = terminal.getNumericCapability(InfoCmp.Capability.max_colors);
            if (max_colors != null) {
                colors = max_colors;
            }
            if ("windows-256color".equals(terminal.getType()) || "windows-conemu".equals(terminal.getType())) {
                forceMode = ForceMode.Force256Colors;
            }
            palette = terminal.getPalette();
            if (!DISABLE_ALTERNATE_CHARSET) {
                alternateIn = Curses.tputs(terminal.getStringCapability(InfoCmp.Capability.enter_alt_charset_mode), new Object[0]);
                alternateOut = Curses.tputs(terminal.getStringCapability(InfoCmp.Capability.exit_alt_charset_mode), new Object[0]);
            }
        }
        return this.toAnsi(colors, forceMode, palette, alternateIn, alternateOut);
    }

    public String toAnsi(int colors, ForceMode force) {
        return this.toAnsi(colors, force, null, null, null);
    }

    public String toAnsi(int colors, ForceMode force, ColorPalette palette, String altIn, String altOut) {
        StringBuilder sb = new StringBuilder();
        long style = 0L;
        long foreground = 0L;
        long background = 0L;
        boolean alt = false;
        if (palette == null) {
            palette = ColorPalette.DEFAULT;
        }
        for (int i2 = 0; i2 < this.length(); ++i2) {
            long s2;
            char c2 = this.charAt(i2);
            if (altIn != null && altOut != null) {
                char pc = c2;
                switch (c2) {
                    case '\u2518': {
                        c2 = 'j';
                        break;
                    }
                    case '\u2510': {
                        c2 = 'k';
                        break;
                    }
                    case '\u250c': {
                        c2 = 'l';
                        break;
                    }
                    case '\u2514': {
                        c2 = 'm';
                        break;
                    }
                    case '\u253c': {
                        c2 = 'n';
                        break;
                    }
                    case '\u2500': {
                        c2 = 'q';
                        break;
                    }
                    case '\u251c': {
                        c2 = 't';
                        break;
                    }
                    case '\u2524': {
                        c2 = 'u';
                        break;
                    }
                    case '\u2534': {
                        c2 = 'v';
                        break;
                    }
                    case '\u252c': {
                        c2 = 'w';
                        break;
                    }
                    case '\u2502': {
                        c2 = 'x';
                    }
                }
                boolean oldalt = alt;
                boolean bl = alt = c2 != pc;
                if (oldalt ^ alt) {
                    sb.append(alt ? altIn : altOut);
                }
            }
            if (style != (s2 = this.styleCodeAt(i2) & 0xFFFFFFFFFFFFEFFFL)) {
                long bg;
                long d2 = (style ^ s2) & 0x1FFFL;
                long fg = (s2 & 0x300L) != 0L ? s2 & 0x7FFFFF8300L : 0L;
                long l2 = bg = (s2 & 0xC00L) != 0L ? s2 & 0x7FFFFF8000000C00L : 0L;
                if (s2 == 0L) {
                    sb.append("\u001b[0m");
                    background = 0L;
                    foreground = 0L;
                } else {
                    int b2;
                    int g2;
                    int r2;
                    int col;
                    int b3;
                    int g3;
                    int r3;
                    int rounded;
                    sb.append("\u001b[");
                    boolean first2 = true;
                    if ((d2 & 4L) != 0L) {
                        first2 = AttributedCharSequence.attr(sb, (s2 & 4L) != 0L ? "3" : "23", first2);
                    }
                    if ((d2 & 8L) != 0L) {
                        first2 = AttributedCharSequence.attr(sb, (s2 & 8L) != 0L ? "4" : "24", first2);
                    }
                    if ((d2 & 0x10L) != 0L) {
                        first2 = AttributedCharSequence.attr(sb, (s2 & 0x10L) != 0L ? "5" : "25", first2);
                    }
                    if ((d2 & 0x20L) != 0L) {
                        first2 = AttributedCharSequence.attr(sb, (s2 & 0x20L) != 0L ? "7" : "27", first2);
                    }
                    if ((d2 & 0x40L) != 0L) {
                        first2 = AttributedCharSequence.attr(sb, (s2 & 0x40L) != 0L ? "8" : "28", first2);
                    }
                    if ((d2 & 0x80L) != 0L) {
                        first2 = AttributedCharSequence.attr(sb, (s2 & 0x80L) != 0L ? "9" : "29", first2);
                    }
                    if (foreground != fg) {
                        if (fg > 0L) {
                            rounded = -1;
                            if ((fg & 0x200L) != 0L) {
                                r3 = (int)(fg >> 31) & 0xFF;
                                g3 = (int)(fg >> 23) & 0xFF;
                                b3 = (int)(fg >> 15) & 0xFF;
                                if (colors >= Short.MAX_VALUE) {
                                    first2 = AttributedCharSequence.attr(sb, "38;2;" + r3 + ";" + g3 + ";" + b3, first2);
                                } else {
                                    rounded = palette.round(r3, g3, b3);
                                }
                            } else if ((fg & 0x100L) != 0L) {
                                rounded = palette.round((int)(fg >> 15) & 0xFF);
                            }
                            if (rounded >= 0) {
                                if (colors >= Short.MAX_VALUE && force == ForceMode.ForceTrueColors) {
                                    col = palette.getColor(rounded);
                                    r2 = col >> 16 & 0xFF;
                                    g2 = col >> 8 & 0xFF;
                                    b2 = col & 0xFF;
                                    first2 = AttributedCharSequence.attr(sb, "38;2;" + r2 + ";" + g2 + ";" + b2, first2);
                                } else if (force == ForceMode.Force256Colors || rounded >= 16) {
                                    first2 = AttributedCharSequence.attr(sb, "38;5;" + rounded, first2);
                                } else if (rounded >= 8) {
                                    first2 = AttributedCharSequence.attr(sb, "9" + (rounded - 8), first2);
                                    d2 |= s2 & 1L;
                                } else {
                                    first2 = AttributedCharSequence.attr(sb, "3" + rounded, first2);
                                    d2 |= s2 & 1L;
                                }
                            }
                        } else {
                            first2 = AttributedCharSequence.attr(sb, "39", first2);
                        }
                        foreground = fg;
                    }
                    if (background != bg) {
                        if (bg > 0L) {
                            rounded = -1;
                            if ((bg & 0x800L) != 0L) {
                                r3 = (int)(bg >> 55) & 0xFF;
                                g3 = (int)(bg >> 47) & 0xFF;
                                b3 = (int)(bg >> 39) & 0xFF;
                                if (colors >= Short.MAX_VALUE) {
                                    first2 = AttributedCharSequence.attr(sb, "48;2;" + r3 + ";" + g3 + ";" + b3, first2);
                                } else {
                                    rounded = palette.round(r3, g3, b3);
                                }
                            } else if ((bg & 0x400L) != 0L) {
                                rounded = palette.round((int)(bg >> 39) & 0xFF);
                            }
                            if (rounded >= 0) {
                                if (colors >= Short.MAX_VALUE && force == ForceMode.ForceTrueColors) {
                                    col = palette.getColor(rounded);
                                    r2 = col >> 16 & 0xFF;
                                    g2 = col >> 8 & 0xFF;
                                    b2 = col & 0xFF;
                                    first2 = AttributedCharSequence.attr(sb, "48;2;" + r2 + ";" + g2 + ";" + b2, first2);
                                } else {
                                    first2 = force == ForceMode.Force256Colors || rounded >= 16 ? AttributedCharSequence.attr(sb, "48;5;" + rounded, first2) : (rounded >= 8 ? AttributedCharSequence.attr(sb, "10" + (rounded - 8), first2) : AttributedCharSequence.attr(sb, "4" + rounded, first2));
                                }
                            }
                        } else {
                            first2 = AttributedCharSequence.attr(sb, "49", first2);
                        }
                        background = bg;
                    }
                    if ((d2 & 3L) != 0L) {
                        if ((d2 & 1L) != 0L && (s2 & 1L) == 0L || (d2 & 2L) != 0L && (s2 & 2L) == 0L) {
                            first2 = AttributedCharSequence.attr(sb, "22", first2);
                        }
                        if ((d2 & 1L) != 0L && (s2 & 1L) != 0L) {
                            first2 = AttributedCharSequence.attr(sb, "1", first2);
                        }
                        if ((d2 & 2L) != 0L && (s2 & 2L) != 0L) {
                            first2 = AttributedCharSequence.attr(sb, "2", first2);
                        }
                    }
                    sb.append("m");
                }
                style = s2;
            }
            sb.append(c2);
        }
        if (alt) {
            sb.append(altOut);
        }
        if (style != 0L) {
            sb.append("\u001b[0m");
        }
        return sb.toString();
    }

    private static boolean attr(StringBuilder sb, String s2, boolean first2) {
        if (!first2) {
            sb.append(";");
        }
        sb.append(s2);
        return false;
    }

    public abstract AttributedStyle styleAt(int var1);

    long styleCodeAt(int index) {
        return this.styleAt(index).getStyle();
    }

    public boolean isHidden(int index) {
        return (this.styleCodeAt(index) & 0x1000L) != 0L;
    }

    @Override
    public abstract AttributedString subSequence(int var1, int var2);

    public AttributedString substring(int start, int end) {
        return this.subSequence(start, end);
    }

    protected abstract char[] buffer();

    protected abstract int offset();

    @Override
    public char charAt(int index) {
        return this.buffer()[this.offset() + index];
    }

    public int codePointAt(int index) {
        return Character.codePointAt(this.buffer(), index + this.offset());
    }

    public boolean contains(char c2) {
        for (int i2 = 0; i2 < this.length(); ++i2) {
            if (this.charAt(i2) != c2) continue;
            return true;
        }
        return false;
    }

    public int columnLength() {
        int cp;
        int cols = 0;
        int len = this.length();
        for (int cur = 0; cur < len; cur += Character.charCount(cp)) {
            cp = this.codePointAt(cur);
            if (this.isHidden(cur)) continue;
            cols += WCWidth.wcwidth(cp);
        }
        return cols;
    }

    public AttributedString columnSubSequence(int start, int stop) {
        int cp;
        int begin = 0;
        int col = 0;
        while (begin < this.length()) {
            int w2;
            int cp2 = this.codePointAt(begin);
            int n2 = w2 = this.isHidden(begin) ? 0 : WCWidth.wcwidth(cp2);
            if (col + w2 > start) break;
            begin += Character.charCount(cp2);
            col += w2;
        }
        int end = begin;
        while (end < this.length() && (cp = this.codePointAt(end)) != 10) {
            int w3;
            int n3 = w3 = this.isHidden(end) ? 0 : WCWidth.wcwidth(cp);
            if (col + w3 > stop) break;
            end += Character.charCount(cp);
            col += w3;
        }
        return this.subSequence(begin, end);
    }

    public List<AttributedString> columnSplitLength(int columns) {
        return this.columnSplitLength(columns, false, true);
    }

    public List<AttributedString> columnSplitLength(int columns, boolean includeNewlines, boolean delayLineWrap) {
        int cur;
        ArrayList<AttributedString> strings2 = new ArrayList<AttributedString>();
        int beg = cur = 0;
        int col = 0;
        while (cur < this.length()) {
            int w2;
            int cp = this.codePointAt(cur);
            int n2 = w2 = this.isHidden(cur) ? 0 : WCWidth.wcwidth(cp);
            if (cp == 10) {
                strings2.add(this.subSequence(beg, includeNewlines ? cur + 1 : cur));
                beg = cur + 1;
                col = 0;
            } else if ((col += w2) > columns) {
                strings2.add(this.subSequence(beg, cur));
                beg = cur;
                col = w2;
            }
            cur += Character.charCount(cp);
        }
        strings2.add(this.subSequence(beg, cur));
        return strings2;
    }

    @Override
    public String toString() {
        return new String(this.buffer(), this.offset(), this.length());
    }

    public AttributedString toAttributedString() {
        return this.substring(0, this.length());
    }

    public static enum ForceMode {
        None,
        Force256Colors,
        ForceTrueColors;

    }
}

