/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.DFS;

public class BoundsSubstitutor {
    private BoundsSubstitutor() {
    }

    @NotNull
    public static <D extends CallableDescriptor> D substituteBounds(@NotNull D functionDescriptor) {
        List<TypeParameterDescriptor> typeParameters2;
        if (functionDescriptor == null) {
            BoundsSubstitutor.$$$reportNull$$$0(0);
        }
        if ((typeParameters2 = functionDescriptor.getTypeParameters()).isEmpty()) {
            D d2 = functionDescriptor;
            if (d2 == null) {
                BoundsSubstitutor.$$$reportNull$$$0(1);
            }
            return d2;
        }
        CallableDescriptor substitutedFunction = (CallableDescriptor)functionDescriptor.substitute(BoundsSubstitutor.createUpperBoundsSubstitutor(typeParameters2));
        assert (substitutedFunction != null) : "Substituting upper bounds should always be legal";
        CallableDescriptor callableDescriptor = substitutedFunction;
        if (callableDescriptor == null) {
            BoundsSubstitutor.$$$reportNull$$$0(2);
        }
        return (D)callableDescriptor;
    }

    @NotNull
    public static <D extends CallableDescriptor> TypeSubstitutor createUpperBoundsSubstitutor(@NotNull D callableDescriptor) {
        if (callableDescriptor == null) {
            BoundsSubstitutor.$$$reportNull$$$0(3);
        }
        return BoundsSubstitutor.createUpperBoundsSubstitutor(callableDescriptor.getTypeParameters());
    }

    @NotNull
    private static TypeSubstitutor createUpperBoundsSubstitutor(@NotNull List<TypeParameterDescriptor> typeParameters2) {
        if (typeParameters2 == null) {
            BoundsSubstitutor.$$$reportNull$$$0(4);
        }
        HashMap<TypeConstructor, TypeProjection> mutableSubstitution = new HashMap<TypeConstructor, TypeProjection>();
        TypeSubstitutor substitutor2 = TypeSubstitutor.create(mutableSubstitution);
        for (TypeParameterDescriptor descriptor2 : BoundsSubstitutor.topologicallySortTypeParameters(typeParameters2)) {
            KotlinType upperBoundsAsType = TypeIntersector.getUpperBoundsAsType(descriptor2);
            KotlinType substitutedUpperBoundsAsType = substitutor2.substitute(upperBoundsAsType, Variance.INVARIANT);
            mutableSubstitution.put(descriptor2.getTypeConstructor(), new TypeProjectionImpl(substitutedUpperBoundsAsType));
        }
        TypeSubstitutor typeSubstitutor2 = substitutor2;
        if (typeSubstitutor2 == null) {
            BoundsSubstitutor.$$$reportNull$$$0(5);
        }
        return typeSubstitutor2;
    }

    @NotNull
    private static List<TypeParameterDescriptor> topologicallySortTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters2) {
        if (typeParameters2 == null) {
            BoundsSubstitutor.$$$reportNull$$$0(6);
        }
        List<TypeParameterDescriptor> topOrder = DFS.topologicalOrder(typeParameters2, current -> BoundsSubstitutor.getTypeParametersFromUpperBounds(current, typeParameters2));
        assert (topOrder.size() == typeParameters2.size()) : "All type parameters must be visited, but only " + topOrder + " were";
        Collections.reverse(topOrder);
        List<TypeParameterDescriptor> list = topOrder;
        if (list == null) {
            BoundsSubstitutor.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static List<TypeParameterDescriptor> getTypeParametersFromUpperBounds(@NotNull TypeParameterDescriptor current, final @NotNull List<TypeParameterDescriptor> typeParameters2) {
        if (current == null) {
            BoundsSubstitutor.$$$reportNull$$$0(8);
        }
        if (typeParameters2 == null) {
            BoundsSubstitutor.$$$reportNull$$$0(9);
        }
        List list = DFS.dfs(current.getUpperBounds(), typeParameter -> CollectionsKt.map(typeParameter.getArguments(), TypeProjection::getType), new DFS.NodeHandlerWithListResult<KotlinType, TypeParameterDescriptor>(){

            @Override
            public boolean beforeChildren(KotlinType current) {
                ClassifierDescriptor declarationDescriptor = current.getConstructor().getDeclarationDescriptor();
                if (typeParameters2.contains(declarationDescriptor)) {
                    ((LinkedList)this.result).add((TypeParameterDescriptor)declarationDescriptor);
                }
                return true;
            }
        });
        if (list == null) {
            BoundsSubstitutor.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/BoundsSubstitutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableDescriptor";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/BoundsSubstitutor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteBounds";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpperBoundsSubstitutor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "topologicallySortTypeParameters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParametersFromUpperBounds";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "substituteBounds";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUpperBoundsSubstitutor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "topologicallySortTypeParameters";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParametersFromUpperBounds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

