import { Component, Props, VNode } from 'inferno';
import { TLoaderData } from './Router';
export interface IStaticRouterProps<T> extends Props<T> {
    initialData?: Record<string, TLoaderData>;
    basename?: string;
    context: any;
    location: any;
}
export declare class StaticRouter<S> extends Component<IStaticRouterProps<any>, S> {
    static defaultProps: {
        basename: string;
        location: string;
    };
    getChildContext(): {
        router: {
            initialData: Record<string, TLoaderData> | undefined;
            staticContext: any;
        };
    };
    createHref: (path: any) => any;
    handlePush: (location: any) => void;
    handleReplace: (location: any) => void;
    handleListen: () => () => void;
    handleBlock: () => () => void;
    render({ basename, context, location, ...props }: {
        [x: string]: any;
        basename: any;
        context: any;
        location: any;
    }): VNode;
}
