import type { TLoaderData } from './Router';
export declare function resolveLoaders(loaderEntries: TLoaderEntry[]): Promise<Record<string, TLoaderData>>;
type TLoaderEntry = {
    path: string;
    params: Record<string, any>;
    request: Request;
    controller: AbortController;
    loader: (TLoaderProps: any) => Promise<TLoaderEntry>;
};
export declare function traverseLoaders(location: string, tree: any, base?: string): TLoaderEntry[];
export type FormEncType = 'application/x-www-form-urlencoded' | 'multipart/form-data';
export type MutationFormMethod = 'post' | 'put' | 'patch' | 'delete';
export type FormMethod = 'get' | MutationFormMethod;
/**
 * @private
 * Internal interface to pass around for action submissions, not intended for
 * external consumption
 */
export interface Submission {
    formMethod: FormMethod;
    formAction: string;
    formEncType: FormEncType;
    formData: FormData;
}
/**
 * Parses a string URL path into its separate pathname, search, and hash components.
 */
export declare function createClientSideURL(location: Location | string, base?: string): URL;
export {};
