import type { Inferno, InfernoNode } from './types';
import { IComponent, VNode } from './types';
export declare function rerender(): void;
export type ComponentType<P = {}> = typeof Component<P> | Inferno.StatelessComponent<P>;
export declare abstract class Component<P = {}, S = {}> implements IComponent<P, S> {
    state: Readonly<S | null>;
    props: Readonly<{
        children?: InfernoNode;
    }> & Readonly<P>;
    context: any;
    displayName?: string;
    $BR: boolean;
    $BS: boolean;
    $PS: Partial<S> | null;
    $LI: any;
    $UN: boolean;
    $CX: any;
    $QU: Function[] | null;
    $N: boolean;
    $SSR?: boolean;
    $L: Function[] | null;
    $SVG: boolean;
    $F: boolean;
    constructor(props?: P, context?: any);
    forceUpdate(callback?: Function): void;
    setState<K extends keyof S>(newState: ((prevState: Readonly<S>, props: Readonly<{
        children?: InfernoNode;
    } & P>) => Pick<S, K> | S | null) | (Pick<S, K> | S | null), callback?: () => void): void;
    componentDidMount?(): void;
    componentWillMount?(): void;
    componentWillReceiveProps?(nextProps: Readonly<{
        children?: InfernoNode;
    } & P>, nextContext: any): void;
    shouldComponentUpdate?(nextProps: Readonly<{
        children?: InfernoNode;
    } & P>, nextState: Readonly<S>, context: any): boolean;
    componentWillUpdate?(nextProps: Readonly<{
        children?: InfernoNode;
    } & P>, nextState: Readonly<S>, context: any): void;
    componentDidUpdate?(prevProps: Readonly<{
        children?: InfernoNode;
    } & P>, prevState: Readonly<S>, snapshot: any): void;
    componentWillUnmount?(): void;
    componentDidAppear?(domNode: Element): void;
    componentWillDisappear?(domNode: Element, callback: Function): void;
    componentWillMove?(parentVNode: VNode, parentDOM: Element, dom: Element): void;
    getChildContext?(): void;
    getSnapshotBeforeUpdate?(prevProps: Readonly<{
        children?: InfernoNode;
    } & P>, prevState: Readonly<S>): any;
    static defaultProps?: {} | null;
    static getDerivedStateFromProps?(nextProps: any, state: any): any;
    render(props: Readonly<{
        children?: InfernoNode;
    } & P>, state: Readonly<S>, context: any): InfernoNode;
}
