/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcVarType;

public class NcCartesianVarType
extends NcVarType {
    private boolean lon_;
    private boolean lat_;
    private boolean vert_;
    private boolean time_;

    public NcCartesianVarType() {
        super(NcVarType.VarType.GRIDDED);
    }

    public NcCartesianVarType(boolean hasLon, boolean hasLat, boolean hasVert, boolean hasTime) {
        this();
        this.lon_ = hasLon;
        this.lat_ = hasLat;
        this.vert_ = hasVert;
        this.time_ = hasTime;
    }

    public boolean hasAxis(NcAxisType atype) {
        if (atype == NcAxisType.LON && this.lon_) {
            return true;
        }
        if (atype == NcAxisType.LAT && this.lat_) {
            return true;
        }
        if (atype == NcAxisType.VERT && this.vert_) {
            return true;
        }
        return atype == NcAxisType.TIME && this.time_;
    }

    @Override
    public boolean isGeoreferenced() {
        int goodAxes = 0;
        if (this.lon_) {
            ++goodAxes;
        }
        if (this.lat_) {
            ++goodAxes;
        }
        if (this.vert_) {
            ++goodAxes;
        }
        if (this.time_) {
            ++goodAxes;
        }
        return goodAxes >= 2;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("NcCartesianVarType(");
        boolean needsComma = false;
        if (this.lon_) {
            sb.append("LON");
            needsComma = true;
        }
        if (this.lat_) {
            if (needsComma) {
                sb.append(',');
            }
            sb.append("LAT");
            needsComma = true;
        }
        if (this.vert_) {
            if (needsComma) {
                sb.append(',');
            }
            sb.append("VERT");
            needsComma = true;
        }
        if (this.time_) {
            if (needsComma) {
                sb.append(',');
            }
            sb.append("TIME");
        }
        sb.append(')');
        return sb.toString();
    }
}

