/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVariable;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.InvalidRangeException;

public abstract class NcArray2D
extends NcArray {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MAX_ELEMENTS;
    private static final int CHUNK_ELEMENTS;
    protected NcAxis xAxis_;
    protected NcAxis yAxis_;
    protected int xDimIndex_ = -1;
    protected int yDimIndex_ = -1;
    private int aveDimIndex_ = -1;
    private int numCols_ = -1;
    private int numRows_ = -1;
    private int numAves_ = -1;
    private int maxRows_;
    private int rowOverlap_;
    private int maxAveSlices_;
    private int sliceOffset_;
    private int sliceRows_;
    private double[][] averages_;

    public NcArray2D(NcVariable ncvar) throws NcException {
        super(ncvar);
    }

    protected abstract void createAxes();

    protected void setAveDimIndex(int index) {
        if (index < 0) {
            return;
        }
        try {
            this.aveDimIndex_ = index;
            this.setSliceIndex(this.aveDimIndex_, -1);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception trying to set averaging dimension: {}", (Object)exc.toString());
            this.aveDimIndex_ = -1;
        }
    }

    protected void measureAxes() {
        if (this.xDimIndex_ < 0) {
            throw new NcException("X-dimension index is not set.");
        }
        if (this.yDimIndex_ < 0) {
            throw new NcException("Y-dimension index is not set.");
        }
        this.numCols_ = this.shape_[this.xDimIndex_];
        this.numRows_ = this.shape_[this.yDimIndex_];
        long total = (long)this.numCols_ * (long)this.numRows_;
        if (total < (long)MAX_ELEMENTS) {
            this.maxRows_ = this.numRows_;
        } else {
            this.maxRows_ = MAX_ELEMENTS / this.numCols_;
            if (this.maxRows_ > this.numRows_) {
                this.maxRows_ = this.numRows_;
            } else if (this.maxRows_ > 200) {
                this.maxRows_ = this.maxRows_ / 200 * 200;
            } else if (this.maxRows_ > 160) {
                this.maxRows_ = this.maxRows_ / 160 * 160;
            } else if (this.maxRows_ > 128) {
                this.maxRows_ = this.maxRows_ / 128 * 128;
            } else if (this.maxRows_ > 64) {
                this.maxRows_ = this.maxRows_ / 64 * 64;
            }
        }
        this.rowOverlap_ = Math.max(this.maxRows_ / 16, 24);
        this.rowOverlap_ -= this.rowOverlap_ % 8;
        LOGGER.trace("Max rows {}, overlap {}", (Object)this.maxRows_, (Object)this.rowOverlap_);
        if (this.maxRows_ == this.numRows_ && this.aveDimIndex_ > -1) {
            this.numAves_ = this.shape_[this.aveDimIndex_];
            this.maxAveSlices_ = CHUNK_ELEMENTS / (this.maxRows_ * this.numCols_);
            this.maxAveSlices_ = Math.max(this.maxAveSlices_, 1);
            this.maxAveSlices_ = Math.min(this.maxAveSlices_, this.numAves_);
        }
    }

    @Override
    protected void createFreeDimensions() {
        if (this.dimensions_ != null) {
            return;
        }
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.xDimIndex_ || i == this.yDimIndex_ ? null : this.getNcDimension(i);
        }
    }

    public int getColumnCount() {
        return this.numCols_;
    }

    public int getRowCount() {
        return this.numRows_;
    }

    public NcAxis getXAxis() {
        return this.xAxis_;
    }

    public NcAxis getYAxis() {
        return this.yAxis_;
    }

    public int getXDimensionIndex() {
        return this.xDimIndex_;
    }

    public int getYDimensionIndex() {
        return this.yDimIndex_;
    }

    @Override
    public boolean isAveragingDimension(int dimIndex) {
        return dimIndex == this.aveDimIndex_;
    }

    public double valueAt(int col, int row) {
        if (row < 0 || row >= this.numRows_) {
            throw new IndexOutOfBoundsException(String.format("Row index %d outside range: %d", row, this.numRows_));
        }
        if (col < 0 || col >= this.numCols_) {
            throw new IndexOutOfBoundsException(String.format("Col index %d outside range: ", col, this.numCols_));
        }
        if (this.aveDimIndex_ > -1 && this.sIndex_[this.aveDimIndex_] == -1) {
            return this.dimensionAverageAt(col, row);
        }
        if (this.needsSlice_ || this.slice_ == null || row < this.sliceOffset_ || row >= this.sliceOffset_ + this.maxRows_) {
            LOGGER.trace("doSlice row {}", (Object)row);
            this.doSlice(row);
            LOGGER.trace("sliceOffset {}", (Object)this.sliceOffset_);
        }
        try {
            int offRow = row - this.sliceOffset_;
            return this.getDoubleFromSlice(col, offRow, -1);
        }
        catch (Exception exc) {
            LOGGER.error("Slice getDouble failed - col {}, row {}", (Object)col, (Object)row);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(exc.toString());
        }
    }

    public double dimensionAverageAt(int col, int row) throws NcException {
        if (this.aveDimIndex_ == -1) {
            throw new NcException("Dimension averaging not set up for this array.");
        }
        if (this.averages_ == null || row < this.sliceOffset_ - 1 || row >= this.sliceOffset_ + this.maxRows_) {
            this.doAverage(row);
        }
        return this.averages_[row - this.sliceOffset_][col];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSlice(int row) throws NcException {
        NcArray2D ncArray2D = this;
        synchronized (ncArray2D) {
            if (this.sliceOffset_ + this.maxRows_ > this.numRows_) {
                this.sliceOffset_ = Math.max(this.numRows_ - this.maxRows_, 0);
            }
            if (this.sliceOffset_ < row) {
                this.sliceOffset_ = row - this.rowOverlap_;
            } else {
                this.sliceOffset_ = row + this.rowOverlap_ - this.maxRows_;
                if (this.sliceOffset_ > row) {
                    this.sliceOffset_ = Math.max(row - this.maxRows_, 0);
                }
            }
            this.sliceOffset_ -= this.sliceOffset_ % 16;
            this.sliceOffset_ = Math.max(this.sliceOffset_, 0);
            this.sliceRows_ = this.sliceOffset_ + this.maxRows_ > this.numRows_ ? this.numRows_ - this.sliceOffset_ : this.maxRows_;
            LOGGER.trace("Slice row {}, sliceOffset {}, sectRows {}", row, this.sliceOffset_, this.sliceRows_);
            int[] sOrigin = new int[this.rank_];
            int[] sShape = new int[this.rank_];
            try {
                this.needsSlice_ = true;
                for (int i = 0; i < this.rank_; ++i) {
                    sOrigin[i] = this.sIndex_[i];
                    sShape[i] = 1;
                }
                sOrigin[this.xDimIndex_] = 0;
                sOrigin[this.yDimIndex_] = this.sliceOffset_;
                sShape[this.xDimIndex_] = this.numCols_;
                sShape[this.yDimIndex_] = this.sliceRows_;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("- sOrigin = {}", (Object)Arrays.toString(sOrigin));
                    LOGGER.trace("- sShape  = {}", (Object)Arrays.toString(sShape));
                }
                LOGGER.trace("- Reading slice");
                this.slice_ = this.read(sOrigin, sShape);
                LOGGER.trace("- Getting index");
                this.sliceIdx_ = this.slice_.getIndex();
                this.needsSlice_ = false;
            }
            catch (InvalidRangeException exc) {
                LOGGER.warn("InvalidRangeException doing slice: {}");
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new ArrayIndexOutOfBoundsException("Failed to slice array from variable due to invalid range exception.");
            }
            catch (NullPointerException exc) {
                LOGGER.warn("NullPointerException doing slice: {}", (Object)exc.toString());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new NcException(String.format("Failed to slice array from variable due to null pointer exception.", new Object[0]));
            }
            catch (Exception exc) {
                LOGGER.warn("Exception doing slice: {}, {}", (Object)exc.getClass().getSimpleName(), (Object)exc.getMessage());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new NcException(exc.getMessage());
            }
        }
    }

    private double getDoubleFromSlice(int col, int row, int ave) {
        int[] ss = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            ss[i] = 0;
        }
        ss[this.xDimIndex_] = col;
        ss[this.yDimIndex_] = row;
        if (ave > -1) {
            ss[this.aveDimIndex_] = ave;
        }
        this.sliceIdx_.set(ss);
        return this.slice_.getDouble(this.sliceIdx_);
    }

    private void doAverage(int row) throws NcException {
        if (this.aveDimIndex_ < 0) {
            throw new NcException("Array has no averaging dimension.");
        }
        this.slice_ = null;
        if (this.averages_ == null) {
            this.averages_ = new double[this.maxRows_][this.numCols_];
        }
        this.sliceOffset_ = this.maxRows_ * (row / this.maxRows_);
        if (this.sliceOffset_ > row - 2) {
            this.sliceOffset_ = Math.max(row - 2, 0);
        }
        this.sliceRows_ = this.sliceOffset_ + this.maxRows_ > this.numRows_ ? this.numRows_ - this.sliceOffset_ : this.maxRows_;
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        int[][] aveCount = new int[this.sliceRows_][this.numCols_];
        for (int k = 0; k < this.sliceRows_; ++k) {
            for (int j = 0; j < this.numCols_; ++j) {
                this.averages_[k][j] = 0.0;
                aveCount[k][j] = 0;
            }
        }
        int xsize = this.xAxis_.getLength();
        try {
            for (int i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.xDimIndex_] = 0;
            sOrigin[this.yDimIndex_] = this.numRows_ - this.sliceOffset_ - this.sliceRows_;
            sShape[this.xDimIndex_] = this.numCols_;
            sShape[this.yDimIndex_] = this.sliceRows_;
            for (int iave = 0; iave < this.numAves_; iave += this.maxAveSlices_) {
                int aveSlices = iave + this.maxAveSlices_ >= this.numAves_ ? this.numAves_ - iave : this.maxAveSlices_;
                sOrigin[this.aveDimIndex_] = iave;
                sShape[this.aveDimIndex_] = aveSlices;
                this.slice_ = this.read(sOrigin, sShape);
                this.sliceIdx_ = this.slice_.getIndex();
                for (int mm = 0; mm < aveSlices; ++mm) {
                    for (int k = 0; k < this.sliceRows_; ++k) {
                        for (int j = 0; j < xsize; ++j) {
                            double dval = this.getDoubleFromSlice(j, k, mm);
                            if (this.isMissingOrInvalid(dval)) continue;
                            double[] dArray = this.averages_[k];
                            int n = j;
                            dArray[n] = dArray[n] + dval;
                            int[] nArray = aveCount[k];
                            int n2 = j;
                            nArray[n2] = nArray[n2] + 1;
                        }
                    }
                }
                this.slice_ = null;
            }
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(String.format("Do Average: %s", exc.toString()));
        }
        for (int k = 0; k < this.sliceRows_; ++k) {
            for (int j = 0; j < xsize; ++j) {
                if (aveCount[k][j] == 0) {
                    this.averages_[k][j] = Double.NaN;
                    continue;
                }
                if (aveCount[k][j] <= 1) continue;
                double[] dArray = this.averages_[k];
                int n = j;
                dArray[n] = dArray[n] / (double)aveCount[k][j];
            }
        }
        this.needsSlice_ = false;
    }

    public double rowAverageOf(int row) throws NcException {
        double result = 0.0;
        int count = 0;
        for (int i = 0; i < this.numCols_; ++i) {
            double value = this.valueAt(i, row);
            if (Double.isNaN(value)) continue;
            result += value;
            ++count;
        }
        if (count == 0) {
            return Double.NaN;
        }
        if (count == 1) {
            return result;
        }
        return result /= (double)count;
    }

    @Override
    public void setSliceIndex(int dimNum, int index) {
        if (dimNum == this.xDimIndex_) {
            throw new NcException(String.format("Dim num %d is not an independent dimension (X).", dimNum));
        }
        if (dimNum == this.yDimIndex_) {
            throw new NcException(String.format("Dim num %d is not an independent dimension (Y).", dimNum));
        }
        if (dimNum != this.aveDimIndex_ || index == -1) {
            this.averages_ = null;
        }
        super.setSliceIndex(dimNum, index);
    }

    @Override
    protected void findExtremaImpl() {
        double[] range;
        if (this.rank_ < 3 && (range = this.getActualRangeAttrValues()) != null) {
            this.minimum_ = range[0];
            this.maximum_ = range[1];
            this.needsExtrema_ = false;
            return;
        }
        for (int j = 0; j < this.numRows_; ++j) {
            for (int i = 0; i < this.numCols_; ++i) {
                this.findExtremaTestValue(this.valueAt(i, j));
            }
        }
        LOGGER.trace("min {}, max {}", (Object)this.minimum_, (Object)this.maximum_);
    }

    public int[] getEnclosingCell(double colval, double rowval) {
        int incol = this.getXAxis().findNearestIndex(colval);
        int inrow = this.getYAxis().findNearestIndex(rowval);
        if (incol < 0 || inrow < 0) {
            return null;
        }
        return new int[]{incol, inrow};
    }

    static {
        long maxMemGB = Runtime.getRuntime().maxMemory() / 1000L / 1000L / 1000L;
        LOGGER.trace("maxMemGB {}", (Object)maxMemGB);
        if (maxMemGB >= 4L) {
            MAX_ELEMENTS = 36000000;
            CHUNK_ELEMENTS = 32000000;
        } else if (maxMemGB >= 2L) {
            MAX_ELEMENTS = 24000000;
            CHUNK_ELEMENTS = 20000000;
        } else if (maxMemGB >= 1L) {
            MAX_ELEMENTS = 20000000;
            CHUNK_ELEMENTS = 16000000;
        } else {
            MAX_ELEMENTS = 10000000;
            CHUNK_ELEMENTS = 8000000;
        }
    }
}

