/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderTimeLat;
import gov.nasa.giss.text.PrintfFormat;
import java.util.Objects;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.VariableDS;

public class NcArrayTimeLat
extends NcArray2D {
    public NcArrayTimeLat(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.createAxes();
        this.measureAxes();
    }

    @Override
    protected void createAxes() {
        int dindex;
        VariableDS cv;
        NcDataset ncd = this.getDataset();
        CoordinateAxis x = this.getCoordinateAxisOfType(NcAxisType.TIME);
        CoordinateAxis y = this.getCoordinateAxisOfType(NcAxisType.LAT);
        if (x == null) {
            cv = this.getCoordinateVariable(NcAxisType.TIME);
            if (cv != null) {
                this.xAxis_ = new NcTimeAxis(ncd, cv);
                this.xDimIndex_ = this.findDimensionIndex(cv);
            }
        } else {
            this.xAxis_ = new NcTimeAxis(ncd, x);
            this.xDimIndex_ = this.findDimensionIndex(x);
        }
        if (y == null) {
            cv = this.getCoordinateVariable(NcAxisType.LAT);
            if (cv != null) {
                this.yAxis_ = new NcAxis(NcAxisType.LAT, ncd, cv);
                this.yDimIndex_ = this.findDimensionIndex(cv);
            }
        } else {
            this.yAxis_ = new NcAxis(NcAxisType.LAT, ncd, y);
            this.yDimIndex_ = this.findDimensionIndex(y);
        }
        if (this.xAxis_ == null) {
            throw new NcNullException("Found null when retrieving TIME coordinate axis");
        }
        if (this.yAxis_ == null) {
            throw new NcNullException("Found null when retrieving LAT coordinate axis");
        }
        if (this.xDimIndex_ == -1) {
            throw new NcException("Unable to determine dim index for TIME axis");
        }
        if (this.yDimIndex_ == -1) {
            throw new NcException("Unable to determine dim index for LAT axis");
        }
        CoordinateAxis lonaxis = this.getCoordinateAxisOfType(NcAxisType.LON);
        if (lonaxis instanceof CoordinateAxis1D && lonaxis.getRank() == 1 && lonaxis.getShape()[0] > 0 && (dindex = this.findDimensionIndex(lonaxis)) > -1) {
            this.setAveDimIndex(dindex);
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderTimeLat();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (row < 0 || col < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        double time = this.xAxis_.valueAt(col);
        double lat = this.yAxis_.valueAt(row);
        sb.append("Cell [").append(col + 1).append(", ").append(row + 1).append("] at [").append(new PrintfFormat("%.10g").sprintfx(time)).append(", ").append(NcUtils.formatLatitude(lat)).append("], value = ");
        double value = this.valueAt(col, row);
        sb.append(valFormat.sprintfx(value));
        if (Double.isNaN(value)) {
            return;
        }
        String unitsStr = this.getUnitsStr();
        if (unitsStr != null && !unitsStr.isEmpty() && !"1".equals(unitsStr)) {
            sb.append(' ').append(unitsStr);
        }
    }
}

