/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.ui;

import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDatasetList;
import gov.nasa.giss.data.nc.NcVarSorting;
import gov.nasa.giss.data.nc.NcVarVisibility;
import gov.nasa.giss.data.nc.ui.NcDataTreeTableDragGestureListener;
import gov.nasa.giss.data.nc.ui.NcDataTreeTableModel;
import gov.nasa.giss.ui.treetable.SearchableTreeTablePanel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.EventQueue;
import java.awt.dnd.DragSource;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcDataTreeTablePanel
extends SearchableTreeTablePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean expandNewNodes_ = true;

    public NcDataTreeTablePanel() {
        super(new NcDataTreeTableModel());
        NcDataTreeTableDragGestureListener dsa = new NcDataTreeTableDragGestureListener(this.getTreeTable());
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.getTreeTable(), 1, dsa);
    }

    public void setSorting(String sname) {
        NcVarSorting sorting = NcVarSorting.matching(sname);
        NcDataNode.setSorting(sorting);
    }

    public void setExpandNewNodes(boolean expand) {
        this.expandNewNodes_ = expand;
    }

    public void setVisibleVarClass(NcVarVisibility vclass) {
        ((NcDataTreeTableModel)this.getModel()).setVisibleVarClass(vclass);
    }

    public Object[] getDatasets() {
        NcDataTreeTableModel model = (NcDataTreeTableModel)this.getModel();
        return ((NcDatasetList)model.getRoot()).getChildren();
    }

    public int getDatasetCount() {
        return this.getDatasets().length;
    }

    @Override
    public void removeAll() {
        Object[] datasets = this.getDatasets();
        for (Object dataset : this.getDatasets()) {
            this.removeDataset((NcDataNode)dataset);
        }
    }

    public void removeDataset(NcDataNode node) {
        ((NcDataTreeTableModel)this.getModel()).removeDataset(node);
        this.fireItemRemoved(node);
    }

    public NcDataset addDataset(NcDataset ncd) throws IOException {
        LOGGER.trace("dataset {}", (Object)ncd);
        if (ncd == null) {
            return null;
        }
        NcDataTreeTableModel model = (NcDataTreeTableModel)this.getModel();
        NcDataset ncdx = model.addDataset(ncd);
        if (ncdx == ncd && this.expandNewNodes_) {
            TreeTableNode[] nodes;
            this.getTreeTable().expandNode(ncd);
            for (TreeTableNode node : nodes = ncd.getChildren()) {
                this.getTreeTable().expandNode(node);
            }
        }
        EventQueue.invokeLater(() -> {
            this.getTreeTable().setSelectedNode(ncdx);
            this.getTreeTable().makeNodeVisible(ncdx);
            this.fireItemAdded(ncd);
        });
        return ncd;
    }

    @Override
    protected boolean nodeMatches(TreeTableNode node, String sterm) {
        String lcterm = sterm.toLowerCase();
        NcDataNode ncnode = (NcDataNode)node;
        return ncnode.getName().toLowerCase().contains(lcterm) || ncnode.getLongName().toLowerCase().contains(lcterm);
    }
}

