/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Baranyi5
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Baranyi V";
    public static final int PROPERTIES = 8;
    private static final double CY = 1.815538;
    private static final double C1 = 0.5420468017;
    private static final double C3 = 0.2283705107;
    private static final double C5 = -0.1379539116;
    private static final double C7 = 0.0238688655;
    private static final double C9 = 3.349036E-4;
    private static final double THREE_C3 = 0.6851115321;
    private static final double FIVE_C5 = -0.6897695580000001;
    private static final double SEVEN_C7 = 0.1670820585;
    private static final double NINE_C9 = 0.0030141324;
    private static final double B1 = 0.3454927179;
    private static final double B3 = -0.0100793312;
    private static final double B5 = 0.0030188496;
    private static final double B7 = -4.02572E-4;
    private static final double B9 = 1.74169E-5;
    private static final double THREE_B3 = -0.0302379936;
    private static final double FIVE_B5 = 0.015094248;
    private static final double SEVEN_B7 = -0.0028180040000000003;
    private static final double NINE_B9 = 1.567521E-4;
    private static final double B11 = 2.566229;
    private static final double B31 = 1.539647;
    private static final double B12 = 1.833265;
    private static final double B32 = 7.138632;
    private static final double B13 = 3.29617824;
    private static final double JOIN_PHI1 = 77.214915;
    private static final double JOIN_PHI1RAD = Math.toRadians(77.214915);
    private static final double JOIN_PHI2 = 89.138488;
    private static final double JOIN_PHI2RAD = Math.toRadians(89.138488);
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.815538;

    public Baranyi5(int width, int height) {
        this(width, height, 0, 0);
    }

    public Baranyi5(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.815538);
        this.finishConstruction();
        LOGGER.trace("fPhi(pi/2) {}", (Object)Baranyi5.getFPhi(1.5707963267948966));
        LOGGER.trace("lLambda(pl) {}", (Object)Baranyi5.getLLambda(Math.PI));
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double absPhiRad = Math.abs(Math.toRadians(lat));
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        double y = 1.815538 * Baranyi5.getFPhi(absPhiRad);
        double x = 0.0;
        double lLambda = Baranyi5.getLLambda(absLambdaRad);
        x = absPhiRad < JOIN_PHI1RAD ? lLambda * (Math.sqrt(2.566229 - y * y) + 1.539647) : (absPhiRad < JOIN_PHI2RAD ? lLambda * (1.833265 - y) * 7.138632 : lLambda * Math.sqrt(3.29617824 - y * y));
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double phiRad = this.iteratePhiRad(absYOverRS);
        double lLambda = phiRad < JOIN_PHI1RAD ? absXOverRS / (Math.sqrt(2.566229 - absYOverRS * absYOverRS) + 1.539647) : (phiRad < JOIN_PHI2RAD ? absXOverRS / ((1.833265 - absYOverRS) * 7.138632) : absXOverRS / Math.sqrt(3.29617824 - absYOverRS * absYOverRS));
        double lambdaRad = this.iterateLambdaRad(lLambda, absXOverRS);
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = y < 0.0 ? -Math.toDegrees(phiRad) : Math.toDegrees(phiRad);
        double lambda = x < 0.0 ? -Math.toDegrees(lambdaRad) : Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Baranyi5 baranyi5 = this;
        synchronized (baranyi5) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double phiRad = this.iteratePhiRad(yOverRS);
                double phiTerm = phiRad < JOIN_PHI1RAD ? 1.0 / (Math.sqrt(2.566229 - yOverRS * yOverRS) + 1.539647) : (phiRad < JOIN_PHI2RAD ? 1.0 / ((1.833265 - yOverRS) * 7.138632) : 1.0 / Math.sqrt(3.29617824 - yOverRS * yOverRS));
                for (int ix = 0; ix < this.dxMax_ && !((x = (double)ix + 0.5) > (double)this.dxMax_); ++ix) {
                    double xOverRS = x * this.invRS_;
                    double lLambda = xOverRS * phiTerm;
                    double lambdaRad = this.iterateLambdaRad(lLambda, xOverRS);
                    if (Double.isNaN(lambdaRad)) {
                        LOGGER.trace("Got NaN lambda for x {}, dxMax_ {}", (Object)x, (Object)this.dxMax_);
                        continue block3;
                    }
                    if (lambdaRad > Math.PI) continue block3;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private static double getFPhi(double phiRad) {
        double phiRad2 = phiRad * phiRad;
        return phiRad * (0.5420468017 + phiRad2 * (0.2283705107 + phiRad2 * (-0.1379539116 + phiRad2 * (0.0238688655 + phiRad2 * 3.349036E-4))));
    }

    private static double getLLambda(double lambdaRad) {
        double lambdaRad2 = lambdaRad * lambdaRad;
        return lambdaRad * (0.3454927179 + lambdaRad2 * (-0.0100793312 + lambdaRad2 * (0.0030188496 + lambdaRad2 * (-4.02572E-4 + lambdaRad2 * 1.74169E-5))));
    }

    private double iteratePhiRad(double yOverRS) {
        double phiRad = 1.5707963267948966 * yOverRS / 1.815538;
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double func = 1.815538 * Baranyi5.getFPhi(phiRad) - yOverRS;
            double dfunc = 1.815538 * (0.5420468017 + phiRad2 * (0.6851115321 + phiRad2 * (-0.6897695580000001 + phiRad2 * (0.1670820585 + 0.0030141324 * phiRad2))));
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return phiRad;
    }

    private double iterateLambdaRad(double lLambda, double xOverRS) {
        double lambdaRad = xOverRS * Math.PI / Math.PI;
        for (int iter = 0; iter < 33; ++iter) {
            double lambdaRad2 = lambdaRad * lambdaRad;
            double func = Baranyi5.getLLambda(lambdaRad) - lLambda;
            double dfunc = 0.3454927179 + lambdaRad2 * (-0.0302379936 + lambdaRad2 * (0.015094248 + lambdaRad2 * (-0.0028180040000000003 + 1.567521E-4 * lambdaRad2)));
            double dlambdaRad = -func / dfunc;
            lambdaRad += dlambdaRad;
            if (Math.abs(dlambdaRad) < 1.0E-5) break;
        }
        return lambdaRad;
    }
}

