/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BonneRegional
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Bonne Regional";
    public static final int PROPERTIES = 8704;
    private static final double DEFAULT_PHI1 = 50.0;
    private static final double MAX_X_OVER_RS = Math.PI * 2;
    private static final double MAX_Y_OVER_RS = Math.PI;
    private double phi1_ = 50.0;
    private double phi1Rad_;
    private double cotPhi1_;
    private double yshift_;
    private double outCenterYShift_;
    private static final double DEFAULT_HEIGHT = 45.0;
    private double phiHeight_ = 45.0;
    private double minPhiStep_ = 0.05;
    private final ProjDoubleParameter phi1Param_ = new ProjDoubleParameter("Latitude of standard parallel", "Std. Parallel", "\u00b0N", 50.0, -90.0, 90.0, true, true);
    private final ProjDoubleParameter hgtParam_ = new ProjDoubleParameter("Angular distance between top and bottom center", "Ctr. Height", "\u00b0", 45.0, 1.0, 180.0, true, true);

    public BonneRegional(int width, int height) {
        this(width, height, 0, 0);
    }

    public BonneRegional(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8704, width, height, xmargin, ymargin, Math.PI * 2, Math.PI);
        this.addParameter(this.phi1Param_);
        this.addParameter(this.hgtParam_);
        this.finishConstruction();
    }

    public ProjDoubleParameter getHeightParameter() {
        return this.hgtParam_;
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.autoscale();
    }

    @Override
    public boolean isRecenterableLat() {
        return true;
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setStandardParallel(this.phi1Param_.getValue());
            this.setHeight(this.hgtParam_.getValue());
        } else if (p.equals(this.phi1Param_)) {
            this.setStandardParallel(this.phi1Param_.getValue());
        } else if (p.equals(this.hgtParam_)) {
            this.setHeight(this.hgtParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setStandardParallel(double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude outside valid range");
        }
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Lat must be in range [-90,90].");
        }
        this.phi1_ = lat;
        if (this.phi1_ == 0.0) {
            this.phi1_ = 1.0E-10;
        }
        this.phi1Rad_ = Math.toRadians(this.phi1_);
        this.cotPhi1_ = 1.0 / Math.tan(this.phi1Rad_);
        this.autoscale();
    }

    private void setHeight(double h) {
        this.phiHeight_ = h;
        this.minPhiStep_ = 5.0E-5 * h;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double heightFactor = 0.5 * Math.toRadians(this.phiHeight_);
        this.setMaxXYOverRS(0.0, heightFactor);
    }

    @Override
    protected final void finishScaling() {
        double dphi = this.phiC_ - this.phi1_;
        this.yshift_ = -Math.toRadians(dphi);
        this.outCenterYShift_ = (double)this.outCenterY_ - this.yshift_ * this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad = Math.toRadians(lat);
        double alphaRad = this.cotPhi1_ + this.phi1Rad_ - phiRad;
        if (Math.abs(alphaRad) < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, this.outCenterYShift_);
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double betaRad = lambdaRad * Math.cos(phiRad) / alphaRad;
        double x = alphaRad * Math.sin(betaRad);
        double y = this.cotPhi1_ - alphaRad * Math.cos(betaRad) + this.yshift_;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double yOverRS;
        double y1;
        double xOverRS;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double pmFac = this.phi1_ < 0.0 ? -1.0 : 1.0;
        double alphaRad = pmFac * Math.hypot(xOverRS = x * this.invRS_, y1 = this.cotPhi1_ - (yOverRS = y * this.invRS_ - this.yshift_));
        double phiRad = this.cotPhi1_ + this.phi1Rad_ - alphaRad;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double betaRad = Math.atan2(pmFac * xOverRS, pmFac * y1);
        double lambdaRad = betaRad * alphaRad / Math.cos(phiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        BonneRegional bonneRegional = this;
        synchronized (bonneRegional) {
            double pmFac = this.phi1_ < 0.0 ? -1.0 : 1.0;
            block3: for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_ - this.yshift_;
                double y1 = this.cotPhi1_ - yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double alphaRad = pmFac * Math.hypot(xOverRS, y1);
                    double phiRad = this.cotPhi1_ + this.phi1Rad_ - alphaRad;
                    if (Math.abs(phiRad) > 1.5707963267948966) continue;
                    double betaRad = Math.atan2(pmFac * xOverRS, pmFac * y1);
                    double lambdaRad = betaRad * alphaRad / Math.cos(phiRad);
                    if (lambdaRad > Math.PI) {
                        if (!(Math.abs(this.phi1_) < 11.5232593818)) continue;
                        continue block3;
                    }
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        int i;
        ArrayList<Bezier> bcurves = this.makeMeridianBezier(this.lambdaC_ - 179.99999, 90.0);
        for (i = 0; i < bcurves.size(); ++i) {
            bcurves.get(i).draw(g2d);
        }
        bcurves = null;
        bcurves = this.makeMeridianBezier(this.lambdaC_ + 179.99999, 90.0);
        for (i = 0; i < bcurves.size(); ++i) {
            Bezier bb = bcurves.get(i);
            bb.draw(g2d);
        }
        if (Math.abs(this.phi1_) < 1.0E-5 && Math.abs(this.phiC_) < 1.0E-5 && Math.abs(this.phiHeight_ - 180.0) < 1.0E-5) {
            return;
        }
        Rectangle2D.Double marginRect = this.getMarginRect0();
        double lMargin = marginRect.x;
        double tMargin = marginRect.y;
        double rMargin = marginRect.x + marginRect.width;
        double bMargin = marginRect.y + marginRect.height;
        if (bcurves == null || bcurves.size() == 0) {
            ProjGraphicUtils.drawRectBorder(g2d, lMargin, tMargin, marginRect.width, marginRect.height);
            return;
        }
        Point2D.Double firstBezPt = bcurves.get(0).getAnchors()[0];
        boolean firstBezAtSP = Math.abs(firstBezPt.x - (double)this.outCenterX_) < 1.0E-5;
        Point2D.Double lastPt = new Point2D.Double(this.outCenterX_, bMargin);
        for (int i2 = 0; !(i2 > bcurves.size() || i2 > 0 && Math.abs(lastPt.x - (double)this.outCenterX_) < 1.0E-5); ++i2) {
            boolean endOnT;
            Point2D.Double pt2;
            Bezier bb = i2 < bcurves.size() ? bcurves.get(i2) : null;
            Point2D.Double pt1 = lastPt;
            Point2D.Double double_ = pt2 = bb != null ? bb.getAnchors()[0] : new Point2D.Double(this.outCenterX_, tMargin);
            if (firstBezAtSP && i2 == 0) {
                Point2D.Double[] aa = bb.getAnchors();
                lastPt = aa[aa.length - 1];
                continue;
            }
            boolean startOnB = Math.abs(pt1.y - bMargin) < 0.6;
            boolean startOnR = Math.abs(pt1.x - rMargin) < 0.6;
            boolean startOnT = Math.abs(pt1.y - tMargin) < 0.6;
            boolean endOnB = Math.abs(pt2.y - bMargin) < 0.6;
            boolean endOnR = Math.abs(pt2.x - rMargin) < 0.6;
            boolean bl = endOnT = Math.abs(pt2.y - tMargin) < 0.6;
            if (startOnB && endOnB) {
                GraphicUtils.drawLine(g2d, pt1.x, bMargin, pt2.x, bMargin);
                GraphicUtils.drawLine(g2d, 2.0 * (double)this.outCenterX_ - pt1.x, bMargin, 2.0 * (double)this.outCenterX_ - pt2.x, bMargin);
            } else if (startOnB && endOnR) {
                GraphicUtils.drawLine(g2d, pt1.x, bMargin, rMargin, bMargin);
                GraphicUtils.drawLine(g2d, 2.0 * (double)this.outCenterX_ - pt1.x, bMargin, lMargin, bMargin);
                GraphicUtils.drawLine(g2d, rMargin, bMargin, rMargin, pt2.y);
                GraphicUtils.drawLine(g2d, lMargin, bMargin, lMargin, pt2.y);
            } else if (startOnB && endOnT) {
                GraphicUtils.drawLine(g2d, pt1.x, bMargin, rMargin, bMargin);
                GraphicUtils.drawLine(g2d, 2.0 * (double)this.outCenterX_ - pt1.x, bMargin, lMargin, bMargin);
                GraphicUtils.drawLine(g2d, rMargin, bMargin, rMargin, tMargin);
                GraphicUtils.drawLine(g2d, lMargin, bMargin, lMargin, tMargin);
                GraphicUtils.drawLine(g2d, rMargin, tMargin, pt2.x, tMargin);
                GraphicUtils.drawLine(g2d, lMargin, tMargin, 2.0 * (double)this.outCenterX_ - pt2.x, tMargin);
            } else if (startOnR && endOnR) {
                GraphicUtils.drawLine(g2d, rMargin, pt1.y, rMargin, pt2.y);
                GraphicUtils.drawLine(g2d, lMargin, pt1.y, lMargin, pt2.y);
            } else if (startOnR && endOnT) {
                GraphicUtils.drawLine(g2d, rMargin, pt1.y, rMargin, tMargin);
                GraphicUtils.drawLine(g2d, lMargin, pt1.y, lMargin, tMargin);
                GraphicUtils.drawLine(g2d, rMargin, tMargin, pt2.x, tMargin);
                GraphicUtils.drawLine(g2d, lMargin, tMargin, 2.0 * (double)this.outCenterX_ - pt2.x, tMargin);
            } else if (startOnT && endOnT) {
                GraphicUtils.drawLine(g2d, pt1.x, tMargin, pt2.x, tMargin);
                GraphicUtils.drawLine(g2d, 2.0 * (double)this.outCenterX_ - pt1.x, tMargin, 2.0 * (double)this.outCenterX_ - pt2.x, tMargin);
            }
            if (bb == null) continue;
            Point2D.Double[] aa = bb.getAnchors();
            lastPt = aa[aa.length - 1];
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double lon1 = this.lambdaC_ - 179.99999;
        double lon2 = this.lambdaC_;
        double lon3 = this.lambdaC_ + 179.99999;
        if (Math.abs(this.phi1_) < 1.0E-5) {
            Point2D.Double dot2 = this.transformLL2XYIgnoreMargins(lon2, lat);
            if (!this.isWithinMargins(dot2)) {
                return;
            }
            if (Math.abs((double)(this.outCenterY_ - this.dyMax_) - dot2.y) < 0.5 || Math.abs((double)(this.outCenterY_ + this.dyMax_) - dot2.y) < 0.5) {
                return;
            }
            Point2D.Double dot1 = this.transformLL2XYIgnoreMargins(lon1, lat);
            Point2D.Double dot3 = this.transformLL2XYIgnoreMargins(lon3, lat);
            ProjGraphicUtils.drawCroppedLine(g2d, this, dot1, dot3);
            return;
        }
        Point2D.Double dot1 = this.transformLL2XYIgnoreMargins(lon1, lat);
        Point2D.Double dot2 = this.transformLL2XYIgnoreMargins(lon2, lat);
        Point2D.Double dot3 = this.transformLL2XYIgnoreMargins(lon3, lat);
        ProjGraphicUtils.drawCroppedCircularArc(g2d, this, dot1, dot2, dot3);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double dlon = MapUtils.normalize360(lon - this.lambdaC_);
        if (dlon < 1.0E-5 || Math.abs(dlon - 360.0) < 1.0E-5) {
            Point2D.Double dot1 = this.transformLL2XYIgnoreMargins(this.lambdaC_, maxLat);
            Point2D.Double dot2 = this.transformLL2XYIgnoreMargins(this.lambdaC_, -maxLat);
            ProjGraphicUtils.drawCroppedLine(g2d, this, dot1, dot2);
            return;
        }
        if (Math.abs(dlon - 180.0) < 1.0E-5) {
            return;
        }
        ArrayList<Bezier> bcurves = this.makeMeridianBezier(lon, maxLat);
        for (int i = 0; i < bcurves.size(); ++i) {
            bcurves.get(i).draw(g2d);
        }
    }

    private ArrayList<Bezier> makeMeridianBezier(double lon, double maxLat) {
        ArrayList<Bezier> result = new ArrayList<Bezier>(3);
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(240);
        double lastlat = -maxLat;
        boolean lastgood = false;
        boolean done = false;
        double lat = -maxLat;
        while (!done) {
            Point2D.Double dot;
            if (lat > maxLat) {
                lat = maxLat;
            }
            if ((dot = this.transformLL2XY(lon, lat)) == null) {
                if (lastgood) {
                    if (lat - lastlat > this.minPhiStep_) {
                        lat = 0.5 * (lastlat + lat);
                        continue;
                    }
                    if (ptlist.size() > 1) {
                        result.add(new Bezier(false, ptlist));
                        ptlist.clear();
                    }
                }
                lastgood = false;
            } else if (!lastgood) {
                if (lat - lastlat > this.minPhiStep_) {
                    lat = 0.5 * (lastlat + lat);
                    continue;
                }
                ptlist.add(new Point2D.Double(dot.x, dot.y));
                lastgood = true;
            } else {
                ptlist.add(new Point2D.Double(dot.x, dot.y));
                lastgood = true;
            }
            if (lat >= maxLat || lat > 89.99999) {
                done = true;
                continue;
            }
            lastlat = lat;
            double absLat = Math.abs(lat);
            if (absLat >= maxLat - 1.0) {
                lat += 0.05;
                continue;
            }
            if (absLat >= 85.0) {
                lat += 0.1;
                continue;
            }
            lat += 0.2;
        }
        if (ptlist.size() > 1) {
            result.add(new Bezier(false, ptlist));
        }
        return result;
    }
}

