/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GeneralEquidistantConic;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Euler
extends GeneralEquidistantConic {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Euler";

    public Euler(int width, int height) {
        this(width, height, 0, 0);
    }

    public Euler(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200010, width, height, xmargin, ymargin);
        this.finishConstruction();
    }

    @Override
    protected void calculateParams() {
        if (this.phi1_ == this.phi2_ && this.phi1_ == 0.0) {
            this.phi1_ += 1.0E-5;
        }
        if (this.phi1_ == this.phi2_) {
            double phi0Rad = Math.toRadians(this.phi1_);
            this.termN_ = Math.sin(phi0Rad);
            this.termF_ = 1.0 / Math.tan(phi0Rad) + phi0Rad;
        } else {
            double phi0Rad = 0.5 * Math.toRadians(this.phi1_ + this.phi2_);
            double deltaRad = 0.5 * Math.toRadians(Math.abs(this.phi1_ - this.phi2_));
            this.termN_ = Math.sin(phi0Rad) * Math.sin(deltaRad) / deltaRad;
            this.termF_ = 0.5 * deltaRad / (Math.tan(0.5 * deltaRad) * Math.tan(phi0Rad)) + phi0Rad;
        }
        this.invN_ = 1.0 / this.termN_;
        this.rhoC_ = this.termF_ - this.phiCRad_;
        LOGGER.trace("F {}, n {}, rhoC {}", this.termF_, this.termN_, this.rhoC_);
    }
}

