/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.QuadEllipseProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class Hammer
extends QuadEllipseProjection {
    public static final String PROJECTION_NAME = "Hammer";
    public static final int PROPERTIES = 8224;
    private static final double MAX_X_OVER_RS = 2.8284271247461903;
    private static final double MAX_Y_OVER_RS = 1.4142135623730951;
    private double inv2RS_;

    public Hammer(int width, int height) {
        this(width, height, 0, 0);
    }

    public Hammer(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8224, width, height, xmargin, ymargin, 2.8284271247461903, 1.4142135623730951);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.inv2RS_ = 0.5 * this.invRS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double halfLambdaRad = 0.5 * this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double cosBeta = cosPhi * Math.cos(halfLambdaRad);
        double betaTerm = Math.sqrt(0.5 * (1.0 + cosBeta));
        if (betaTerm < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double sinPhi = Math.sin(phiRad);
        double invBetaTerm = 1.0 / betaTerm;
        double x = 2.0 * cosPhi * Math.sin(halfLambdaRad) * invBetaTerm;
        double y = sinPhi * invBetaTerm;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return new PointLL(this.lambdaC_, 0.0);
        }
        double rhoFac = Math.hypot(0.5 * x, y) * this.invRS_;
        if (rhoFac > 1.4142135623730951) {
            return null;
        }
        double sinHalfBeta = 0.5 * rhoFac;
        double halfBetaRad = Math.asin(sinHalfBeta);
        double cosHalfBeta = Math.cos(halfBetaRad);
        double phiRad = Math.asin(y * cosHalfBeta * this.invRS_);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double cosBeta = Math.cos(2.0 * halfBetaRad);
        double d = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.atan2(x * cosHalfBeta * this.inv2RS_, cosBeta);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Hammer hammer = this;
        synchronized (hammer) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double sinHalfBeta;
                double halfBetaRad;
                double cosHalfBeta;
                double phiRad;
                double x;
                double rhoFac;
                double y = (double)iy + 0.5;
                for (int ix = 0; ix < this.dxMax_ && !((rhoFac = Math.hypot(0.5 * (x = (double)ix + 0.5), y) * this.invRS_) > 1.4142135623730951) && !((phiRad = Math.asin(y * (cosHalfBeta = Math.cos(halfBetaRad = Math.asin(sinHalfBeta = this.inv2RS_ * Math.hypot(0.5 * x, y)))) * this.invRS_)) > 1.5707963267948966); ++ix) {
                    double lambdaRad;
                    double cosBeta = Math.cos(2.0 * halfBetaRad);
                    double d = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.atan2(x * cosHalfBeta * this.inv2RS_, cosBeta);
                    if (lambdaRad > Math.PI) continue block3;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }
}

