/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PointPoleProjection
extends QuadSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PointPoleProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda > 179.99999) {
            return;
        }
        super.drawMeridian(g2d, lon, maxLat, label);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier[] curves = this.makeOuterBeziers();
        if (curves != null) {
            if (curves[0] != null) {
                curves[0].draw(g2d);
            }
            if (curves[1] != null) {
                curves[1].draw(g2d);
            }
        }
    }

    protected Bezier[] makeOuterBeziers() {
        double edgeLon = this.lambdaC_ + 179.99999;
        int np = 185;
        double fact = 0.4864864864864865;
        Point2D.Double[] dotsE = new Point2D.Double[371];
        Point2D.Double[] dotsW = new Point2D.Double[371];
        for (int j = 0; j <= 185; ++j) {
            double jj = 0.4864864864864865 * (double)j;
            Point2D.Double dot = this.transformLL2XY(edgeLon, jj);
            if (dot == null) {
                LOGGER.warn("Null outer border point");
                return null;
            }
            dotsE[185 - j] = new Point2D.Double(dot.x, dot.y);
            dotsE[185 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dotsW[185 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dotsW[185 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        return new Bezier[]{new Bezier(false, dotsE), new Bezier(false, dotsW)};
    }
}

