/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class Wagner5
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Wagner V";
    private static final double CONST_M2 = 0.8855017059;
    private static final double INV_M2 = 1.12930330154884;
    private static final double CSUBX = 0.9097725088;
    private static final double CSUBY = 1.6501447981;
    private static final double CSUBP = 3.0089552244;
    private static final double INV_CSUBX = 1.0991758822422664;
    private static final double INV_CSUBY = 0.6060074250159223;
    private static final double INV_CSUBP = 0.3323412697839014;
    private static final double MAX_X_OVER_RS = 2.8581346300840353;
    private static final double MAX_Y_OVER_RS = 1.6501447981 * Math.sin(Math.toRadians(60.0));

    public Wagner5(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner5(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.8581346300840353, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiFactor = 3.0089552244 * Math.sin(0.8855017059 * Math.toRadians(lat));
        double psiRad = Math.toRadians(lat);
        for (int iter = 0; iter < 33; ++iter) {
            double twoPsiRad = 2.0 * psiRad;
            double func = twoPsiRad + Math.sin(twoPsiRad) - phiFactor;
            double dfunc = 2.0 + 2.0 * Math.cos(psiRad);
            double dpsiRad = -func / dfunc;
            psiRad += dpsiRad;
            if (Math.abs(dpsiRad) < 1.0E-5) break;
        }
        double x = 0.9097725088 * this.lonToLambdaRad(lon) * Math.cos(psiRad);
        double y = 1.6501447981 * Math.sin(psiRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double psiRad = Math.asin(y * this.invRS_ * 0.6060074250159223);
        double twoPsiRad = 2.0 * psiRad;
        double phiRad = Math.asin((twoPsiRad + Math.sin(twoPsiRad)) * 0.3323412697839014) * 1.12930330154884;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invRS_ * 1.0991758822422664 / Math.cos(psiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wagner5 wagner5 = this;
        synchronized (wagner5) {
            double y;
            double psiRad;
            double twoPsiRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin(((twoPsiRad = 2.0 * (psiRad = Math.asin((y = (double)iy + 0.5) * this.invRS_ * 0.6060074250159223))) + Math.sin(twoPsiRad)) * 0.3323412697839014) * 1.12930330154884) > 1.5707963267948966); ++iy) {
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ * 1.0991758822422664 / Math.cos(psiRad);
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lambdaRad = x * xFactor;
                    if (lambdaRad > Math.PI) continue;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        double lambda = this.lonToLambda(lon);
        double absLambda = Math.abs(lambda);
        if (absLambda > 179.99999) {
            return;
        }
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        if (absLambda < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
        } else {
            double lambdaRad = Math.toRadians(lambda);
            double absLambdaRad = Math.toRadians(absLambda);
            Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
            double rectW = 1.8195450176 * absLambdaRad * this.rS_;
            double rectX = lambdaRad < 0.0 ? dotEq.x : dotEq.x - rectW;
            double rectH = 3.3002895962 * this.rS_;
            double rectY = (double)this.outCenterY_ - 1.6501447981 * this.rS_;
            if (lambdaRad > 0.0) {
                GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotS, dotN);
            } else {
                GraphicUtils.drawEllipticArc(g2d, rectX, rectY, rectW, rectH, dotN, dotS);
            }
        }
    }
}

