/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.panoply.cl.PCLFactory;
import gov.nasa.giss.panoply.log.PanLoggingGroup;
import gov.nasa.giss.panoply.log.PanLoggingUtils;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanCLOptionKey;
import gov.nasa.giss.panoply.util.PanNcUtils;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.util.reslist.ResourceList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class PanoplyCL {
    private static final Marker FATAL = MarkerFactory.getMarker("FATAL");
    private static final String DEFAULT_SCRIPT_ENGINE_NAME = "JavaScript";

    public static void main(String ... args) {
        System.setProperty("java.awt.headless", Boolean.toString(true));
        PanLoggingUtils.initLogging(false);
        new PanoplyCL(args);
    }

    PanoplyCL(String ... args) {
        PanLoggingUtils.initLogging(false);
        PanUtils.printIdentity();
        PanUtils.initMiscProperties();
        Hashtable<PanCLOptionKey, Object> opts = PanoplyCL.parseCommandLineOptions(args);
        this.processCommandLineOptions(opts);
        this.initPrefs();
        boolean isServer = opts.containsKey((Object)PanCLOptionKey.SERVER) && (Boolean)opts.get((Object)PanCLOptionKey.SERVER) != false;
        Hashtable<PanNcUtils.Key, Object> initHash = new Hashtable<PanNcUtils.Key, Object>();
        initHash.put(PanNcUtils.Key.DEVO_MODE, PanUtils.isDevo());
        initHash.put(PanNcUtils.Key.SERVER_MODE, isServer);
        initHash.put(PanNcUtils.Key.HEADLESS, true);
        if (opts.containsKey((Object)PanCLOptionKey.GRIB_MODE)) {
            boolean lenient = "lenient".equalsIgnoreCase((String)opts.get((Object)PanCLOptionKey.GRIB_MODE));
            initHash.put(PanNcUtils.Key.GRIB1_STRICT, !lenient);
        }
        PanNcUtils.initNetcdf(initHash);
        ScriptEngine engine = this.initScriptEngine(opts);
        PCLFactory factory = PCLFactory.getSharedInstance();
        engine.put("panoply", factory);
        PanoplyCL.evaluateScript(engine, opts);
        PanoplyCL.quit();
    }

    private static Hashtable<PanCLOptionKey, Object> parseCommandLineOptions(String ... args) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        boolean optionsAllowed = true;
        boolean logLevelSet = false;
        Hashtable<PanCLOptionKey, Object> opts = new Hashtable<PanCLOptionKey, Object>(20);
        for (int i = 0; i < args.length; ++i) {
            if (optionsAllowed && args[i].charAt(0) == '-') {
                String optkey;
                if ("--".equals(args[i])) {
                    optionsAllowed = false;
                    continue;
                }
                switch (optkey = args[i].substring(1).toLowerCase()) {
                    case "gui": {
                        logger.info("-gui flag set.");
                        opts.put(PanCLOptionKey.GUI, true);
                        break;
                    }
                    case "log": {
                        if (++i >= args.length || args[i].charAt(0) == '-') {
                            logger.error(FATAL, "No value provided for log level.");
                            System.exit(1);
                        }
                        if (logLevelSet) {
                            logger.info("LogLevel previously reset by CL option");
                            break;
                        }
                        PanLoggingUtils.setLogLevel(PanLoggingGroup.PANOPLY, args[i]);
                        logLevelSet = true;
                        break;
                    }
                    case "v": {
                        if (logLevelSet) {
                            logger.info("LogLevel already reset");
                            break;
                        }
                        PanLoggingUtils.setLogLevel(PanLoggingGroup.PANOPLY, "FINE");
                        logLevelSet = true;
                        break;
                    }
                    case "vv": {
                        if (logLevelSet) {
                            logger.info("LogLevel already reset");
                            break;
                        }
                        PanLoggingUtils.setLogLevel(PanLoggingGroup.PANOPLY, "FINER");
                        logLevelSet = true;
                        break;
                    }
                    case "vvv": {
                        if (logLevelSet) {
                            logger.info("LogLevel already reset");
                            break;
                        }
                        PanLoggingUtils.setLogLevel(PanLoggingGroup.PANOPLY, "FINEST");
                        logLevelSet = true;
                        break;
                    }
                    case "engine": {
                        if (opts.containsKey((Object)PanCLOptionKey.ENGINE_NAME)) {
                            logger.error(FATAL, "Script engine name cannot be set twice.");
                            System.exit(1);
                        }
                        if (++i >= args.length || args[i].charAt(0) == '-') {
                            logger.error(FATAL, "No value provided for -engine option.");
                            System.exit(1);
                        }
                        opts.put(PanCLOptionKey.ENGINE_NAME, args[i]);
                        break;
                    }
                    case "enginepath": {
                        if (++i >= args.length || args[i].charAt(0) == '-') {
                            logger.error(FATAL, "No value provided for -enginepath option.");
                            System.exit(1);
                        }
                        opts.put(PanCLOptionKey.ENGINE_PATH, args[i]);
                        break;
                    }
                    case "enginelist": {
                        opts.put(PanCLOptionKey.ENGINE_LIST, true);
                        break;
                    }
                    case "script": {
                        if (opts.containsKey((Object)PanCLOptionKey.SCRIPT_PATH)) {
                            logger.error(FATAL, "Script name cannot be set twice.");
                            System.exit(1);
                        }
                        if (++i >= args.length || args[i].charAt(0) == '-') {
                            logger.error(FATAL, "No value provided for -script option");
                            System.exit(1);
                        }
                        opts.put(PanCLOptionKey.SCRIPT_PATH, args[i]);
                        break;
                    }
                    case "server": {
                        logger.info("-server flag set.");
                        opts.put(PanCLOptionKey.SERVER, true);
                        break;
                    }
                    case "grib": {
                        opts.put(PanCLOptionKey.GRIB_MODE, true);
                        if (++i >= args.length || args[i].charAt(0) == '-') {
                            logger.error(FATAL, "No value provided for -grib option");
                            System.exit(1);
                        }
                        opts.put(PanCLOptionKey.GRIB_MODE, args[i]);
                        break;
                    }
                    case "NSDocumentRevisionsDebugMode": {
                        logger.trace("Encountered macOS -NSDocumentRevisionsDebugMode; ignoring it.");
                        ++i;
                        break;
                    }
                    default: {
                        logger.error("Unknown option -{}.", (Object)optkey);
                        System.exit(1);
                        break;
                    }
                }
                continue;
            }
            if (opts.containsKey((Object)PanCLOptionKey.SCRIPT_PATH)) {
                logger.warn("Apparently more than one script specified.");
                logger.warn("Ignoring all but the first.");
                continue;
            }
            opts.put(PanCLOptionKey.SCRIPT_PATH, args[i]);
        }
        if (!opts.containsKey((Object)PanCLOptionKey.GUI)) {
            opts.put(PanCLOptionKey.GUI, false);
        }
        return opts;
    }

    private void processCommandLineOptions(Hashtable<PanCLOptionKey, Object> options) {
        String mode;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        if (options.containsKey((Object)PanCLOptionKey.SERVER) && options.containsKey((Object)PanCLOptionKey.GUI)) {
            Boolean isServer = (Boolean)options.get((Object)PanCLOptionKey.SERVER);
            Boolean isGui = (Boolean)options.get((Object)PanCLOptionKey.GUI);
            if (isServer.booleanValue() && isGui.booleanValue()) {
                logger.warn("Setting -server and -gui flags both true is contradictory.");
                logger.warn("I am re-setting the -gui flag to false.");
                options.put(PanCLOptionKey.GUI, false);
            }
        }
        if (options.containsKey((Object)PanCLOptionKey.GRIB_MODE) && !"lenient".equalsIgnoreCase(mode = (String)options.get((Object)PanCLOptionKey.GRIB_MODE)) && !"strict".equalsIgnoreCase(mode)) {
            logger.warn("Unknown value specified for grib option. Using 'strict' instead.");
            options.put(PanCLOptionKey.GRIB_MODE, "strict");
        }
        if (options.containsKey((Object)PanCLOptionKey.SERVER) && ((Boolean)options.get((Object)PanCLOptionKey.SERVER)).booleanValue()) {
            logger.info("Running in server mode...");
            logger.info("  If working with GRIB data, index files will be written to same directory as data.");
            logger.info("  This may cause errors if the process does not have write access to disk.");
            PanPreferences.disablePreferencesFile();
            logger.info("  Prefs file usage has been disabled.");
            ResourceList.disableAppSupportDirectory();
            logger.info("  Colorbar and overlay support directory usage has been disabled.");
            logger.trace("  Pre-initializating graphics... ");
            GraphicUtils.preInitializeGraphics();
        }
        if (options.containsKey((Object)PanCLOptionKey.GUI) && ((Boolean)options.get((Object)PanCLOptionKey.GUI)).booleanValue()) {
            System.setProperty("java.awt.headless", Boolean.toString(false));
        }
    }

    private void initPrefs() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        prefs.setBoolean("beta:numberlays", false);
    }

    private ScriptEngine initScriptEngine(Hashtable<PanCLOptionKey, Object> options) {
        ScriptEngine engine;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        String epath = null;
        String ename = null;
        if (options.containsKey((Object)PanCLOptionKey.ENGINE_PATH)) {
            epath = (String)options.get((Object)PanCLOptionKey.ENGINE_PATH);
        }
        ename = options.containsKey((Object)PanCLOptionKey.ENGINE_NAME) ? (String)options.get((Object)PanCLOptionKey.ENGINE_NAME) : DEFAULT_SCRIPT_ENGINE_NAME;
        ScriptEngineManager sem = null;
        if (epath != null) {
            logger.trace("Attempting to create class-loader for {}", (Object)epath);
            try {
                File file = new File(".", epath);
                URL url = file.toURI().toURL();
                URLClassLoader classLoader = new URLClassLoader(new URL[]{url});
                logger.trace("Attempting to create script engine manager for {}", (Object)classLoader);
                sem = new ScriptEngineManager(classLoader);
                logger.trace(". Got {}", (Object)sem);
            }
            catch (Exception exc) {
                logger.error(FATAL, "Failed creating script engine manager: {}", (Object)exc.toString());
                if (logger.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                System.exit(1);
            }
        }
        if (sem == null) {
            sem = new ScriptEngineManager();
        }
        if (options.containsKey((Object)PanCLOptionKey.ENGINE_LIST)) {
            PanoplyCL.printEngineList(sem);
            System.exit(0);
        }
        if ((engine = sem.getEngineByName(ename)) == null) {
            logger.error(FATAL, "ScriptEngineManager found no engine for '{}'", (Object)ename);
            System.exit(1);
        }
        logger.trace("Found engine {}", (Object)engine.getClass());
        return engine;
    }

    private static void printEngineList(ScriptEngineManager sem) {
        List<ScriptEngineFactory> factories;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        if (sem == null) {
            logger.error("ScriptEngineManager cannot be null");
            System.exit(1);
        }
        if ((factories = sem.getEngineFactories()).size() == 0) {
            System.err.println("There are no script engines available.");
            System.exit(1);
        }
        System.err.println("Scripting engines available include:");
        for (ScriptEngineFactory sef : sem.getEngineFactories()) {
            System.err.printf("Engine %s, Language %s%n", sef.getEngineName(), sef.getLanguageName());
            for (String sname : sef.getNames()) {
                System.err.printf("   Has short name: %s%n", sname);
            }
        }
    }

    private static void evaluateScript(ScriptEngine engine, Hashtable<PanCLOptionKey, Object> options) {
        String spath = null;
        if (options.containsKey((Object)PanCLOptionKey.SCRIPT_PATH)) {
            spath = (String)options.get((Object)PanCLOptionKey.SCRIPT_PATH);
        }
        if (spath == null) {
            PanoplyCL.evaluateLineByLine(engine);
        } else {
            PanoplyCL.evaluateScript(engine, spath);
        }
    }

    private static void evaluateScript(ScriptEngine engine, String spath) {
        Objects.requireNonNull(engine, "Script engine cannot be null.");
        Objects.requireNonNull(spath, "Script path cannot be null.");
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        File sfile = null;
        try {
            sfile = new File(spath);
        }
        catch (Exception exc) {
            logger.error(FATAL, "Could not create File object from '{}' -- {}", (Object)spath, (Object)exc);
            System.exit(2);
        }
        if (sfile == null) {
            logger.error(FATAL, "Script File object cannot be null.");
            System.exit(2);
        } else if (!sfile.exists()) {
            logger.error(FATAL, "No file found at script path '{}'", (Object)spath);
            System.exit(2);
        }
        try (FileInputStream fstream = new FileInputStream(sfile);
             InputStreamReader isr = new InputStreamReader((InputStream)fstream, "UTF-8");
             BufferedReader breader = new BufferedReader(isr);){
            try {
                engine.eval(breader);
            }
            catch (ScriptException exc) {
                PanoplyCL.printException(exc);
            }
            catch (IllegalArgumentException exc) {
                PanoplyCL.printException(exc);
            }
            catch (Exception exc) {
                PanoplyCL.printException(exc);
            }
        }
        catch (Exception exc) {
            logger.error(FATAL, "Could not create script Reader due to {}", (Object)exc.getClass().getSimpleName());
            System.exit(2);
        }
    }

    private static void evaluateLineByLine(ScriptEngine engine) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(isr);
        block4: while (true) {
            try {
                while (true) {
                    System.out.print("> ");
                    String ss = br.readLine();
                    if (ss == null || "file".equalsIgnoreCase(ss) || "exit".equalsIgnoreCase(ss) || "quit".equalsIgnoreCase(ss) || "bye".equalsIgnoreCase(ss) || ".".equalsIgnoreCase(ss)) {
                        System.out.println("Done.");
                        break block4;
                    }
                    engine.eval(ss);
                }
            }
            catch (Exception exc) {
                PanoplyCL.printException(exc);
                continue;
            }
            break;
        }
        try {
            br.close();
        }
        catch (Exception exc) {
            logger.error(FATAL, "Could not close input Reader due to {}", (Object)exc.getClass().getSimpleName());
            System.exit(2);
        }
    }

    private static void printException(Exception exc) {
        exc.printStackTrace();
        PanoplyCL.printException(exc.toString());
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        logger.warn("{}", (Object)exc.toString());
        if (logger.isTraceEnabled()) {
            exc.printStackTrace();
        }
    }

    private static void printException(String excStr) {
        Object s = excStr;
        s = ((String)s).replaceFirst(".*EvaluatorException: ", "");
        s = ((String)s).replaceFirst(".*IllegalArgumentException: ", "");
        s = ((String)s).replaceFirst(".*NumberFormatException: ", "");
        s = ((String)s).replaceFirst(".*WrappedException: Wrapped ", "");
        s = ((String)s).replaceFirst("\\(<Unknown source>\\#\\d*\\) in <Unknown source> ", "");
        s = ((String)s).replaceFirst("gov\\.nasa\\.giss\\.panoply\\.cl\\.", "");
        s = ((String)s).replaceFirst("\\. at line", " at line");
        s = ((String)s).replaceFirst(" at line number", " at script line");
        s = ((String)s).substring(0, 1).toUpperCase() + ((String)s).substring(1);
        System.err.println("ScriptException: " + (String)s);
    }

    public static void quit() {
        System.exit(0);
    }
}

