/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.data.nc.NcCatalogDataset;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.prefs.PanBookmark;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanOpenSourceAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanSourcesFrame parent_;

    public PanOpenSourceAction(PanSourcesFrame parent) {
        super(PanProperties.SOURCES_PROPS.getString("open-source"));
        this.parent_ = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeTableNode node = this.parent_.getSelectedNode();
        if (node == null) {
            return;
        }
        if (node instanceof NcCatalogDataset) {
            URI uri = ((NcCatalogDataset)node).getURI();
            if (uri == null) {
                return;
            }
            try {
                PanFileUtils.openDatasetUsingTask(uri.toURL());
            }
            catch (Exception exc) {
                LOGGER.warn("PanFileUtils.openDataset exception: {}", (Object)exc.toString());
            }
        } else if (node instanceof PanBookmark) {
            LOGGER.trace("Looks like a bookmark!");
            ((PanBookmark)node).open(this.parent_);
        } else {
            LOGGER.warn("Open action not avaiable for {}", (Object)node.getClass().getSimpleName());
        }
    }
}

