/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.dialog;

import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcDiscreteVarType;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanCreatePlotOption;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.StringComboBox;
import gov.nasa.giss.ui.label.MultiLineLabel;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.VariableDS;

public class PanCreatePlotDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ArrayList<AxisWrapper> axWrappers_;
    private JRadioButton georefBtn_;
    private JRadioButton featureBtn_;
    private JRadioButton zonalBtn_;
    private JRadioButton common2DBtn_;
    private JRadioButton lineBtn_;
    private DescribedEnumComboBox geoAxesCombo_;
    private DescribedEnumComboBox featureCombo_;
    private DescribedEnumComboBox zonalCombo_;
    private JComboBox<AxisWrapper> xAxisCombo_;
    private JComboBox<AxisWrapper> yAxisCombo_;
    private StringComboBox linePlotDirCombo_;
    private JComboBox<AxisWrapper> linePlotAxisCombo_;
    private JButton cancelBtn_;
    private JButton createBtn_;
    private boolean success_;
    private boolean enforcingCC_;

    public PanCreatePlotDialog(PanFrame ff, NcVariable ncvar) {
        super(ff, "Create Plot", true);
        this.setResizable(false);
        this.createAxisWrappers(ncvar);
        this.createLayout(ncvar);
        this.attachListeners();
        Rectangle rr = ff.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    private void createAxisWrappers(NcVariable ncvar) {
        NcDimension[] dims = ncvar.getNumericDimensions();
        this.axWrappers_ = new ArrayList();
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] == null || dims[i].getLength() <= 1) continue;
            this.axWrappers_.add(new AxisWrapper(i, dims[i]));
        }
        NcVarType varType = ncvar.getVarType();
        if (varType instanceof NcDiscreteVarType) {
            if (((NcDiscreteVarType)varType).isTrajectory()) {
                VariableDS tvarDS = NcUtils.getTrajectoryTimeVar(ncvar);
                if (tvarDS == null) {
                    LOGGER.trace("Got traj time var = false");
                } else {
                    LOGGER.trace("Got traj time var {}", (Object)tvarDS.getShortName());
                    this.axWrappers_.add(new AxisWrapper(-1, tvarDS));
                }
            }
        } else {
            CoordinateAxis axis = ncvar.getIndirectAxisOfType(NcAxisType.TIME);
            if (axis != null && axis instanceof CoordinateAxis1D && ((CoordinateAxis1D)axis).getRank() == 1) {
                CoordinateAxis1D axis1D = (CoordinateAxis1D)axis;
                LOGGER.trace("Got indirect time var {}", (Object)axis1D.getShortName());
                int axlen = axis1D.getShape()[0];
                if (axlen > 1) {
                    this.axWrappers_.add(new AxisWrapper(-1, axis));
                }
            }
        }
        Collections.sort(this.axWrappers_);
    }

    private void createLayout(NcVariable ncvar) {
        Object dx;
        MultiLineLabel message = new MultiLineLabel("More than one type of plot can be created from the variable '" + ncvar.getName() + "'. What type would you like to create?", 100, 2);
        int maxWidth = message.getPreferredSize().width;
        QuickBox georefBox = null;
        QuickBox common2DBox = null;
        QuickBox lineplotBox = null;
        QuickBox featureBox = null;
        QuickBox zonalBox = null;
        if (ncvar.isGriddable2DGeo()) {
            this.georefBtn_ = new JRadioButton("Georeferenced", true);
            this.geoAxesCombo_ = new DescribedEnumComboBox(PanPlotType.class);
            this.geoAxesCombo_.removeAllItems();
            if (ncvar.hasAxesOfType(NcAxisType.TIME, NcAxisType.LAT)) {
                this.geoAxesCombo_.addItem(PanPlotType.LAT_TIME);
            }
            if (ncvar.hasAxesOfType(NcAxisType.LAT, NcAxisType.VERT)) {
                this.geoAxesCombo_.addItem(PanPlotType.LAT_VERT);
            }
            if (ncvar.hasAxesOfType(NcAxisType.LON, NcAxisType.LAT)) {
                this.geoAxesCombo_.addItem(PanPlotType.LON_LAT);
                this.geoAxesCombo_.setSelectedItem(PanPlotType.LON_LAT);
            }
            if (ncvar.hasAxesOfType(NcAxisType.LON, NcAxisType.TIME)) {
                this.geoAxesCombo_.addItem(PanPlotType.LON_TIME);
            }
            if (ncvar.hasAxesOfType(NcAxisType.LON, NcAxisType.VERT)) {
                this.geoAxesCombo_.addItem(PanPlotType.LON_VERT);
            }
            if (ncvar.hasAxesOfType(NcAxisType.TIME, NcAxisType.LAT)) {
                this.geoAxesCombo_.addItem(PanPlotType.TIME_LAT);
            }
            if (ncvar.hasAxesOfType(NcAxisType.TIME, NcAxisType.VERT)) {
                this.geoAxesCombo_.addItem(PanPlotType.TIME_VERT);
            }
            georefBox = QuickBox.createLeftBox(this.georefBtn_, this.geoAxesCombo_, new JLabel("color contour plot"));
            maxWidth = Math.max(maxWidth, georefBox.getPreferredSize().width);
        }
        if (ncvar.isGriddable2DGeo() && ncvar.hasAxesOfType(NcAxisType.LON, NcAxisType.LAT)) {
            this.zonalBtn_ = new JRadioButton("Georeferenced", true);
            this.zonalCombo_ = new DescribedEnumComboBox(PanPlotType.class);
            this.zonalCombo_.removeAllItems();
            this.zonalCombo_.addItem(PanPlotType.LL_ZONAL);
            zonalBox = QuickBox.createLeftBox(this.zonalBtn_, this.zonalCombo_, new JLabel("line plot"));
            maxWidth = Math.max(maxWidth, zonalBox.getPreferredSize().width);
        }
        if (ncvar.isTrajectory()) {
            this.featureBtn_ = new JRadioButton("Georeferenced", true);
            this.featureCombo_ = new DescribedEnumComboBox(PanPlotType.class);
            this.featureCombo_.removeAllItems();
            this.featureCombo_.addItem(PanPlotType.LL_TRAJ);
            featureBox = QuickBox.createLeftBox(this.featureBtn_, this.featureCombo_, new JLabel("plot"));
            maxWidth = Math.max(maxWidth, featureBox.getPreferredSize().width);
        }
        if (ncvar.isGriddable2D()) {
            this.common2DBtn_ = new JRadioButton("Color contour plot using", true);
            this.xAxisCombo_ = new JComboBox();
            this.yAxisCombo_ = new JComboBox();
            for (AxisWrapper axWrap : this.axWrappers_) {
                this.xAxisCombo_.addItem(axWrap);
                this.yAxisCombo_.addItem(axWrap);
            }
            this.xAxisCombo_.setSelectedIndex(0);
            this.yAxisCombo_.setSelectedIndex(1);
            this.enforceColorContourAxes(this.xAxisCombo_);
            GuiUtils.applyComboBoxUI(this.xAxisCombo_);
            GuiUtils.applyComboBoxUI(this.yAxisCombo_);
            dx = this.xAxisCombo_.getPreferredSize();
            Dimension dy = this.yAxisCombo_.getPreferredSize();
            if (((Dimension)dx).width > 180) {
                ((Dimension)dx).width = 172;
                this.xAxisCombo_.setPreferredSize((Dimension)dx);
                this.xAxisCombo_.setMaximumSize((Dimension)dx);
                this.xAxisCombo_.setMinimumSize((Dimension)dx);
            }
            if (dy.width > 180) {
                dy.width = 172;
                this.yAxisCombo_.setPreferredSize((Dimension)dx);
                this.yAxisCombo_.setMaximumSize((Dimension)dx);
                this.yAxisCombo_.setMinimumSize((Dimension)dx);
            }
            common2DBox = QuickBox.createLeftBox(this.common2DBtn_, this.xAxisCombo_, new JLabel("for X axis and"), this.yAxisCombo_, new JLabel("for Y axis"));
            maxWidth = Math.max(maxWidth, common2DBox.getPreferredSize().width);
        }
        this.lineBtn_ = new JRadioButton("Line plot using", false);
        this.linePlotAxisCombo_ = new JComboBox();
        for (AxisWrapper axWrap : this.axWrappers_) {
            this.linePlotAxisCombo_.addItem(axWrap);
        }
        dx = this.linePlotAxisCombo_.getPreferredSize();
        if (((Dimension)dx).width > 180) {
            ((Dimension)dx).width = 172;
            this.linePlotAxisCombo_.setPreferredSize((Dimension)dx);
            this.linePlotAxisCombo_.setMaximumSize((Dimension)dx);
            this.linePlotAxisCombo_.setMinimumSize((Dimension)dx);
        }
        this.linePlotDirCombo_ = StringComboBox.create();
        this.linePlotDirCombo_.addItem("horizontal");
        this.linePlotDirCombo_.addItem("vertical");
        GuiUtils.applyComboBoxUI(this.linePlotAxisCombo_);
        GuiUtils.applyComboBoxUI(this.linePlotDirCombo_);
        lineplotBox = QuickBox.createLeftBox(this.lineBtn_, this.linePlotAxisCombo_, new JLabel("for the"), this.linePlotDirCombo_, new JLabel("axis"));
        maxWidth = Math.max(maxWidth, lineplotBox.getPreferredSize().width);
        ButtonGroup plotChoices = new ButtonGroup();
        if (this.lineBtn_ != null) {
            plotChoices.add(this.lineBtn_);
            this.lineBtn_.setSelected(true);
        }
        if (this.common2DBtn_ != null) {
            plotChoices.add(this.common2DBtn_);
            this.common2DBtn_.setSelected(true);
        }
        if (this.featureBtn_ != null) {
            plotChoices.add(this.featureBtn_);
            this.featureBtn_.setSelected(true);
        }
        if (this.zonalBtn_ != null) {
            plotChoices.add(this.zonalBtn_);
            this.zonalBtn_.setSelected(true);
        }
        if (this.georefBtn_ != null) {
            plotChoices.add(this.georefBtn_);
            this.georefBtn_.setSelected(true);
        }
        this.cancelBtn_ = new JButton("Cancel");
        this.createBtn_ = new JButton("Create");
        QuickBox buttonBox = PlatformUtils.isMacintosh() ? QuickBox.createRightBox(this.cancelBtn_, this.createBtn_) : QuickBox.createRightBox(this.createBtn_, this.cancelBtn_);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(2, 10, 0, 2);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        int row = 0;
        contentPanel.add((Component)message, new FGConstraint(0, row));
        ++row;
        ++row;
        if (georefBox != null) {
            contentPanel.add((Component)georefBox, new FGConstraint(0, ++row));
        }
        if (zonalBox != null) {
            contentPanel.add((Component)zonalBox, new FGConstraint(0, ++row));
        }
        if (featureBox != null) {
            contentPanel.add((Component)featureBox, new FGConstraint(0, ++row));
        }
        if (common2DBox != null) {
            contentPanel.add((Component)common2DBox, new FGConstraint(0, ++row));
        }
        if (lineplotBox != null) {
            contentPanel.add((Component)lineplotBox, new FGConstraint(0, ++row));
        }
        ++row;
        ++row;
        contentPanel.add((Component)buttonBox, new FGConstraint(0, ++row, 1.0));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(this.createBtn_);
        GuiUtils.fixDefaultButtonColor(this.createBtn_);
        this.pack();
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            EventQueue.invokeLater(() -> this.createBtn_.requestFocusInWindow());
        }
        super.setVisible(vis);
    }

    private void attachListeners() {
        ItemListener il;
        if (this.georefBtn_ != null) {
            this.geoAxesCombo_.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.georefBtn_.setSelected(true);
            });
        }
        if (this.zonalBtn_ != null) {
            this.zonalCombo_.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.zonalBtn_.setSelected(true);
            });
        }
        if (this.featureBtn_ != null) {
            this.featureCombo_.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.featureBtn_.setSelected(true);
            });
        }
        if (this.common2DBtn_ != null) {
            il = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    Object source = e.getSource();
                    if (source instanceof JComboBox) {
                        JComboBox xs = (JComboBox)source;
                        PanCreatePlotDialog.this.enforceColorContourAxes(xs);
                    } else {
                        LOGGER.trace("Unknown source for axis combo event {}", (Object)source.getClass().getSimpleName());
                    }
                }
            };
            this.xAxisCombo_.addItemListener(il);
            this.yAxisCombo_.addItemListener(il);
        }
        if (this.lineBtn_ != null) {
            il = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    PanCreatePlotDialog.this.lineBtn_.setSelected(true);
                }
            };
            this.linePlotDirCombo_.addItemListener(il);
            this.linePlotAxisCombo_.addItemListener(il);
        }
        this.createBtn_.addActionListener(e -> {
            this.success_ = true;
            this.setVisible(false);
        });
        this.cancelBtn_.addActionListener(e -> this.setVisible(false));
    }

    private void enforceColorContourAxes(JComboBox<AxisWrapper> source) {
        this.common2DBtn_.setSelected(true);
        if (this.enforcingCC_) {
            return;
        }
        this.enforcingCC_ = true;
        AxisWrapper axWrap1 = (AxisWrapper)this.xAxisCombo_.getSelectedItem();
        AxisWrapper axWrap2 = (AxisWrapper)this.yAxisCombo_.getSelectedItem();
        ucar.nc2.Dimension axdim1 = axWrap1.getNjDimension();
        ucar.nc2.Dimension axdim2 = axWrap2.getNjDimension();
        String axname1 = axWrap1.toString();
        String axname2 = axWrap2.toString();
        if (axdim1.equals(axdim2) && axname1.equals(axname2)) {
            for (AxisWrapper axWrap3 : this.axWrappers_) {
                ucar.nc2.Dimension axdim3 = axWrap3.getNjDimension();
                if (axdim3.equals(axdim1)) continue;
                LOGGER.trace("3, {}", (Object)axdim3);
                if (source == this.xAxisCombo_) {
                    this.yAxisCombo_.setSelectedItem(axWrap3);
                    break;
                }
                this.xAxisCombo_.setSelectedItem(axWrap3);
                break;
            }
        }
        this.enforcingCC_ = false;
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public Hashtable<PanCreatePlotOption, Object> getOptions() {
        Hashtable<PanCreatePlotOption, Object> opts = new Hashtable<PanCreatePlotOption, Object>();
        if (this.georefBtn_ != null && this.georefBtn_.isSelected()) {
            opts.put(PanCreatePlotOption.PLOT_TYPE, this.geoAxesCombo_.getSelectedItem());
        } else if (this.zonalBtn_ != null && this.zonalBtn_.isSelected()) {
            opts.put(PanCreatePlotOption.PLOT_TYPE, PanPlotType.LL_ZONAL);
        } else if (this.featureBtn_ != null && this.featureBtn_.isSelected()) {
            opts.put(PanCreatePlotOption.PLOT_TYPE, this.featureCombo_.getSelectedItem());
        } else if (this.common2DBtn_ != null && this.common2DBtn_.isSelected()) {
            AxisWrapper axWrap1 = (AxisWrapper)this.xAxisCombo_.getSelectedItem();
            AxisWrapper axWrap2 = (AxisWrapper)this.yAxisCombo_.getSelectedItem();
            opts.put(PanCreatePlotOption.PLOT_TYPE, PanPlotType.GENERAL_CC);
            int idx1 = axWrap1.getDimensionIndex();
            int idx2 = axWrap2.getDimensionIndex();
            if (idx1 > -1) {
                opts.put(PanCreatePlotOption.AXIS_INFO_1, idx1);
            } else {
                opts.put(PanCreatePlotOption.AXIS_INFO_1, axWrap1.getObject());
            }
            if (idx2 > -1) {
                opts.put(PanCreatePlotOption.AXIS_INFO_2, idx2);
            } else {
                opts.put(PanCreatePlotOption.AXIS_INFO_2, axWrap2.getObject());
            }
        } else if (this.lineBtn_ != null && this.lineBtn_.isSelected()) {
            AxisWrapper axWrap = (AxisWrapper)this.linePlotAxisCombo_.getSelectedItem();
            if (((String)this.linePlotDirCombo_.getSelectedItem()).equals("horizontal")) {
                opts.put(PanCreatePlotOption.PLOT_TYPE, PanPlotType.HORZ_LINE);
            } else {
                opts.put(PanCreatePlotOption.PLOT_TYPE, PanPlotType.VERT_LINE);
            }
            int idx = axWrap.getDimensionIndex();
            if (idx > -1) {
                opts.put(PanCreatePlotOption.AXIS_INFO_1, idx);
            } else {
                opts.put(PanCreatePlotOption.AXIS_INFO_1, axWrap.getObject());
            }
        }
        return opts;
    }

    class AxisWrapper
    implements Comparable<AxisWrapper> {
        private int dimIndex_;
        private Object object_;
        private String name_;

        AxisWrapper(int index, Object object) {
            this.dimIndex_ = index;
            this.object_ = object;
            if (object instanceof NcDimension) {
                this.name_ = ((NcDimension)object).getName();
                if (this.name_ == null || this.name_.isEmpty()) {
                    this.name_ = index + 1 + " / " + ((NcDimension)object).getLength();
                }
            } else if (object instanceof VariableDS) {
                this.name_ = ((VariableDS)object).getShortName();
                if (this.name_ == null) {
                    throw new RuntimeException("Object backing axis is VariableDS with no name.");
                }
            } else if (object instanceof CoordinateAxis) {
                this.name_ = ((CoordinateAxis)object).getShortName();
                if (this.name_ == null) {
                    throw new RuntimeException("Object backing axis is CoordinateAxis with no name.");
                }
            } else {
                if (object == null) {
                    LOGGER.error("Unable to create AxisWrapper from 'null'");
                    throw new IllegalArgumentException("Object backing axis is null.");
                }
                String cname = object.getClass().getSimpleName();
                LOGGER.error("Unable to create AxisWrapper from {}", (Object)cname);
                throw new IllegalArgumentException("Object backing axis is unknown class: " + cname);
            }
        }

        int getDimensionIndex() {
            return this.dimIndex_;
        }

        ucar.nc2.Dimension getNjDimension() {
            LOGGER.trace("{}, {}", (Object)this.name_, (Object)this.object_.getClass().getSimpleName());
            if (this.object_ instanceof NcDimension) {
                return ((NcDimension)this.object_).getNjDimension();
            }
            if (this.object_ instanceof VariableDS) {
                return ((VariableDS)this.object_).getDimension(0);
            }
            if (this.object_ instanceof CoordinateAxis) {
                return ((CoordinateAxis)this.object_).getDimension(0);
            }
            LOGGER.warn("{} is {}", (Object)PanCreatePlotDialog.this.getName(), (Object)this.object_.getClass().getSimpleName());
            return null;
        }

        Object getObject() {
            return this.object_;
        }

        public String toString() {
            return this.name_;
        }

        @Override
        public int compareTo(AxisWrapper o) {
            return this.name_.compareTo(o.toString());
        }
    }
}

