/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.plotui.PanPlotControlsMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotHolder;
import gov.nasa.giss.panoply.plotui.PanPlotWindoidHeaderMouseListener;
import gov.nasa.giss.panoply.plotui.PanPlotWindoidListener;
import gov.nasa.giss.panoply.util.PanPlotControlsID;
import gov.nasa.giss.ui.windoid.Windoid;
import gov.nasa.giss.ui.windoid.WindoidHeader;
import gov.nasa.giss.ui.windoid.WindoidKeyEventDispatcher;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotWindoid
extends Windoid {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected PanPlotControlsID cid_;
    private KeyEventDispatcher keDispatcher_;

    public PanPlotWindoid(PanPlotControlsID cid, PanPlotFrame owner) {
        super(cid.getDescription(), owner, false);
        this.cid_ = cid;
        this.setAlwaysOnTop(true);
        this.setCloseable(true);
        Point pt = PanPlotControlsMeta.getLocation(this.cid_);
        if (pt == null) {
            LOGGER.error("PanPlotControlsMeta returned null location for {}", (Object)this.cid_);
        } else {
            this.setLocation(pt.x, pt.y);
        }
    }

    protected void addListeners(PanPlotControlsID cid) {
        PanPlotWindoidListener mwa = new PanPlotWindoidListener();
        this.addWindowListener(mwa);
        this.addWindowFocusListener(mwa);
        WindoidHeader header = this.getHeader();
        header.addHeaderMouseListener(new PanPlotWindoidHeaderMouseListener((PanPlotFrame)this.getOwner(), cid, header));
        this.keDispatcher_ = new WindoidKeyEventDispatcher((PanPlotFrame)this.getOwner(), this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keDispatcher_);
    }

    @Override
    public void setLocation(Point pt) {
        this.setLocation(pt.x, pt.y);
    }

    @Override
    public void setLocation(int x, int y) {
        int xx = x;
        int yy = y;
        if (this.cid_ != null) {
            PanPlotControlsMeta.putLocation(this.cid_, x, y);
            Point pt = PanPlotControlsMeta.getLocation(this.cid_);
            xx = pt.x;
            yy = pt.y;
        }
        super.setLocation(xx, yy);
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis && this.isCollapsible()) {
            boolean collapsed = PanPlotControlsMeta.isCollapsed(this.cid_);
            this.setCollapsed(collapsed);
        }
        super.setVisible(vis);
    }

    public void setVisibleIfMetaTrue(boolean vis) {
        boolean makeVis;
        boolean metaIsTrue = PanPlotControlsMeta.isVisible(this.cid_);
        boolean bl = makeVis = metaIsTrue && vis;
        if (makeVis) {
            Point pt = PanPlotControlsMeta.getLocation(this.cid_);
            this.setLocation(pt.x, pt.y);
        }
        this.setVisible(makeVis);
        PanPlotHolder ph = ((PanPlotFrame)this.getOwner()).getPlotHolder();
        if (ph != null) {
            ph.repaint();
            if (vis) {
                ph.requestFocus();
            }
        }
    }

    public void setVisibleAndSetMeta(boolean vis) {
        if (vis) {
            Point pt = PanPlotControlsMeta.getLocation(this.cid_);
            this.setLocation(pt.x, pt.y);
        }
        PanPlotControlsMeta.putVisible(this.cid_, vis);
        this.setVisible(vis);
        Window ww = this.getOwner();
        if (ww != null && ww.isVisible()) {
            PanPlotFrame mf = (PanPlotFrame)ww;
            if (!vis) {
                mf.getPlotHolder().requestFocus();
            }
            mf.refresh();
        }
    }

    public void closeAndDispose() {
        LOGGER.trace("{}", (Object)this.cid_);
        this.setVisible(false);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keDispatcher_);
        this.dispose();
    }
}

