/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.map.proj.AbstractProjection;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanProjectionInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String projname_;
    private boolean favorite_;
    private String[] params_ = new String[10];

    PanProjectionInfo(Class<? extends AbstractProjection> pclass, boolean favorite) {
        try {
            Field nameField = pclass.getField("PROJECTION_NAME");
            this.projname_ = nameField.get(null).toString();
        }
        catch (Exception exc) {
            LOGGER.error("Couldn't set up projection {}", (Object)pclass);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new RuntimeException("Couldn't set up projection " + pclass);
        }
        this.favorite_ = favorite;
    }

    PanProjectionInfo(String projname, boolean favorite) {
        this.projname_ = projname;
        this.favorite_ = favorite;
    }

    public String getName() {
        return this.projname_;
    }

    public boolean isFavorite() {
        return this.favorite_;
    }

    void setFavorite(boolean favorite) {
        this.favorite_ = favorite;
    }

    public String getParam(int id) {
        if (id >= this.params_.length) {
            return null;
        }
        return this.params_[id];
    }

    void setParam(int id, String value) {
        if (id >= this.params_.length) {
            return;
        }
        this.params_[id] = value;
    }
}

