/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.data.nc.NcConfig;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import javax.swing.Box;
import javax.swing.BoxLayout;

public class PanOpenFilePrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox fileDialogAtLaunchCB_;
    private PanCheckBox loadNjConfigCB_;
    private PanCheckBox strictGribCB_;
    private PanCheckBox showInvalidValsCB_;
    private boolean refreshing_;

    public PanOpenFilePrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.fileDialogAtLaunchCB_ = PanCheckBox.create("Show open-file dialog at launch");
        this.loadNjConfigCB_ = PanCheckBox.create("Use nj22Config.xml file to load netCDF-C library if available (requires restart)");
        this.strictGribCB_ = PanCheckBox.create("Open GRIB-1 datasets in strict mode (requires restart)");
        if (PanUtils.isBeta()) {
            this.showInvalidValsCB_ = PanCheckBox.create("Disable automatic conversion of invalid values to NaNs when opening a dataset");
        }
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiUtils.createPaddedTitleBorder("Open"));
        this.add(QuickBox.createLeftBox(this.fileDialogAtLaunchCB_));
        this.add(Box.createVerticalStrut(2));
        this.add(QuickBox.createLeftBox(this.loadNjConfigCB_));
        this.add(Box.createVerticalStrut(2));
        this.add(QuickBox.createLeftBox(this.strictGribCB_));
        if (PanUtils.isBeta()) {
            this.add(Box.createVerticalStrut(2));
            this.add(QuickBox.createLeftBox(this.showInvalidValsCB_));
        }
    }

    private void attachListeners() {
        this.fileDialogAtLaunchCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.fileDialogAtLaunchCB_.isSelected();
            prefs_.setBoolean("files:dialog.launch", bb);
        });
        this.loadNjConfigCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.loadNjConfigCB_.isSelected();
            prefs_.setBoolean("files:load-njconfig", bb);
        });
        this.strictGribCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.strictGribCB_.isSelected();
            prefs_.setBoolean("files:grib1-strict", bb);
        });
        if (PanUtils.isBeta()) {
            this.showInvalidValsCB_.addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                boolean bb = this.showInvalidValsCB_.isSelected();
                prefs_.setBoolean("files:show-invalid-vals", bb);
                NcConfig.showInvalidValues(bb);
            });
        }
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.fileDialogAtLaunchCB_.setSelected(prefs_.getBoolean("files:dialog.launch"));
        this.loadNjConfigCB_.setSelected(prefs_.getBoolean("files:load-njconfig"));
        this.strictGribCB_.setSelected(prefs_.getBoolean("files:grib1-strict"));
        if (PanUtils.isBeta()) {
            this.showInvalidValsCB_.setSelected(prefs_.getBoolean("files:show-invalid-vals"));
        }
        this.refreshing_ = false;
    }
}

