/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;

public final class AnnotatedElementAdapter
implements AnnotatedElement,
Serializable {
    private static final AnnotatedElementAdapter EMPTY = new AnnotatedElementAdapter(new Annotation[0]);
    private final Annotation[] annotations;

    public static AnnotatedElementAdapter from(Annotation @Nullable [] annotations) {
        if (annotations == null || annotations.length == 0) {
            return EMPTY;
        }
        return new AnnotatedElementAdapter(annotations);
    }

    private AnnotatedElementAdapter(Annotation[] annotations) {
        this.annotations = annotations;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        for (Annotation annotation : this.annotations) {
            if (annotation.annotationType() != annotationClass) continue;
            return true;
        }
        return false;
    }

    public <A extends Annotation> @Nullable A getAnnotation(Class<A> annotationClass) {
        for (Annotation annotation : this.annotations) {
            if (annotation.annotationType() != annotationClass) continue;
            return (A)((Annotation)annotationClass.cast(annotation));
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.isEmpty() ? this.annotations : (Annotation[])this.annotations.clone();
    }

    public <A extends Annotation> @Nullable A getDeclaredAnnotation(Class<A> annotationClass) {
        return this.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof AnnotatedElementAdapter)) return false;
        AnnotatedElementAdapter that = (AnnotatedElementAdapter)other;
        if (!Arrays.equals(this.annotations, that.annotations)) return false;
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.annotations);
    }

    public String toString() {
        return Arrays.toString(this.annotations);
    }
}

