/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j;

public enum PluginState {
    CREATED("CREATED"),
    DISABLED("DISABLED"),
    RESOLVED("RESOLVED"),
    STARTED("STARTED"),
    STOPPED("STOPPED"),
    FAILED("FAILED"),
    UNLOADED("UNLOADED");

    private final String status;

    private PluginState(String status) {
        this.status = status;
    }

    public boolean isCreated() {
        return this == CREATED;
    }

    public boolean isDisabled() {
        return this == DISABLED;
    }

    public boolean isResolved() {
        return this == RESOLVED;
    }

    public boolean isStarted() {
        return this == STARTED;
    }

    public boolean isStopped() {
        return this == STOPPED;
    }

    public boolean isFailed() {
        return this == FAILED;
    }

    public boolean isUnloaded() {
        return this == UNLOADED;
    }

    public boolean equals(String status) {
        return this.status.equalsIgnoreCase(status);
    }

    public String toString() {
        return this.status;
    }

    public static PluginState parse(String string) {
        for (PluginState status : PluginState.values()) {
            if (!status.equals(string)) continue;
            return status;
        }
        return null;
    }
}

