/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.maxmind.db.MaxMindDbCreator;
import com.maxmind.db.MaxMindDbParameter;
import com.maxmind.db.Network;
import com.maxmind.geoip2.JsonSerializable;
import com.maxmind.geoip2.NetworkDeserializer;
import java.net.InetAddress;

public record ConnectionTypeResponse(@JsonProperty(value="connection_type") @MaxMindDbParameter(name="connection_type") ConnectionType connectionType, @JsonProperty(value="ip_address") InetAddress ipAddress, @JsonProperty(value="network") @JsonDeserialize(using=NetworkDeserializer.class) Network network) implements JsonSerializable
{
    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty(value="connection_type")
    public ConnectionType getConnectionType() {
        return this.connectionType();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty(value="ip_address")
    public String getIpAddress() {
        return this.ipAddress().getHostAddress();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty
    @JsonSerialize(using=ToStringSerializer.class)
    public Network getNetwork() {
        return this.network();
    }

    public static enum ConnectionType {
        DIALUP("Dialup"),
        CABLE_DSL("Cable/DSL"),
        CORPORATE("Corporate"),
        CELLULAR("Cellular"),
        SATELLITE("Satellite");

        private final String name;

        private ConnectionType(String name) {
            this.name = name;
        }

        @JsonValue
        public String toString() {
            return this.name;
        }

        @JsonCreator
        @MaxMindDbCreator
        public static ConnectionType fromString(String s) {
            if (s == null) {
                return null;
            }
            return switch (s) {
                case "Dialup" -> DIALUP;
                case "Cable/DSL" -> CABLE_DSL;
                case "Corporate" -> CORPORATE;
                case "Cellular" -> CELLULAR;
                case "Satellite" -> SATELLITE;
                default -> null;
            };
        }
    }
}

