/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maxmind.geoip2.JsonSerializable;
import com.maxmind.geoip2.record.Anonymizer;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.MaxMind;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.RepresentedCountry;
import com.maxmind.geoip2.record.Subdivision;
import com.maxmind.geoip2.record.Traits;
import java.util.ArrayList;
import java.util.List;

public record InsightsResponse(@JsonProperty(value="anonymizer") Anonymizer anonymizer, @JsonProperty(value="city") City city, @JsonProperty(value="continent") Continent continent, @JsonProperty(value="country") Country country, @JsonProperty(value="location") Location location, @JsonProperty(value="maxmind") MaxMind maxmind, @JsonProperty(value="postal") Postal postal, @JsonProperty(value="registered_country") Country registeredCountry, @JsonProperty(value="represented_country") RepresentedCountry representedCountry, @JsonProperty(value="subdivisions") List<Subdivision> subdivisions, @JsonProperty(value="traits") Traits traits) implements JsonSerializable
{
    public InsightsResponse {
        anonymizer = anonymizer != null ? anonymizer : new Anonymizer();
        city = city != null ? city : new City();
        continent = continent != null ? continent : new Continent();
        country = country != null ? country : new Country();
        location = location != null ? location : new Location();
        maxmind = maxmind != null ? maxmind : new MaxMind();
        postal = postal != null ? postal : new Postal();
        registeredCountry = registeredCountry != null ? registeredCountry : new Country();
        representedCountry = representedCountry != null ? representedCountry : new RepresentedCountry();
        subdivisions = subdivisions != null ? List.copyOf(subdivisions) : List.of();
        traits = traits != null ? traits : new Traits();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public City getCity() {
        return this.city();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public Continent getContinent() {
        return this.continent();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public Country getCountry() {
        return this.country();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public Location getLocation() {
        return this.location();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty(value="maxmind")
    public MaxMind getMaxMind() {
        return this.maxmind();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public Postal getPostal() {
        return this.postal();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty(value="registered_country")
    public Country getRegisteredCountry() {
        return this.registeredCountry();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty(value="represented_country")
    public RepresentedCountry getRepresentedCountry() {
        return this.representedCountry();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public List<Subdivision> getSubdivisions() {
        return new ArrayList<Subdivision>(this.subdivisions());
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public Traits getTraits() {
        return this.traits();
    }

    @JsonIgnore
    public Subdivision mostSpecificSubdivision() {
        if (this.subdivisions().isEmpty()) {
            return new Subdivision();
        }
        return this.subdivisions().get(this.subdivisions().size() - 1);
    }

    @JsonIgnore
    @Deprecated(since="5.0.0", forRemoval=true)
    public Subdivision getMostSpecificSubdivision() {
        return this.mostSpecificSubdivision();
    }

    @JsonIgnore
    public Subdivision leastSpecificSubdivision() {
        if (this.subdivisions().isEmpty()) {
            return new Subdivision();
        }
        return this.subdivisions().get(0);
    }

    @JsonIgnore
    @Deprecated(since="5.0.0", forRemoval=true)
    public Subdivision getLeastSpecificSubdivision() {
        return this.leastSpecificSubdivision();
    }
}

