/*
 * Decompiled with CFR 0.152.
 */
package com.cdnbye.core.nat;

import com.cdnbye.core.nat.NatType;
import com.cdnbye.core.nat.StunChangeRequest;
import com.cdnbye.core.nat.StunClientHandler;
import com.cdnbye.core.nat.StunMessage;
import com.cdnbye.core.nat.StunMessageType;
import com.cdnbye.core.nat.StunResult;
import com.cdnbye.core.nat.Utils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.InetSocketAddress;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyStunClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyStunClient.class);
    private static final int TRANSACTION_TIMEOUT_MS = 1000;
    private static final int TOTAL_TIMEOUT_SECONDS = 5;
    private static final String DEFAULT_STUN_HOST = "stun.cdnbye.com";
    private static final int DEFAULT_STUN_PORT = 3478;

    public static StunResult query(String localIP) {
        return NettyStunClient.query(DEFAULT_STUN_HOST, 3478, localIP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StunResult query(String stunHost, int stunPort, String localIP) {
        if (stunHost == null || localIP == null) {
            throw new InvalidParameterException("Host and localIP cannot be null");
        }
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        try {
            CompletableFuture<StunResult> finalResultFuture = new CompletableFuture<StunResult>();
            StunClientHandler handler = new StunClientHandler(1000);
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioDatagramChannel.class)).handler((ChannelHandler)handler);
            Channel channel = b.bind(0).sync().channel();
            NettyStunClient.executeStunLogic(handler, channel, stunHost, stunPort, localIP, finalResultFuture);
            StunResult stunResult = finalResultFuture.get(5L, TimeUnit.SECONDS);
            return stunResult;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.debug("STUN query failed or timed out.", (Throwable)e);
            StunResult stunResult = new StunResult(NatType.Unknown, null);
            return stunResult;
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static void executeStunLogic(StunClientHandler handler, Channel channel, String stunHost, int stunPort, String localIP, CompletableFuture<StunResult> finalResultFuture) {
        InetSocketAddress remoteAddress = new InetSocketAddress(stunHost, stunPort);
        StunMessage test1Request = new StunMessage(StunMessageType.BindingRequest);
        handler.doTransaction(test1Request, remoteAddress, channel).whenComplete((test1Response, ex) -> {
            boolean isNat;
            if (ex != null) {
                log.debug("UDP seems to be blocked, no response from STUN server at {}:{}", new Object[]{stunHost, stunPort, ex});
                finalResultFuture.complete(new StunResult(NatType.UdpBlocked, null));
                return;
            }
            InetSocketAddress mappedAddress = test1Response.getMappedAddress();
            boolean bl = isNat = !Arrays.equals(Utils.ipToBytes(localIP), mappedAddress.getAddress().getAddress());
            if (!isNat) {
                NettyStunClient.handleNoNatPath(handler, test1Response, channel, remoteAddress, finalResultFuture);
            } else {
                NettyStunClient.handleNatPath(handler, test1Response, channel, remoteAddress, finalResultFuture);
            }
        });
    }

    private static void handleNoNatPath(StunClientHandler handler, StunMessage test1Response, Channel channel, InetSocketAddress remoteAddress, CompletableFuture<StunResult> finalResultFuture) {
        StunMessage test2Request = new StunMessage(StunMessageType.BindingRequest, new StunChangeRequest(true, true));
        handler.doTransaction(test2Request, remoteAddress, channel).whenComplete((test2Response, ex) -> {
            if (ex == null && test2Response != null) {
                if (NettyStunClient.isResponseFromDifferentAddress(test2Response, remoteAddress)) {
                    finalResultFuture.complete(new StunResult(NatType.OpenInternet, test1Response.getMappedAddress()));
                } else {
                    log.debug("STUN server at {}:{} did not change IP/port as requested in Test II (change IP=true, change port=true). This violates STUN RFC 3489. Server behavior is non-compliant.", (Object)remoteAddress.getHostString(), (Object)remoteAddress.getPort());
                    finalResultFuture.complete(new StunResult(NatType.Unknown, test1Response.getMappedAddress()));
                }
            } else {
                finalResultFuture.complete(new StunResult(NatType.SymmetricUdpFirewall, test1Response.getMappedAddress()));
            }
        });
    }

    private static void handleNatPath(StunClientHandler handler, StunMessage test1Response, Channel channel, InetSocketAddress remoteAddress, CompletableFuture<StunResult> finalResultFuture) {
        StunMessage test2Request = new StunMessage(StunMessageType.BindingRequest, new StunChangeRequest(true, true));
        handler.doTransaction(test2Request, remoteAddress, channel).whenComplete((test2Response, ex) -> {
            if (ex == null && test2Response != null) {
                if (NettyStunClient.isResponseFromDifferentAddress(test2Response, remoteAddress)) {
                    finalResultFuture.complete(new StunResult(NatType.FullCone, test1Response.getMappedAddress()));
                } else {
                    log.debug("STUN server at {}:{} did not change IP/port as requested in Test II (change IP=true, change port=true). This violates STUN RFC 3489. Server behavior is non-compliant.", (Object)remoteAddress.getHostString(), (Object)remoteAddress.getPort());
                    finalResultFuture.complete(new StunResult(NatType.Unknown, test1Response.getMappedAddress()));
                }
            } else {
                NettyStunClient.handleRestrictedNatPath(handler, test1Response, channel, finalResultFuture);
            }
        });
    }

    private static void handleRestrictedNatPath(StunClientHandler handler, StunMessage test1Response, Channel channel, CompletableFuture<StunResult> finalResultFuture) {
        StunMessage test12Request = new StunMessage(StunMessageType.BindingRequest);
        InetSocketAddress changedAddress = test1Response.getChangedAddress();
        handler.doTransaction(test12Request, changedAddress, channel).whenComplete((test12Response, ex) -> {
            boolean mappedAddressIsSame;
            if (ex != null) {
                log.debug("STUN Test I(II) failed to get a response.", ex);
                finalResultFuture.complete(new StunResult(NatType.Unknown, test1Response.getMappedAddress()));
                return;
            }
            boolean bl = mappedAddressIsSame = Arrays.equals(test1Response.getMappedAddress().getAddress().getAddress(), test12Response.getMappedAddress().getAddress().getAddress()) && test1Response.getMappedAddress().getPort() == test12Response.getMappedAddress().getPort();
            if (!mappedAddressIsSame) {
                finalResultFuture.complete(new StunResult(NatType.Symmetric, test1Response.getMappedAddress()));
            } else {
                StunMessage test3Request = new StunMessage(StunMessageType.BindingRequest, new StunChangeRequest(false, true));
                handler.doTransaction(test3Request, changedAddress, channel).whenComplete((test3Response, ex3) -> {
                    if (ex3 == null && test3Response != null) {
                        finalResultFuture.complete(new StunResult(NatType.RestrictedCone, test1Response.getMappedAddress()));
                    } else {
                        finalResultFuture.complete(new StunResult(NatType.PortRestrictedCone, test1Response.getMappedAddress()));
                    }
                });
            }
        });
    }

    private static boolean isResponseFromDifferentAddress(StunMessage response, InetSocketAddress originalRemoteAddress) {
        InetSocketAddress sourceAddress = response.getSourceAddress();
        if (sourceAddress == null) {
            log.debug("STUN response does not contain SOURCE-ADDRESS attribute, cannot verify server compliance");
            return false;
        }
        boolean ipDifferent = !sourceAddress.getAddress().equals(originalRemoteAddress.getAddress());
        boolean portDifferent = sourceAddress.getPort() != originalRemoteAddress.getPort();
        log.debug("STUN server compliance check: original={}:{}, response_source={}:{}, ip_changed={}, port_changed={}", new Object[]{originalRemoteAddress.getHostString(), originalRemoteAddress.getPort(), sourceAddress.getHostString(), sourceAddress.getPort(), ipDifferent, portDifferent});
        return ipDifferent || portDifferent;
    }
}

