/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ability.impl;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.btn.BtnNetwork;
import com.ghostchu.peerbanhelper.btn.ability.AbstractBtnAbility;
import com.ghostchu.peerbanhelper.btn.ping.BtnBan;
import com.ghostchu.peerbanhelper.btn.ping.BtnBanPing;
import com.ghostchu.peerbanhelper.database.dao.impl.HistoryDao;
import com.ghostchu.peerbanhelper.database.dao.impl.MetadataDao;
import com.ghostchu.peerbanhelper.database.table.HistoryEntity;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.google.gson.JsonObject;
import com.j256.ormlite.dao.CloseableWrappedIterable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BtnAbilitySubmitBans
extends AbstractBtnAbility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnAbilitySubmitBans.class);
    private final BtnNetwork btnNetwork;
    private final long interval;
    private final String endpoint;
    private final long randomInitialDelay;
    private final MetadataDao metadataDao;
    private final HistoryDao historyDao;
    private final boolean powCaptcha;

    public BtnAbilitySubmitBans(BtnNetwork btnNetwork, JsonObject ability, MetadataDao metadataDao, HistoryDao historyDao) {
        this.btnNetwork = btnNetwork;
        this.metadataDao = metadataDao;
        this.historyDao = historyDao;
        this.interval = ability.get("interval").getAsLong();
        this.endpoint = ability.get("endpoint").getAsString();
        this.randomInitialDelay = ability.get("random_initial_delay").getAsLong();
        this.powCaptcha = ability.has("pow_captcha") && ability.get("pow_captcha").getAsBoolean();
    }

    @Override
    public String getName() {
        return "BtnAbilitySubmitBans";
    }

    @Override
    public TranslationComponent getDisplayName() {
        return new TranslationComponent(Lang.BTN_ABILITY_SUBMIT_BANS);
    }

    @Override
    public TranslationComponent getDescription() {
        return new TranslationComponent(Lang.BTN_ABILITY_SUBMIT_BANS_DESCRIPTION);
    }

    @Override
    public void load() {
        Main.getEventBus().register((Object)this);
        this.setLastStatus(true, new TranslationComponent(Lang.BTN_NO_CONTENT_REPORTED_YET));
        this.btnNetwork.getScheduler().scheduleWithFixedDelay(this::submit, ThreadLocalRandom.current().nextLong(this.randomInitialDelay), this.interval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void unload() {
        Main.getEventBus().unregister((Object)this);
    }

    private int setMemCursor(long position) {
        return this.metadataDao.set("BtnAbilitySubmitBans.memCursor", String.valueOf(position));
    }

    private long getMemCursor() {
        return Long.parseLong(this.metadataDao.getOrDefault("BtnAbilitySubmitBans.memCursor", "0"));
    }

    private void submit() {
        try {
            log.info(TextManager.tlUI(Lang.BTN_SUBMITTING_BANS, new Object[0]));
            int size = 0;
            int requests = 0;
            ArrayList<HistoryEntity> historyEntities = new ArrayList<HistoryEntity>(500);
            try (CloseableWrappedIterable<HistoryEntity> it = this.createSubmitIterator(this.getMemCursor());){
                for (HistoryEntity entity : it) {
                    historyEntities.add(entity);
                    if (historyEntities.size() < 500) continue;
                    this.setMemCursor(this.createSubmitRequest(historyEntities));
                    size += historyEntities.size();
                    ++requests;
                    historyEntities.clear();
                }
            }
            if (!historyEntities.isEmpty()) {
                this.setMemCursor(this.createSubmitRequest(historyEntities));
                ++requests;
                size += historyEntities.size();
            }
            log.info(TextManager.tlUI(Lang.BTN_SUBMITTED_BANS, size, requests));
            this.setLastStatus(true, new TranslationComponent(Lang.BTN_REPORTED_DATA, size));
        }
        catch (IllegalStateException size) {
        }
        catch (Throwable e) {
            log.error(TextManager.tlUI(Lang.BTN_UNKNOWN_ERROR, new Object[0]), e);
            this.setLastStatus(false, new TranslationComponent(Lang.BTN_UNKNOWN_ERROR, e.getClass().getName() + ": " + e.getMessage()));
        }
    }

    private CloseableWrappedIterable<HistoryEntity> createSubmitIterator(long memCursor) throws SQLException {
        return this.historyDao.getWrappedIterable(this.historyDao.queryBuilder().where().gt("id", (Object)memCursor).queryBuilder().orderBy("id", true).prepare());
    }

    private long createSubmitRequest(List<HistoryEntity> historyEntities) throws RuntimeException {
        long l;
        block10: {
            BtnBanPing ping = new BtnBanPing(historyEntities.stream().map(historyEntity -> {
                try {
                    return BtnBan.from(historyEntity);
                }
                catch (Exception e) {
                    return null;
                }
            }).filter(Objects::nonNull).toList());
            byte[] jsonBytes = JsonUtil.getGson().toJson((Object)ping).getBytes(StandardCharsets.UTF_8);
            RequestBody body = this.createGzipRequestBody(jsonBytes);
            Request.Builder request = new Request.Builder().url(this.endpoint).post(body).header("Content-Encoding", "gzip");
            if (this.powCaptcha) {
                this.btnNetwork.gatherAndSolveCaptchaBlocking(request, "submit_bans");
            }
            Response resp = this.btnNetwork.getHttpClient().newCall(request.build()).execute();
            try {
                if (!resp.isSuccessful()) {
                    String responseBody = resp.body() != null ? resp.body().string() : "";
                    log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, resp.code() + " - " + responseBody));
                    this.setLastStatus(false, new TranslationComponent(Lang.BTN_HTTP_ERROR, resp.code(), responseBody));
                    throw new IllegalStateException(TextManager.tlUI(new TranslationComponent(Lang.BTN_HTTP_ERROR, resp.code(), responseBody)));
                }
                l = historyEntities.getLast().getId();
                if (resp == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, e.getMessage()), (Throwable)e);
                    this.setLastStatus(false, new TranslationComponent(Lang.BTN_HTTP_ERROR, -1, e.getMessage()));
                    throw new IllegalStateException(TextManager.tlUI(new TranslationComponent(Lang.BTN_HTTP_ERROR, -1, e.getMessage())), e);
                }
            }
            resp.close();
        }
        return l;
    }

    private RequestBody createGzipRequestBody(final byte[] data) {
        return new RequestBody(this){
            {
                Objects.requireNonNull(this$0);
            }

            public MediaType contentType() {
                return MediaType.get((String)"application/json");
            }

            public void writeTo(@NotNull BufferedSink sink) throws IOException {
                BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)sink));
                gzipSink.write(data);
                gzipSink.close();
            }
        };
    }
}

