/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.downloader;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.downloader.AbstractDownloader;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderBasicInfo;
import com.ghostchu.peerbanhelper.downloader.DownloaderManager;
import com.ghostchu.peerbanhelper.downloader.impl.biglybt.BiglyBT;
import com.ghostchu.peerbanhelper.downloader.impl.bitcomet.BitComet;
import com.ghostchu.peerbanhelper.downloader.impl.deluge.Deluge;
import com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.impl.QBittorrent;
import com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.impl.enhanced.QBittorrentEE;
import com.ghostchu.peerbanhelper.downloader.impl.transmission.Transmission;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.traversal.NatAddressProvider;
import com.ghostchu.peerbanhelper.util.traversal.NatAddressProviderRegistry;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.ReloadStatus;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.configuration.MemoryConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class DownloaderManagerImpl
extends CopyOnWriteArrayList<Downloader>
implements Reloadable,
DownloaderManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloaderManagerImpl.class);
    private final AlertManager alertManager;
    private final HTTPUtil httpUtil;
    private final NatAddressProviderRegistry natAddressProviderRegistry;

    public DownloaderManagerImpl(AlertManager alertManager, HTTPUtil httpUtil, NatAddressProviderRegistry natAddressProviderRegistry) {
        this.alertManager = alertManager;
        this.httpUtil = httpUtil;
        this.natAddressProviderRegistry = natAddressProviderRegistry;
        Main.getReloadManager().register((Reloadable)this);
        this.load();
    }

    public ReloadResult reloadModule() {
        this.load();
        return new ReloadResult(ReloadStatus.SUCCESS, "SUCCESS", null);
    }

    private void load() {
        this.close();
        this.loadDownloaders();
    }

    @Override
    public void loadDownloaders() {
        this.closeDownloaders();
        this.clear();
        ConfigurationSection clientSection = Main.getMainConfig().getConfigurationSection("client");
        if (clientSection == null) {
            return;
        }
        for (String uuid : clientSection.getKeys(false)) {
            ConfigurationSection downloaderSection = clientSection.getConfigurationSection(uuid);
            String endpoint = downloaderSection.getString("endpoint");
            Downloader downloader = this.createDownloader(uuid, downloaderSection);
            this.registerDownloader(downloader);
            log.info(TextManager.tlUI(Lang.DISCOVER_NEW_CLIENT, downloader.getType(), downloader.getName() + "(" + uuid + ")", endpoint));
        }
    }

    @Override
    public Downloader createDownloader(String id, ConfigurationSection downloaderSection) {
        AbstractDownloader downloader = null;
        switch (downloaderSection.getString("type").toLowerCase(Locale.ROOT)) {
            case "qbittorrent": {
                downloader = QBittorrent.loadFromConfig(id, downloaderSection, this.alertManager, this.httpUtil, (NatAddressProvider)this.natAddressProviderRegistry);
                break;
            }
            case "qbittorrentee": {
                downloader = QBittorrentEE.loadFromConfig(id, downloaderSection, this.alertManager, this.httpUtil, (NatAddressProvider)this.natAddressProviderRegistry);
                break;
            }
            case "transmission": {
                downloader = Transmission.loadFromConfig(id, Main.getPbhServerAddress(), downloaderSection, this.alertManager, this.httpUtil, (NatAddressProvider)this.natAddressProviderRegistry);
                break;
            }
            case "biglybt": {
                downloader = BiglyBT.loadFromConfig(id, downloaderSection, this.alertManager, this.httpUtil, (NatAddressProvider)this.natAddressProviderRegistry);
                break;
            }
            case "raccoonfink/deluge": 
            case "deluge": {
                downloader = Deluge.loadFromConfig(id, downloaderSection, this.alertManager, this.httpUtil, (NatAddressProvider)this.natAddressProviderRegistry);
                break;
            }
            case "bitcomet": {
                downloader = BitComet.loadFromConfig(id, downloaderSection, this.alertManager, this.httpUtil, (NatAddressProvider)this.natAddressProviderRegistry);
            }
        }
        return downloader;
    }

    @Override
    public Downloader createDownloader(String id, JsonObject downloaderSection) {
        OkHttpClient.Builder builder = this.httpUtil.newBuilder();
        AbstractDownloader downloader = null;
        switch (downloaderSection.get("type").getAsString().toLowerCase(Locale.ROOT)) {
            case "qbittorrent": {
                downloader = QBittorrent.loadFromConfig(id, downloaderSection, this.alertManager, this.httpUtil, (NatAddressProvider)this.natAddressProviderRegistry);
                break;
            }
            case "qbittorrentee": {
                downloader = QBittorrentEE.loadFromConfig(id, downloaderSection, this.alertManager, this.httpUtil, (NatAddressProvider)this.natAddressProviderRegistry);
                break;
            }
            case "transmission": {
                downloader = Transmission.loadFromConfig(id, Main.getPbhServerAddress(), downloaderSection, this.alertManager, this.httpUtil, (NatAddressProvider)this.natAddressProviderRegistry);
                break;
            }
            case "biglybt": {
                downloader = BiglyBT.loadFromConfig(id, downloaderSection, this.alertManager, this.httpUtil, (NatAddressProvider)this.natAddressProviderRegistry);
                break;
            }
            case "raccoonfink/deluge": 
            case "deluge": {
                downloader = Deluge.loadFromConfig(id, downloaderSection, this.alertManager, this.httpUtil, (NatAddressProvider)this.natAddressProviderRegistry);
                break;
            }
            case "bitcomet": {
                downloader = BitComet.loadFromConfig(id, downloaderSection, this.alertManager, this.httpUtil, (NatAddressProvider)this.natAddressProviderRegistry);
            }
        }
        return downloader;
    }

    @Override
    public void saveDownloaders() throws IOException {
        MemoryConfiguration clientSection = new MemoryConfiguration();
        for (Downloader downloader : this) {
            clientSection.set(downloader.getId(), (Object)downloader.saveDownloader());
        }
        Main.getMainConfig().set("client", (Object)clientSection);
        Main.getMainConfig().save(Main.getMainConfigFile());
    }

    @Override
    public boolean registerDownloader(Downloader downloader) {
        if (this.stream().anyMatch(d -> d.getId().equals(downloader.getId()))) {
            return false;
        }
        if (this.stream().anyMatch(d -> d.getName().equals(downloader.getName()))) {
            return false;
        }
        this.add(downloader);
        return true;
    }

    @Override
    public void unregisterDownloader(Downloader downloader) {
        this.remove(downloader);
    }

    @Override
    public List<Downloader> getDownloaders() {
        return List.copyOf(this);
    }

    @Override
    @Nullable
    public Downloader getDownloaderById(String id) {
        for (Downloader downloader : this) {
            if (!downloader.getId().equals(id)) continue;
            return downloader;
        }
        return null;
    }

    @Override
    @NotNull
    public DownloaderBasicInfo getDownloadInfo(@NotNull Downloader downloader) {
        return new DownloaderBasicInfo(downloader.getId(), downloader.getName(), downloader.getType());
    }

    @Override
    @NotNull
    public DownloaderBasicInfo getDownloadInfo(@Nullable String id) {
        Downloader downloader = this.getDownloaderById(id);
        if (downloader != null && id != null) {
            return new DownloaderBasicInfo(downloader.getId(), downloader.getName(), downloader.getType());
        }
        return new DownloaderBasicInfo(id, "Unknown", "Unknown");
    }

    @Override
    @NotNull
    public List<Downloader> getDownloaderByName(String name) {
        return this.stream().filter(d -> d.getName().equals(name)).toList();
    }

    @Override
    public void close() {
        this.closeDownloaders();
    }

    private void closeDownloaders() {
        for (Downloader d : this) {
            try {
                d.close();
            }
            catch (Exception e) {
                log.error(TextManager.tlUI(Lang.UNABLE_CLOSE_DOWNLOADER, d.getName()), (Throwable)e);
            }
        }
    }
}

