/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.monitor;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.database.dao.impl.PeerRecordDao;
import com.ghostchu.peerbanhelper.database.dao.impl.TorrentDao;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.MonitorFeatureModule;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.ghostchu.peerbanhelper.wrapper.PeerWrapper;
import com.ghostchu.peerbanhelper.wrapper.TorrentWrapper;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.Where;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PeerRecodingServiceModule
extends AbstractFeatureModule
implements Reloadable,
MonitorFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PeerRecodingServiceModule.class);
    @Autowired
    private PeerRecordDao peerRecordDao;
    private final Deque<PeerRecordDao.BatchHandleTasks> dataBuffer = new ConcurrentLinkedDeque<PeerRecordDao.BatchHandleTasks>();
    private final BlockingDeque<Runnable> taskWriteQueue = new LinkedBlockingDeque<Runnable>();
    private final Cache<PeerRecordDao.BatchHandleTasks, Object> diskWriteCache = CacheBuilder.newBuilder().expireAfterWrite(ExternalSwitch.parseLong("pbh.module.peerRecordingServiceModule.diskWriteCache.timeout", 180000L), TimeUnit.MILLISECONDS).maximumSize((long)ExternalSwitch.parseInt("pbh.module.peerRecordingServiceModule.diskWriteCache.size", 3500)).removalListener(notification -> this.dataBuffer.offer((PeerRecordDao.BatchHandleTasks)notification.getKey())).build();
    private ExecutorService taskWriteService;
    private long dataRetentionTime;
    @Autowired
    private TorrentDao torrentDao;

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void onTorrentPeersRetrieved(@NotNull Downloader downloader, @NotNull Torrent torrent, @NotNull List<Peer> peers) {
        peers.stream().filter(peer -> {
            String clientName = peer.getClientName();
            String peerId = peer.getPeerId();
            if (clientName != null && !clientName.isBlank()) {
                return true;
            }
            if (peerId != null && !peerId.isBlank()) {
                return true;
            }
            return !peer.isHandshaking();
        }).forEach(peer -> this.diskWriteCache.put((Object)new PeerRecordDao.BatchHandleTasks(System.currentTimeMillis(), downloader.getId(), new TorrentWrapper(torrent), new PeerWrapper((Peer)peer)), MiscUtil.EMPTY_OBJECT));
    }

    @Override
    @NotNull
    public String getName() {
        return "Peer Recording Service";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "peer-analyse-service.peer-recording";
    }

    @Override
    public void onEnable() {
        this.reloadConfig();
        this.taskWriteService = new ThreadPoolExecutor(1, 2, 60L, TimeUnit.SECONDS, this.taskWriteQueue);
        long dataCleanupInterval = this.getConfig().getLong("data-cleanup-interval", -1L);
        long dataFlushInterval = this.getConfig().getLong("data-flush-interval", 20000L);
        this.registerScheduledTask(this::cleanup, 0L, dataCleanupInterval, TimeUnit.MILLISECONDS);
        this.registerScheduledTask(this::flush, 0L, dataFlushInterval, TimeUnit.MILLISECONDS);
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    private void reloadConfig() {
        if (this.taskWriteService != null) {
            this.taskWriteService.shutdown();
        }
        this.taskWriteService = Executors.newSingleThreadExecutor();
        this.dataRetentionTime = this.getConfig().getLong("data-retention-time", -1L);
    }

    public void flush() {
        try {
            try {
                this.diskWriteCache.asMap().forEach((k, v) -> this.dataBuffer.offer((PeerRecordDao.BatchHandleTasks)k));
                this.peerRecordDao.syncPendingTasks(this.dataBuffer, this.torrentDao);
            }
            catch (SQLException e) {
                log.warn("Unable sync peers data to database", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            log.error("Unable to complete scheduled tasks", throwable);
        }
    }

    private void cleanup() {
        try {
            if (this.dataRetentionTime <= 0L) {
                return;
            }
            log.debug("Cleaning PeerRecording table...");
            try {
                DeleteBuilder deleteBuilder = this.peerRecordDao.deleteBuilder();
                Where where = deleteBuilder.where().lt("lastTimeSeen", (Object)new Timestamp(System.currentTimeMillis() - this.dataRetentionTime));
                deleteBuilder.setWhere(where);
                int deleted = deleteBuilder.delete();
                log.debug("Cleaned {} old records from peer_records tables", (Object)deleted);
            }
            catch (SQLException e) {
                log.warn("Unable to clean up peer_records tables", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            log.error("Unable to complete scheduled tasks", throwable);
        }
    }

    @Override
    public void onDisable() {
        this.diskWriteCache.invalidateAll();
        this.flush();
        this.taskWriteService.shutdown();
        try {
            if (!this.taskWriteService.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.taskWriteService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

