/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.body.LoginRequestBody;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.SharedObject;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.exception.IPAddressBannedException;
import com.ghostchu.peerbanhelper.web.exception.NeedInitException;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.HttpStatus;
import io.javalin.security.RouteRole;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PBHAuthenticateController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHAuthenticateController.class);
    @Autowired
    private JavalinWebContainer webContainer;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Authenticate";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-authenticate";
    }

    @Override
    public void onEnable() {
        ((Javalin)this.webContainer.javalin().post("/api/auth/login", this::handleLogin, new RouteRole[]{Role.ANYONE})).post("/api/auth/logout", this::handleLogout, new RouteRole[]{Role.ANYONE});
    }

    private void handleLogout(Context ctx) {
        ctx.sessionAttribute("authenticated", null);
        ctx.json((Object)new StdResp(true, "success", null));
    }

    private void handleLogin(Context ctx) throws NeedInitException, IPAddressBannedException {
        if (this.webContainer.getToken() == null || this.webContainer.getToken().isBlank()) {
            throw new NeedInitException();
        }
        if (!this.webContainer.allowAttemptLogin(this.userIp(ctx), ctx.userAgent())) {
            throw new IPAddressBannedException();
        }
        if (!ExternalSwitch.parseBoolean("pbh.web.requireLogin", true)) {
            this.webContainer.markLoginSuccess(this.userIp(ctx), ctx.userAgent(), false);
            ctx.sessionAttribute("authenticated", (Object)this.webContainer.getToken());
            ctx.json((Object)new StdResp(true, "DEBUG: Skipping WebUI login", null));
            return;
        }
        LoginRequestBody loginRequestBody = (LoginRequestBody)ctx.bodyAsClass(LoginRequestBody.class);
        if (loginRequestBody == null) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.WEBAPI_AUTH_INVALID_TOKEN, new Object[0]), null));
            return;
        }
        if ("".equalsIgnoreCase(loginRequestBody.getToken())) {
            ctx.status(HttpStatus.UNAUTHORIZED);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.WEBAPI_AUTH_INVALID_TOKEN, new Object[0]), null));
            return;
        }
        if (!this.webContainer.getToken().equals(loginRequestBody.getToken())) {
            ctx.status(HttpStatus.UNAUTHORIZED);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.WEBAPI_AUTH_INVALID_TOKEN, new Object[0]), null));
            this.webContainer.markLoginFailed(this.userIp(ctx), ctx.userAgent());
            return;
        }
        String silentLoginSecret = ctx.queryParam("silentLogin");
        this.webContainer.markLoginSuccess(this.userIp(ctx), ctx.userAgent(), SharedObject.SILENT_LOGIN_TOKEN_FOR_GUI.equals(silentLoginSecret));
        ctx.sessionAttribute("authenticated", (Object)this.webContainer.getToken());
        ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.WEBAPI_AUTH_OK, new Object[0]), null));
    }

    @Override
    public void onDisable() {
    }
}

