/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.database.table.PeerNameRuleSubInfoEntity;
import com.ghostchu.peerbanhelper.database.table.RuleSubInfoEntity;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.IPBanRuleUpdateType;
import com.ghostchu.peerbanhelper.module.ModuleManagerImpl;
import com.ghostchu.peerbanhelper.module.impl.rule.IPBlackRuleList;
import com.ghostchu.peerbanhelper.module.impl.rule.PeerNameBlackRuleList;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.SubInfoDTO;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.HttpStatus;
import io.javalin.security.RouteRole;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class RuleSubController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleSubController.class);
    private static final String TYPE_IP = "ip";
    private static final String TYPE_PEER_NAME = "peer-name";
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private ModuleManagerImpl moduleManager;
    private IPBlackRuleList ipBlackRuleList;
    private PeerNameBlackRuleList peerNameBlackRuleList;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Rule Subscription";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-rule-subscription";
    }

    @Override
    public void onEnable() {
        this.moduleManager.getModules().stream().filter(ele -> ele.getConfigName().equals("ip-address-blocker-rules")).findFirst().ifPresent(ele -> {
            this.ipBlackRuleList = (IPBlackRuleList)ele;
        });
        this.moduleManager.getModules().stream().filter(ele -> ele.getConfigName().equals("peer-name-blocker-rules")).findFirst().ifPresent(ele -> {
            this.peerNameBlackRuleList = (PeerNameBlackRuleList)ele;
        });
        ((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)this.webContainer.javalin().get("/api/sub/interval", this::getCheckInterval, new RouteRole[]{Role.USER_READ})).patch("/api/sub/interval", this::changeCheckInterval, new RouteRole[]{Role.USER_WRITE})).put("/api/sub/rule", ctx -> this.save(ctx, null, true), new RouteRole[]{Role.USER_WRITE})).post("/api/sub/rule/{ruleId}/update", ctx -> ctx.json((Object)this.update(ctx, ctx.pathParam("ruleId"))), new RouteRole[]{Role.USER_WRITE})).get("/api/sub/rule/{ruleId}", ctx -> ctx.json((Object)this.get(ctx, ctx.pathParam("ruleId"))), new RouteRole[]{Role.USER_READ})).post("/api/sub/rule/{ruleId}", ctx -> this.save(ctx, ctx.pathParam("ruleId"), false), new RouteRole[]{Role.USER_WRITE})).delete("/api/sub/rule/{ruleId}", this::delete, new RouteRole[]{Role.USER_WRITE})).patch("/api/sub/rule/{ruleId}", this::switcher, new RouteRole[]{Role.USER_WRITE})).get("/api/sub/rules", ctx -> ctx.json((Object)this.list(ctx)), new RouteRole[]{Role.USER_READ})).post("/api/sub/rules/update", ctx -> ctx.json((Object)this.updateAll(ctx)), new RouteRole[]{Role.USER_WRITE})).get("/api/sub/logs", ctx -> this.logs(ctx, null), new RouteRole[]{Role.USER_READ})).get("/api/sub/logs/{ruleId}", ctx -> this.logs(ctx, ctx.pathParam("ruleId")), new RouteRole[]{Role.USER_READ});
    }

    @Override
    public void onDisable() {
    }

    private String getType(Context ctx) {
        return ctx.queryParam("type") != null ? ctx.queryParam("type") : TYPE_IP;
    }

    private boolean isValidType(String type) {
        return TYPE_IP.equals(type) || TYPE_PEER_NAME.equals(type);
    }

    private boolean isModuleAvailable(String type) {
        if (TYPE_IP.equals(type)) {
            return this.ipBlackRuleList != null;
        }
        if (TYPE_PEER_NAME.equals(type)) {
            return this.peerNameBlackRuleList != null;
        }
        return false;
    }

    private void moduleNotAvailable(Context ctx, String type) {
        ctx.status(HttpStatus.BAD_REQUEST);
        ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.RULE_SUB_API_INTERNAL_ERROR, "Module for type '" + type + "' is not available"), null));
    }

    private void getCheckInterval(Context ctx) {
        String type = this.getType(ctx);
        if (!this.isValidType(type)) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, "Invalid type parameter. Use 'ip' or 'peer-name'", null));
            return;
        }
        if (!this.isModuleAvailable(type)) {
            this.moduleNotAvailable(ctx, type);
            return;
        }
        if (TYPE_IP.equals(type)) {
            ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.IP_BAN_RULE_CHECK_INTERVAL_QUERY_SUCCESS, new Object[0]), this.ipBlackRuleList.getCheckInterval()));
        } else {
            ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.PEER_NAME_RULE_CHECK_INTERVAL_QUERY_SUCCESS, new Object[0]), this.peerNameBlackRuleList.getCheckInterval()));
        }
    }

    private void changeCheckInterval(Context ctx) {
        String type = this.getType(ctx);
        if (!this.isValidType(type)) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, "Invalid type parameter. Use 'ip' or 'peer-name'", null));
            return;
        }
        if (!this.isModuleAvailable(type)) {
            this.moduleNotAvailable(ctx, type);
            return;
        }
        try {
            long interval = JsonUtil.readObject(ctx.body()).get("checkInterval").getAsLong();
            if (TYPE_IP.equals(type)) {
                this.ipBlackRuleList.changeCheckInterval(interval);
                ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.IP_BAN_RULE_CHECK_INTERVAL_UPDATED, new Object[0]), null));
            } else {
                this.peerNameBlackRuleList.changeCheckInterval(interval);
                ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.PEER_NAME_RULE_CHECK_INTERVAL_UPDATED, new Object[0]), null));
            }
        }
        catch (Exception e) {
            ctx.status(HttpStatus.BAD_REQUEST);
            if (TYPE_IP.equals(type)) {
                ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.IP_BAN_RULE_CHECK_INTERVAL_WRONG_PARAM, new Object[0]), null));
            }
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PEER_NAME_RULE_CHECK_INTERVAL_WRONG_PARAM, new Object[0]), null));
        }
    }

    private void logs(Context ctx, String ruleId) {
        String type = this.getType(ctx);
        if (!this.isValidType(type)) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, "Invalid type parameter. Use 'ip' or 'peer-name'", null));
            return;
        }
        if (!this.isModuleAvailable(type)) {
            this.moduleNotAvailable(ctx, type);
            return;
        }
        try {
            Pageable pageable = new Pageable(ctx);
            if (TYPE_IP.equals(type)) {
                ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.IP_BAN_RULE_LOG_QUERY_SUCCESS, new Object[0]), this.ipBlackRuleList.queryRuleSubLogs(ruleId, pageable)));
            } else {
                ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.PEER_NAME_RULE_LOG_QUERY_SUCCESS, new Object[0]), this.peerNameBlackRuleList.queryRuleSubLogs(ruleId, pageable)));
            }
        }
        catch (Exception e) {
            ctx.status(HttpStatus.BAD_REQUEST);
            if (TYPE_IP.equals(type)) {
                log.error(TextManager.tlUI(Lang.IP_BAN_RULE_LOG_QUERY_ERROR, new Object[0]), (Throwable)e);
                ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.IP_BAN_RULE_LOG_QUERY_WRONG_PARAM, new Object[0]), null));
            }
            log.error(TextManager.tlUI(Lang.PEER_NAME_RULE_LOG_QUERY_ERROR, new Object[0]), (Throwable)e);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PEER_NAME_RULE_LOG_QUERY_WRONG_PARAM, new Object[0]), null));
        }
    }

    private StdResp updateAll(Context ctx) {
        String type = this.getType(ctx);
        String locale = this.locale(ctx);
        if (!this.isValidType(type)) {
            return new StdResp(false, "Invalid type parameter. Use 'ip' or 'peer-name'", null);
        }
        if (!this.isModuleAvailable(type)) {
            return new StdResp(false, TextManager.tl(locale, Lang.RULE_SUB_API_INTERNAL_ERROR, "Module for type '" + type + "' is not available"), null);
        }
        AtomicReference result = new AtomicReference();
        if (TYPE_IP.equals(type)) {
            this.ipBlackRuleList.getRuleSubsConfig().getKeys(false).stream().map(k -> this.updateIpRule(locale, (String)k)).filter(ele -> !ele.isSuccess()).findFirst().ifPresentOrElse(result::set, () -> result.set(new StdResp(true, TextManager.tl(locale, Lang.IP_BAN_RULE_ALL_UPDATED, new Object[0]), null)));
        } else {
            this.peerNameBlackRuleList.getRuleSubsConfig().getKeys(false).stream().map(k -> this.updatePeerNameRule(locale, (String)k)).filter(ele -> !ele.isSuccess()).findFirst().ifPresentOrElse(result::set, () -> result.set(new StdResp(true, TextManager.tl(locale, Lang.PEER_NAME_RULE_ALL_UPDATED, new Object[0]), null)));
        }
        return (StdResp)result.get();
    }

    private StdResp update(Context ctx, String ruleId) {
        String type = this.getType(ctx);
        String locale = this.locale(ctx);
        if (!this.isValidType(type)) {
            return new StdResp(false, "Invalid type parameter. Use 'ip' or 'peer-name'", null);
        }
        if (!this.isModuleAvailable(type)) {
            return new StdResp(false, TextManager.tl(locale, Lang.RULE_SUB_API_INTERNAL_ERROR, "Module for type '" + type + "' is not available"), null);
        }
        if (TYPE_IP.equals(type)) {
            return this.updateIpRule(locale, ruleId);
        }
        return this.updatePeerNameRule(locale, ruleId);
    }

    private StdResp updateIpRule(String locale, String ruleId) {
        if (ruleId == null || ruleId.isEmpty()) {
            return new StdResp(false, TextManager.tlUI(Lang.IP_BAN_RULE_NO_ID, new Object[0]), null);
        }
        ConfigurationSection configurationSection = this.ipBlackRuleList.getRuleSubsConfig().getConfigurationSection(ruleId);
        if (null == configurationSection) {
            return new StdResp(false, TextManager.tlUI(Lang.IP_BAN_RULE_CANT_FIND, ruleId), null);
        }
        return this.ipBlackRuleList.updateRule(locale, configurationSection, IPBanRuleUpdateType.MANUAL);
    }

    private StdResp updatePeerNameRule(String locale, String ruleId) {
        if (ruleId == null || ruleId.isEmpty()) {
            return new StdResp(false, TextManager.tlUI(Lang.PEER_NAME_RULE_NO_ID, new Object[0]), null);
        }
        ConfigurationSection configurationSection = this.peerNameBlackRuleList.getRuleSubsConfig().getConfigurationSection(ruleId);
        if (null == configurationSection) {
            return new StdResp(false, TextManager.tlUI(Lang.PEER_NAME_RULE_CANT_FIND, ruleId), null);
        }
        return this.peerNameBlackRuleList.updateRule(locale, configurationSection, IPBanRuleUpdateType.MANUAL);
    }

    private void switcher(Context ctx) throws SQLException, IOException {
        boolean enabled;
        String type = this.getType(ctx);
        if (!this.isValidType(type)) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, "Invalid type parameter. Use 'ip' or 'peer-name'", null));
            return;
        }
        if (!this.isModuleAvailable(type)) {
            this.moduleNotAvailable(ctx, type);
            return;
        }
        String ruleId = ctx.pathParam("ruleId");
        try {
            enabled = JsonUtil.readObject(ctx.body()).get("enabled").getAsBoolean();
        }
        catch (Exception e) {
            ctx.status(HttpStatus.BAD_REQUEST);
            if (TYPE_IP.equals(type)) {
                ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.IP_BAN_RULE_ENABLED_WRONG_PARAM, new Object[0]), null));
            } else {
                ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PEER_NAME_RULE_ENABLED_WRONG_PARAM, new Object[0]), null));
            }
            return;
        }
        if (TYPE_IP.equals(type)) {
            this.switchIpRule(ctx, ruleId, enabled);
        } else {
            this.switchPeerNameRule(ctx, ruleId, enabled);
        }
    }

    private void switchIpRule(Context ctx, String ruleId, boolean enabled) throws SQLException, IOException {
        RuleSubInfoEntity ruleSubInfo = this.ipBlackRuleList.getRuleSubInfo(ruleId);
        if (null == ruleSubInfo) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.IP_BAN_RULE_CANT_FIND, ruleId), null));
            return;
        }
        String msg = TextManager.tl(this.locale(ctx), enabled ? Lang.IP_BAN_RULE_ENABLED : Lang.IP_BAN_RULE_DISABLED, ruleSubInfo.getRuleName());
        if (enabled != ruleSubInfo.isEnabled()) {
            ConfigurationSection configurationSection = this.ipBlackRuleList.saveRuleSubInfo(new RuleSubInfoEntity(ruleId, enabled, ruleSubInfo.getRuleName(), ruleSubInfo.getSubUrl(), 0L, 0));
            this.ipBlackRuleList.updateRule(this.locale(ctx), configurationSection, IPBanRuleUpdateType.MANUAL);
            log.info(msg);
            ctx.json((Object)new StdResp(true, msg, null));
        } else {
            ctx.json((Object)new StdResp(false, msg, null));
        }
    }

    private void switchPeerNameRule(Context ctx, String ruleId, boolean enabled) throws SQLException, IOException {
        PeerNameRuleSubInfoEntity ruleSubInfo = this.peerNameBlackRuleList.getRuleSubInfo(ruleId);
        if (null == ruleSubInfo) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PEER_NAME_RULE_CANT_FIND, ruleId), null));
            return;
        }
        String msg = TextManager.tl(this.locale(ctx), enabled ? Lang.PEER_NAME_RULE_ENABLED : Lang.PEER_NAME_RULE_DISABLED, ruleSubInfo.getRuleName());
        if (enabled != ruleSubInfo.isEnabled()) {
            ConfigurationSection configurationSection = this.peerNameBlackRuleList.saveRuleSubInfo(new PeerNameRuleSubInfoEntity(ruleId, enabled, ruleSubInfo.getRuleName(), ruleSubInfo.getSubUrl(), 0L, 0));
            this.peerNameBlackRuleList.updateRule(this.locale(ctx), configurationSection, IPBanRuleUpdateType.MANUAL);
            log.info(msg);
            ctx.json((Object)new StdResp(true, msg, null));
        } else {
            ctx.json((Object)new StdResp(false, msg, null));
        }
    }

    private void delete(Context ctx) throws IOException, SQLException {
        String type = this.getType(ctx);
        if (!this.isValidType(type)) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, "Invalid type parameter. Use 'ip' or 'peer-name'", null));
            return;
        }
        if (!this.isModuleAvailable(type)) {
            this.moduleNotAvailable(ctx, type);
            return;
        }
        String ruleId = ctx.pathParam("ruleId");
        if (TYPE_IP.equals(type)) {
            this.deleteIpRule(ctx, ruleId);
        } else {
            this.deletePeerNameRule(ctx, ruleId);
        }
    }

    private void deleteIpRule(Context ctx, String ruleId) throws IOException, SQLException {
        RuleSubInfoEntity ruleSubInfo = this.ipBlackRuleList.getRuleSubInfo(ruleId);
        if (null == ruleSubInfo) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.IP_BAN_RULE_CANT_FIND, ruleId), null));
            return;
        }
        this.ipBlackRuleList.deleteRuleSubInfo(ruleId);
        this.ipBlackRuleList.getIpBanMatchers().removeIf(ele -> ele.getRuleId().equals(ruleId));
        String msg = TextManager.tl(this.locale(ctx), Lang.IP_BAN_RULE_DELETED, ruleSubInfo.getRuleName());
        log.info(msg);
        ctx.json((Object)new StdResp(true, msg, null));
    }

    private void deletePeerNameRule(Context ctx, String ruleId) throws IOException, SQLException {
        PeerNameRuleSubInfoEntity ruleSubInfo = this.peerNameBlackRuleList.getRuleSubInfo(ruleId);
        if (null == ruleSubInfo) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PEER_NAME_RULE_CANT_FIND, ruleId), null));
            return;
        }
        this.peerNameBlackRuleList.deleteRuleSubInfo(ruleId);
        this.peerNameBlackRuleList.getPeerNameMatchers().removeIf(ele -> ele.getRuleId().equals(ruleId));
        String msg = TextManager.tl(this.locale(ctx), Lang.PEER_NAME_RULE_DELETED, ruleSubInfo.getRuleName());
        log.info(msg);
        ctx.json((Object)new StdResp(true, msg, null));
    }

    private void save(Context ctx, String ruleId, boolean isAdd) throws SQLException, IOException {
        String type = this.getType(ctx);
        if (!this.isValidType(type)) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, "Invalid type parameter. Use 'ip' or 'peer-name'", null));
            return;
        }
        if (!this.isModuleAvailable(type)) {
            this.moduleNotAvailable(ctx, type);
            return;
        }
        if (TYPE_IP.equals(type)) {
            this.saveIpRule(ctx, ruleId, isAdd);
        } else {
            this.savePeerNameRule(ctx, ruleId, isAdd);
        }
    }

    private void saveIpRule(Context ctx, String ruleId, boolean isAdd) throws SQLException, IOException {
        SubInfoDTO subInfoDTO = (SubInfoDTO)ctx.bodyValidator(SubInfoDTO.class).get();
        if (isAdd) {
            ruleId = subInfoDTO.ruleId();
        }
        if (ruleId == null || ruleId.isEmpty()) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.IP_BAN_RULE_NO_ID, new Object[0]), null));
            return;
        }
        RuleSubInfoEntity ruleSubInfo = this.ipBlackRuleList.getRuleSubInfo(ruleId);
        if (isAdd && ruleSubInfo != null) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.IP_BAN_RULE_ID_CONFLICT, ruleId), null));
            return;
        }
        if (!isAdd && ruleSubInfo == null) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.IP_BAN_RULE_CANT_FIND, ruleId), null));
            return;
        }
        String ruleName = subInfoDTO.ruleName();
        String subUrl = subInfoDTO.subUrl();
        if (isAdd) {
            if (ruleName == null || subUrl == null || ruleName.isEmpty() || subUrl.isEmpty()) {
                ctx.status(HttpStatus.BAD_REQUEST);
                ctx.json((Object)new StdResp(false, TextManager.tlUI(Lang.IP_BAN_RULE_PARAM_WRONG, new Object[0]), null));
                return;
            }
        } else {
            if (ruleName == null) {
                ruleName = ruleSubInfo.getRuleName();
            }
            if (subUrl == null) {
                subUrl = ruleSubInfo.getSubUrl();
            }
        }
        if (ruleName.contains(".")) {
            throw new IllegalArgumentException("Illegal character (.) in name: " + ruleName);
        }
        ConfigurationSection configurationSection = this.ipBlackRuleList.saveRuleSubInfo(new RuleSubInfoEntity(ruleId, isAdd || ruleSubInfo.isEnabled(), ruleName, subUrl, 0L, 0));
        assert (configurationSection != null);
        try {
            StdResp msg = this.ipBlackRuleList.updateRule(this.locale(ctx), configurationSection, IPBanRuleUpdateType.MANUAL);
            if (!msg.isSuccess()) {
                ctx.status(HttpStatus.BAD_REQUEST);
                ctx.json((Object)msg);
                return;
            }
            ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.IP_BAN_RULE_SAVED, new Object[0]), null));
        }
        catch (Exception e) {
            if (isAdd) {
                this.ipBlackRuleList.deleteRuleSubInfo(ruleId);
            } else {
                this.ipBlackRuleList.saveRuleSubInfo(ruleSubInfo);
            }
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.IP_BAN_RULE_URL_WRONG, ruleName), null));
            log.error("Unable to retrieve the sub from given URL", (Throwable)e);
        }
    }

    private void savePeerNameRule(Context ctx, String ruleId, boolean isAdd) throws SQLException, IOException {
        SubInfoDTO subInfoDTO = (SubInfoDTO)ctx.bodyValidator(SubInfoDTO.class).get();
        if (isAdd) {
            ruleId = subInfoDTO.ruleId();
        }
        if (ruleId == null || ruleId.isEmpty()) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PEER_NAME_RULE_NO_ID, new Object[0]), null));
            return;
        }
        PeerNameRuleSubInfoEntity ruleSubInfo = this.peerNameBlackRuleList.getRuleSubInfo(ruleId);
        if (isAdd && ruleSubInfo != null) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PEER_NAME_RULE_ID_CONFLICT, ruleId), null));
            return;
        }
        if (!isAdd && ruleSubInfo == null) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PEER_NAME_RULE_CANT_FIND, ruleId), null));
            return;
        }
        String ruleName = subInfoDTO.ruleName();
        String subUrl = subInfoDTO.subUrl();
        if (isAdd) {
            if (ruleName == null || subUrl == null || ruleName.isEmpty() || subUrl.isEmpty()) {
                ctx.status(HttpStatus.BAD_REQUEST);
                ctx.json((Object)new StdResp(false, TextManager.tlUI(Lang.PEER_NAME_RULE_PARAM_WRONG, new Object[0]), null));
                return;
            }
        } else {
            if (ruleName == null) {
                ruleName = ruleSubInfo.getRuleName();
            }
            if (subUrl == null) {
                subUrl = ruleSubInfo.getSubUrl();
            }
        }
        if (ruleName.contains(".")) {
            throw new IllegalArgumentException("Illegal character (.) in name: " + ruleName);
        }
        ConfigurationSection configurationSection = this.peerNameBlackRuleList.saveRuleSubInfo(new PeerNameRuleSubInfoEntity(ruleId, isAdd || ruleSubInfo.isEnabled(), ruleName, subUrl, 0L, 0));
        assert (configurationSection != null);
        try {
            StdResp msg = this.peerNameBlackRuleList.updateRule(this.locale(ctx), configurationSection, IPBanRuleUpdateType.MANUAL);
            if (!msg.isSuccess()) {
                ctx.status(HttpStatus.BAD_REQUEST);
                ctx.json((Object)msg);
                return;
            }
            ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.PEER_NAME_RULE_SAVED, new Object[0]), null));
        }
        catch (Exception e) {
            if (isAdd) {
                this.peerNameBlackRuleList.deleteRuleSubInfo(ruleId);
            } else {
                this.peerNameBlackRuleList.saveRuleSubInfo(ruleSubInfo);
            }
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PEER_NAME_RULE_URL_WRONG, ruleName), null));
            log.error("Unable to retrieve the sub from given URL", (Throwable)e);
        }
    }

    private StdResp get(Context ctx, String ruleId) throws SQLException {
        String type = this.getType(ctx);
        String locale = this.locale(ctx);
        if (!this.isValidType(type)) {
            return new StdResp(false, "Invalid type parameter. Use 'ip' or 'peer-name'", null);
        }
        if (!this.isModuleAvailable(type)) {
            return new StdResp(false, TextManager.tl(locale, Lang.RULE_SUB_API_INTERNAL_ERROR, "Module for type '" + type + "' is not available"), null);
        }
        if (TYPE_IP.equals(type)) {
            return new StdResp(true, TextManager.tl(locale, Lang.IP_BAN_RULE_INFO_QUERY_SUCCESS, new Object[0]), this.ipBlackRuleList.getRuleSubInfo(ruleId));
        }
        return new StdResp(true, TextManager.tl(locale, Lang.PEER_NAME_RULE_INFO_QUERY_SUCCESS, new Object[0]), this.peerNameBlackRuleList.getRuleSubInfo(ruleId));
    }

    private StdResp list(Context ctx) throws SQLException {
        String type = this.getType(ctx);
        String locale = this.locale(ctx);
        if (!this.isValidType(type)) {
            return new StdResp(false, "Invalid type parameter. Use 'ip' or 'peer-name'", null);
        }
        if (!this.isModuleAvailable(type)) {
            return new StdResp(false, TextManager.tl(locale, Lang.RULE_SUB_API_INTERNAL_ERROR, "Module for type '" + type + "' is not available"), null);
        }
        if (TYPE_IP.equals(type)) {
            List keys = this.ipBlackRuleList.getRuleSubsConfig().getKeys(false).stream().toList();
            ArrayList<RuleSubInfoEntity> data = new ArrayList<RuleSubInfoEntity>(keys.size());
            for (String s : keys) {
                data.add(this.ipBlackRuleList.getRuleSubInfo(s));
            }
            return new StdResp(true, TextManager.tl(locale, Lang.IP_BAN_RULE_INFO_QUERY_SUCCESS, new Object[0]), data);
        }
        List keys = this.peerNameBlackRuleList.getRuleSubsConfig().getKeys(false).stream().toList();
        ArrayList<PeerNameRuleSubInfoEntity> data = new ArrayList<PeerNameRuleSubInfoEntity>(keys.size());
        for (String s : keys) {
            data.add(this.peerNameBlackRuleList.getRuleSubInfo(s));
        }
        return new StdResp(true, TextManager.tl(locale, Lang.PEER_NAME_RULE_INFO_QUERY_SUCCESS, new Object[0]), data);
    }
}

