/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.pbhplus.validator;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.pbhplus.bean.License;
import com.ghostchu.peerbanhelper.pbhplus.validator.LicenseRevokeValidator;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.google.common.hash.Hashing;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServerRevokeValidator
implements LicenseRevokeValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerRevokeValidator.class);
    private final HTTPUtil httpUtil;
    private final File cacheDirectory;
    private static final long CACHE_DURATION_HOURS = 24L;

    public ServerRevokeValidator(HTTPUtil httpUtil) {
        this.httpUtil = httpUtil;
        File rootCacheDirectory = new File(Main.getDataDirectory(), "cache");
        this.cacheDirectory = new File(rootCacheDirectory, "license-revoke");
        this.cacheDirectory.mkdirs();
    }

    @Override
    public Collection<License> checkRevoked(@NotNull Collection<License> licenses) {
        ArrayList<License> revoked = new ArrayList<License>();
        OkHttpClient httpClient = this.httpUtil.newBuilder().callTimeout(15L, TimeUnit.SECONDS).build();
        for (License license : licenses) {
            if (!this.checkRevoked(httpClient, license)) continue;
            revoked.add(license);
        }
        return revoked;
    }

    private boolean checkRevoked(OkHttpClient httpClient, License license) {
        String licenseHash = this.generateLicenseHash(license);
        CacheEntry cachedResult = this.getCachedResult(licenseHash);
        if (cachedResult != null && !this.isCacheExpired(cachedResult.getTimestamp())) {
            log.debug("Using cached result for license {}: {}", (Object)license.getLicenseTo(), (Object)cachedResult.isRevoked());
            return cachedResult.isRevoked();
        }
        boolean revoked = this.performRevokeCheck(httpClient, license);
        this.cacheResult(licenseHash, revoked);
        return revoked;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean performRevokeCheck(OkHttpClient httpClient, License license) {
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme("https").host("api.pbh-btn.com").addPathSegment("peerbanhelper").addPathSegment("v1").addPathSegment("licenses").addPathSegment("checkRevoke");
        if (license.getLicenseTo() != null) {
            urlBuilder.addQueryParameter("licenseToHash", this.hash(license.getLicenseTo()));
        }
        if (license.getDescription() != null) {
            urlBuilder.addQueryParameter("descriptionHash", this.hash(license.getDescription()));
        }
        if (license.getOrderId() != null) {
            urlBuilder.addQueryParameter("orderIdHash", this.hash(license.getOrderId()));
        }
        if (license.getPaymentOrderId() != null) {
            urlBuilder.addQueryParameter("paymentOrderIdHash", this.hash(license.getPaymentOrderId()));
        }
        if (license.getEmail() != null) {
            urlBuilder.addQueryParameter("emailHash", this.hash(license.getEmail()));
        }
        Request request = new Request.Builder().url(urlBuilder.build()).get().build();
        try (Response response = httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.debug("Failed to check license revoke for {}: http code: {}, body: {}", new Object[]{license.getLicenseTo(), response.code(), response.body()});
                boolean bl = false;
                return bl;
            }
            if (response.code() == 204) {
                log.debug("License {} is not revoked", (Object)license.getLicenseTo());
                boolean bl = false;
                return bl;
            }
            CheckResult result = (CheckResult)JsonUtil.standard().fromJson(response.body().charStream(), CheckResult.class);
            boolean bl = result.isRevoked();
            return bl;
        }
        catch (Exception e) {
            log.debug("Failed to check license revoke for {}: {}", (Object)license.getLicenseTo(), (Object)e.getMessage());
            return false;
        }
    }

    private String hash(String value) {
        if (value == null) {
            return null;
        }
        return Hashing.sha256().hashString((CharSequence)value, StandardCharsets.UTF_8).toString();
    }

    private String generateLicenseHash(License license) {
        StringBuilder sb = new StringBuilder();
        if (license.getLicenseTo() != null) {
            sb.append(license.getLicenseTo());
        }
        if (license.getDescription() != null) {
            sb.append(license.getDescription());
        }
        if (license.getOrderId() != null) {
            sb.append(license.getOrderId());
        }
        if (license.getPaymentOrderId() != null) {
            sb.append(license.getPaymentOrderId());
        }
        if (license.getEmail() != null) {
            sb.append(license.getEmail());
        }
        return Hashing.sha256().hashString((CharSequence)sb.toString(), StandardCharsets.UTF_8).toString();
    }

    private CacheEntry getCachedResult(String licenseHash) {
        File cacheFile = new File(this.cacheDirectory, licenseHash + ".json");
        if (!cacheFile.exists()) {
            return null;
        }
        try {
            String content = Files.readString(cacheFile.toPath(), StandardCharsets.UTF_8);
            return (CacheEntry)JsonUtil.standard().fromJson(content, CacheEntry.class);
        }
        catch (Exception e) {
            log.debug("Failed to read cache file {}: {}", (Object)cacheFile, (Object)e.getMessage());
            return null;
        }
    }

    private void cacheResult(String licenseHash, boolean revoked) {
        File cacheFile = new File(this.cacheDirectory, licenseHash + ".json");
        CacheEntry entry = new CacheEntry(revoked, Instant.now().toEpochMilli());
        try {
            String content = JsonUtil.standard().toJson((Object)entry);
            Files.writeString(cacheFile.toPath(), (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
            log.debug("Cached result for license hash {}: {}", (Object)licenseHash, (Object)revoked);
        }
        catch (Exception e) {
            log.debug("Failed to cache result for license hash {}: {}", (Object)licenseHash, (Object)e.getMessage());
        }
    }

    private boolean isCacheExpired(long timestamp) {
        long maxAge;
        long now = Instant.now().toEpochMilli();
        long cacheAge = now - timestamp;
        return cacheAge > (maxAge = 86400000L);
    }

    public static class CacheEntry {
        private boolean revoked;
        private long timestamp;

        @Generated
        public CacheEntry(boolean revoked, long timestamp) {
            this.revoked = revoked;
            this.timestamp = timestamp;
        }

        @Generated
        public CacheEntry() {
        }

        @Generated
        public boolean isRevoked() {
            return this.revoked;
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public void setRevoked(boolean revoked) {
            this.revoked = revoked;
        }

        @Generated
        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheEntry)) {
                return false;
            }
            CacheEntry other = (CacheEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRevoked() != other.isRevoked()) {
                return false;
            }
            return this.getTimestamp() == other.getTimestamp();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CacheEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRevoked() ? 79 : 97);
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            return result;
        }

        @Generated
        public String toString() {
            return "ServerRevokeValidator.CacheEntry(revoked=" + this.isRevoked() + ", timestamp=" + this.getTimestamp() + ")";
        }
    }

    public static class CheckResult {
        private boolean revoked;

        @Generated
        public CheckResult(boolean revoked) {
            this.revoked = revoked;
        }

        @Generated
        public CheckResult() {
        }

        @Generated
        public boolean isRevoked() {
            return this.revoked;
        }

        @Generated
        public void setRevoked(boolean revoked) {
            this.revoked = revoked;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CheckResult)) {
                return false;
            }
            CheckResult other = (CheckResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isRevoked() == other.isRevoked();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CheckResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRevoked() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "ServerRevokeValidator.CheckResult(revoked=" + this.isRevoked() + ")";
        }
    }
}

