/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.text;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.LanguageFilesManagerImpl;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.text.postprocessor.PostProcessor;
import com.ghostchu.peerbanhelper.text.postprocessor.impl.FillerProcessor;
import com.ghostchu.peerbanhelper.util.URLUtil;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.InvalidConfigurationException;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class TextManager
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextManager.class);
    public static final TextManager INSTANCE_HOLDER = new TextManager();
    public final Set<PostProcessor> postProcessors = new LinkedHashSet<PostProcessor>();
    private final LanguageFilesManagerImpl languageFilesManager = new LanguageFilesManagerImpl();
    private final Set<String> availableLanguages = new LinkedHashSet<String>();
    private final Set<String> loadedLanguages = ConcurrentHashMap.newKeySet();
    private final File langDirectory = new File(Main.getDataDirectory(), "lang");
    private final File overrideDirectory = new File(this.langDirectory, "overrides");
    private final YamlConfiguration fallbackConfig;

    public TextManager() {
        if (!this.langDirectory.exists()) {
            this.langDirectory.mkdirs();
        }
        if (!this.overrideDirectory.exists()) {
            this.overrideDirectory.mkdirs();
        }
        this.fallbackConfig = this.loadBuiltInFallback();
        this.initializeBasic();
        Main.getReloadManager().register((Reloadable)this);
    }

    private void initializeBasic() {
        log.info("Initializing translation system...");
        this.reset();
        this.scanAvailableLanguages();
        this.postProcessors.add(new FillerProcessor());
        log.info("Translation system initialized with {} available languages: {}", (Object)this.availableLanguages.size(), this.availableLanguages);
    }

    private void scanAvailableLanguages() {
        try {
            Resource[] resources;
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver(Main.class.getClassLoader());
            Resource[] resourceArray = resources = resourcePatternResolver.getResources("classpath:lang/**/*.yml");
            int n = resourceArray.length;
            for (int i = 0; i < n; ++i) {
                Resource res = resourceArray[i];
                String langName = URLUtil.getParentName(res.getURI());
                this.availableLanguages.add(langName.toLowerCase(Locale.ROOT));
            }
        }
        catch (IOException e) {
            log.warn("Failed to scan bundled translations", (Throwable)e);
        }
        File[] files = this.overrideDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                this.availableLanguages.add(file.getName().toLowerCase(Locale.ROOT));
            }
        }
    }

    public synchronized boolean loadLanguage(String locale) {
        if (this.loadedLanguages.contains(locale = locale.toLowerCase(Locale.ROOT).replace("-", "_"))) {
            return true;
        }
        boolean loaded = false;
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(Main.class.getClassLoader());
            Resource[] resources = resolver.getResources("classpath:lang/" + locale + "/*.yml");
            for (Resource res : resources) {
                try {
                    YamlConfiguration config = new YamlConfiguration();
                    config.loadFromString(new String(res.getContentAsByteArray(), StandardCharsets.UTF_8));
                    this.languageFilesManager.deploy(locale, config);
                    loaded = true;
                }
                catch (IOException | InvalidConfigurationException e) {
                    log.warn("Failed to load bundled translation for {}", (Object)locale, (Object)e);
                }
            }
        }
        catch (IOException e) {
            log.debug("No bundled translations found for {}", (Object)locale);
        }
        File overrideFile = this.getOverrideLocaleFile(locale);
        if (overrideFile.exists()) {
            try {
                YamlConfiguration config = new YamlConfiguration();
                config.loadFromString(Files.readString(overrideFile.toPath(), StandardCharsets.UTF_8));
                this.languageFilesManager.deploy(locale, config);
                loaded = true;
            }
            catch (IOException | InvalidConfigurationException e) {
                log.warn("Failed to load override translation for {}", (Object)locale, (Object)e);
            }
        }
        if (loaded) {
            YamlConfiguration langConfig = this.languageFilesManager.getDistribution(locale);
            if (langConfig != null) {
                for (String key : this.fallbackConfig.getKeys(true)) {
                    if (this.fallbackConfig.isConfigurationSection(key) || langConfig.isSet(key)) continue;
                    langConfig.set(key, this.fallbackConfig.get(key));
                }
                this.loadedLanguages.add(locale);
            }
        } else if (!"en_us".equals(locale)) {
            return false;
        }
        return loaded;
    }

    private void reset() {
        this.languageFilesManager.reset();
        this.postProcessors.clear();
        this.availableLanguages.clear();
        this.loadedLanguages.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private YamlConfiguration loadBuiltInFallback() {
        YamlConfiguration configuration = new YamlConfiguration();
        try (InputStream inputStream = Main.class.getResourceAsStream("/lang/messages_fallback.yml");){
            if (inputStream == null) {
                log.warn("Failed to load built-in fallback translation, fallback file not exists in jar.");
                YamlConfiguration yamlConfiguration2 = configuration;
                return yamlConfiguration2;
            }
            byte[] bytes = inputStream.readAllBytes();
            String content = new String(bytes, StandardCharsets.UTF_8);
            configuration.loadFromString(content);
            YamlConfiguration yamlConfiguration = configuration;
            return yamlConfiguration;
        }
        catch (IOException | InvalidConfigurationException e) {
            log.warn("Failed to load built-in fallback translation.", e);
            return configuration;
        }
    }

    @NotNull
    private File getOverrideLocaleFile(@NotNull String locale) {
        File file = new File(this.overrideDirectory, (locale = locale.toLowerCase(Locale.ROOT).replace("-", "_")) + ".yml");
        if (file.isDirectory()) {
            file.delete();
        }
        file = new File(this.overrideDirectory, locale);
        file = new File(file, "messages_fallback.yml");
        return file;
    }

    public ReloadResult reloadModule() throws Exception {
        this.reset();
        this.initializeBasic();
        return super.reloadModule();
    }

    public void register(@NotNull String locale, @NotNull String path, @NotNull String text) {
        YamlConfiguration configuration;
        locale = locale.toLowerCase(Locale.ROOT).replace("-", "_");
        if (!this.loadedLanguages.contains(locale)) {
            this.loadLanguage(locale);
        }
        if ((configuration = this.languageFilesManager.getDistribution(locale)) == null) {
            configuration = new YamlConfiguration();
            configuration.loadFromString(this.languageFilesManager.getDistribution("en_us").saveToString());
        }
        configuration.set(path, (Object)text);
        this.languageFilesManager.deploy(locale, configuration);
    }

    public List<String> getAvailableLanguages() {
        return new ArrayList<String>(this.availableLanguages);
    }

    public List<String> getLoadedLanguages() {
        return new ArrayList<String>(this.loadedLanguages);
    }

    public void loadAllLanguages() {
        for (String language : this.availableLanguages) {
            this.loadLanguage(language);
        }
    }

    public static String tlUI(Lang key, Object ... params) {
        return TextManager.tl(Main.DEF_LOCALE, new TranslationComponent(key.getKey(), (Object[])TextManager.convert(Main.DEF_LOCALE, params)));
    }

    public static String tlUI(TranslationComponent translationComponent) {
        return TextManager.tl(Main.DEF_LOCALE, translationComponent);
    }

    public static String tl(String locale, Lang key, Object ... params) {
        locale = locale.toLowerCase(Locale.ROOT).replace("-", "_");
        return TextManager.tl(locale, new TranslationComponent(key.getKey(), (Object[])TextManager.convert(locale, params)));
    }

    public static String tl(String locale, TranslationComponent translationComponent) {
        YamlConfiguration yamlConfiguration;
        if (!TextManager.INSTANCE_HOLDER.loadedLanguages.contains(locale = locale.toLowerCase(Locale.ROOT).replace("-", "_"))) {
            INSTANCE_HOLDER.loadLanguage(locale);
        }
        if ((yamlConfiguration = TextManager.INSTANCE_HOLDER.languageFilesManager.getDistribution(locale)) == null && (yamlConfiguration = TextManager.INSTANCE_HOLDER.languageFilesManager.getDistribution("en_us")) == null && (yamlConfiguration = INSTANCE_HOLDER.getFallbackConfig()) == null) {
            log.warn("The locale {} are not supported and fallback locale en_us load failed.", (Object)locale);
            return "Unsupported locale " + locale;
        }
        if (translationComponent == null) {
            return "null";
        }
        if (translationComponent.getKey().isBlank()) {
            return "";
        }
        String str = yamlConfiguration.getString(translationComponent.getKey());
        if (str == null) {
            str = translationComponent.getKey();
        }
        String[] params = TextManager.convert(locale, translationComponent.getParams());
        for (PostProcessor postProcessor : TextManager.INSTANCE_HOLDER.postProcessors) {
            try {
                str = postProcessor.process(str, locale, params);
            }
            catch (Exception e) {
                log.warn("Unable to process post processor: key={}, locale={}, params={}", new Object[]{translationComponent.getKey(), locale, translationComponent.getParams()});
            }
        }
        return str;
    }

    @NotNull
    static String[] convert(String locale, Object ... args) {
        if (args == null || args.length == 0) {
            return new String[0];
        }
        String[] components = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object obj = args[i];
            if (obj == null) {
                components[i] = "null";
                continue;
            }
            try {
                if (obj instanceof TranslationComponent) {
                    TranslationComponent translationComponent = (TranslationComponent)obj;
                    components[i] = TextManager.tl(locale, translationComponent);
                    continue;
                }
                components[i] = obj.toString();
                continue;
            }
            catch (Exception exception) {
                log.debug("Failed to process the object: {}", obj);
                components[i] = String.valueOf(obj);
            }
        }
        return components;
    }

    @Generated
    public YamlConfiguration getFallbackConfig() {
        return this.fallbackConfig;
    }
}

