/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MIDIPlayer
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MIDIPlayer.class);
    private final InputStream[] sequence;
    private Sequencer midip = null;
    private int currentIndex = -1;

    public MIDIPlayer(InputStream ... sequences) {
        this.sequence = sequences;
        try {
            this.midip = MidiSystem.getSequencer();
        }
        catch (MidiUnavailableException e) {
            log.error("This platform doesn't support MIDI playback", (Throwable)e);
        }
    }

    public void play() throws MidiUnavailableException {
        if (this.midip == null) {
            log.error("MIDI playback is not supported on this platform, skipping playback");
            return;
        }
        this.midip.open();
        this.midip.addMetaEventListener(meta -> {
            if (meta.getType() == 47) {
                try {
                    this.nextSequence();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.nextSequence();
    }

    public void stop() {
        if (this.midip != null && this.midip.isRunning()) {
            this.midip.stop();
        }
    }

    private void nextSequence() {
        if (this.midip.isRunning()) {
            this.midip.stop();
        }
        ++this.currentIndex;
        if (this.currentIndex < this.sequence.length) {
            try {
                Sequence sequencer = MidiSystem.getSequence(this.sequence[this.currentIndex]);
                this.midip.setSequence(sequencer);
                if (!this.midip.isRunning()) {
                    this.midip.start();
                }
            }
            catch (Exception e) {
                log.error("Failed to play MIDI sequence", (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.stop();
        for (InputStream inputStream : this.sequence) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

