/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.function.Consumer;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketCopyWorker
implements Runnable,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SocketCopyWorker.class);
    private final Socket from;
    private final Socket to;
    private final Consumer<Integer> trafficConsumer;
    private final Consumer<Exception> closeListener;
    private final Runnable trafficActivityRunnable;

    public SocketCopyWorker(Socket from, Socket to, @Nullable Consumer<Exception> connDisconnectListener, @Nullable Consumer<Integer> trafficConsumer, @Nullable Runnable onTrafficActivity) {
        this.from = from;
        this.to = to;
        this.closeListener = connDisconnectListener == null ? e -> {} : connDisconnectListener;
        this.trafficConsumer = trafficConsumer == null ? len -> {} : trafficConsumer;
        this.trafficActivityRunnable = onTrafficActivity == null ? () -> {} : onTrafficActivity;
    }

    public Thread startAsync() {
        return Thread.ofVirtual().name("SocketCopy-" + String.valueOf(this.from.getRemoteSocketAddress()) + " -> " + String.valueOf(this.to.getRemoteSocketAddress())).start(this);
    }

    public void startSync() {
        this.run();
    }

    @Override
    public void run() {
        try {
            int len;
            byte[] data = new byte[1024];
            InputStream is = this.from.getInputStream();
            OutputStream out = this.to.getOutputStream();
            while (this.from.isConnected() && !this.from.isClosed() && this.to.isConnected() && !this.to.isClosed() && (len = is.read(data)) != -1) {
                out.write(data, 0, len);
                out.flush();
                this.trafficConsumer.accept(len);
                this.trafficActivityRunnable.run();
            }
        }
        catch (IOException e) {
            this.closeConnection();
            this.closeListener.accept(e);
        }
    }

    public void closeConnection() {
        try {
            this.from.close();
        }
        catch (IOException e) {
            log.debug("Failed to close from socket: {}", (Object)this.from, (Object)e);
        }
        try {
            this.to.close();
        }
        catch (IOException e) {
            log.debug("Failed to close to socket: {}", (Object)this.to, (Object)e);
        }
    }

    @Override
    public void close() {
        this.closeConnection();
        this.closeListener.accept(null);
    }
}

