/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.asynctask.wrap;

import com.ghostchu.peerbanhelper.util.asynctask.AsyncTask;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class AsyncTaskWrappedOutputStream
extends FilterOutputStream {
    private final AsyncTask asyncTask;

    public AsyncTaskWrappedOutputStream(OutputStream out, AsyncTask asyncTask) {
        super(out);
        this.asyncTask = asyncTask;
    }

    public AsyncTask getBgTask() {
        return this.asyncTask;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.asyncTask.increment();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b, 0, b.length);
        this.asyncTask.increment(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.asyncTask.increment(len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.asyncTask.close();
    }
}

