/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.query;

import com.ghostchu.peerbanhelper.util.query.Pageable;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;

public final class Page<T> {
    private long page;
    private long size;
    private long total;
    private List<T> results;

    public Page(Pageable pageable, long total, List<T> results) {
        this.page = pageable.getPage();
        this.size = pageable.getSize();
        this.total = total;
        this.results = results;
    }

    public static <OLD, NEW> Page<NEW> map(Page<OLD> page, Function<OLD, NEW> mapper) {
        List<NEW> newResults = page.getResults().stream().map(mapper).toList();
        Page<NEW> newPage = new Page<NEW>();
        newPage.setSize(page.getSize());
        newPage.setPage(page.getPage());
        newPage.setTotal(page.getTotal());
        newPage.setResults(newResults);
        return newPage;
    }

    @Generated
    public Page(long page, long size, long total, List<T> results) {
        this.page = page;
        this.size = size;
        this.total = total;
        this.results = results;
    }

    @Generated
    public Page() {
    }

    @Generated
    public long getPage() {
        return this.page;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public long getTotal() {
        return this.total;
    }

    @Generated
    public List<T> getResults() {
        return this.results;
    }

    @Generated
    public void setPage(long page) {
        this.page = page;
    }

    @Generated
    public void setSize(long size) {
        this.size = size;
    }

    @Generated
    public void setTotal(long total) {
        this.total = total;
    }

    @Generated
    public void setResults(List<T> results) {
        this.results = results;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        List<T> this$results = this.getResults();
        List<T> other$results = other.getResults();
        return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $page = this.getPage();
        result = result * 59 + (int)($page >>> 32 ^ $page);
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        List<T> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Page(page=" + this.getPage() + ", size=" + this.getSize() + ", total=" + this.getTotal() + ", results=" + String.valueOf(this.getResults()) + ")";
    }
}

