/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.rule;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.event.btn.BtnRuleUpdateEvent;
import com.ghostchu.peerbanhelper.module.AbstractRuleFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.module.RuleFeatureModule;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.eventbus.Subscribe;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModuleMatchCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModuleMatchCache.class);
    public final Cache<String, CheckResult> CACHE_POOL = CacheBuilder.newBuilder().maximumWeight(ExternalSwitch.parseLong("pbh.moduleMatchCache.weight", 5000L)).weigher((key, value) -> {
        if (value == AbstractRuleFeatureModule.HANDSHAKING_CHECK_RESULT || value == AbstractRuleFeatureModule.TEAPOT_CHECK_RESULT || value == AbstractRuleFeatureModule.OK_CHECK_RESULT) {
            return 1;
        }
        return 5;
    }).softValues().expireAfterAccess(ExternalSwitch.parseLong("pbh.modulematchcache.timeout", 600000L), TimeUnit.MILLISECONDS).build();

    public ModuleMatchCache() {
        Main.getEventBus().register((Object)this);
    }

    public CheckResult readCache(RuleFeatureModule module, String cacheKey, Callable<CheckResult> resultSupplier, boolean writeCache) {
        String _cacheKey = module.getConfigName() + "@" + cacheKey;
        if (writeCache) {
            try {
                return (CheckResult)this.CACHE_POOL.get((Object)_cacheKey, resultSupplier);
            }
            catch (ExecutionException e) {
                log.error("Unable to get cache value from cache, the resultSupplier throws unexpected exception", (Throwable)e);
                return null;
            }
        }
        return (CheckResult)this.CACHE_POOL.getIfPresent((Object)_cacheKey);
    }

    public CheckResult readCacheButWritePassOnly(RuleFeatureModule module, String cacheKey, Callable<CheckResult> resultSupplier, boolean writeCache) {
        String _cacheKey = module.getConfigName() + "@" + cacheKey;
        CheckResult cached = (CheckResult)this.CACHE_POOL.getIfPresent((Object)_cacheKey);
        if (cached == null) {
            try {
                cached = resultSupplier.call();
            }
            catch (Exception e) {
                log.warn("Unable to compute result", (Throwable)e);
            }
        }
        if (writeCache && cached != null && cached.action() != PeerAction.BAN) {
            this.CACHE_POOL.put((Object)_cacheKey, (Object)cached);
        }
        return cached;
    }

    @Subscribe
    public void onBtnRuleUpdated(BtnRuleUpdateEvent event) {
        this.CACHE_POOL.invalidateAll();
    }

    public void invalidateAll() {
        this.CACHE_POOL.invalidateAll();
    }
}

