/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.wrapper;

import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.google.common.net.HostAndPort;
import inet.ipaddr.IPAddress;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PeerAddress
implements Comparable<PeerAddress>,
Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PeerAddress.class);
    private String ip;
    private String rawIp;
    private String noNatIP;
    private transient IPAddress address;
    private int port;
    private int noNatPort;

    public PeerAddress(String ip, int port, String rawIp) {
        this.ip = ip;
        this.rawIp = rawIp;
        this.noNatIP = ip;
        this.port = port;
        this.noNatPort = port;
    }

    public PeerAddress setNat(String nattedIp, int nattedPort) {
        this.ip = nattedIp;
        this.rawIp = nattedIp;
        this.port = nattedPort;
        this.address = null;
        return this;
    }

    public IPAddress getAddress() {
        if (this.address == null) {
            this.address = IPAddressUtil.getIPAddress(this.ip).toPrefixBlock();
        }
        return this.address;
    }

    public String toString() {
        return HostAndPort.fromParts((String)this.ip, (int)this.port).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeerAddress that = (PeerAddress)o;
        return this.port == that.port && Objects.equals(this.ip, that.ip);
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.port);
    }

    @Override
    public int compareTo(PeerAddress o) {
        int r = this.ip.compareTo(o.ip);
        if (r == 0) {
            return Integer.compare(this.port, o.port);
        }
        return r;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getRawIp() {
        return this.rawIp;
    }

    @Generated
    public String getNoNatIP() {
        return this.noNatIP;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public int getNoNatPort() {
        return this.noNatPort;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setRawIp(String rawIp) {
        this.rawIp = rawIp;
    }

    @Generated
    public void setNoNatIP(String noNatIP) {
        this.noNatIP = noNatIP;
    }

    @Generated
    public void setAddress(IPAddress address) {
        this.address = address;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setNoNatPort(int noNatPort) {
        this.noNatPort = noNatPort;
    }

    @Generated
    public PeerAddress(String ip, String rawIp, String noNatIP, IPAddress address, int port, int noNatPort) {
        this.ip = ip;
        this.rawIp = rawIp;
        this.noNatIP = noNatIP;
        this.address = address;
        this.port = port;
        this.noNatPort = noNatPort;
    }

    @Generated
    public PeerAddress() {
    }
}

